set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9933915';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.223732,
      3,
      NULL,
      3,
      1,
      2.580230,
      0,
      NULL,
      '243',
      '40110331',
      0,
      24.716804,
      '0103143',
      0.498205,
      NULL,
      0,
      2,
      '0014',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-28-1994',
      174,
      NULL,
      NULL,
      2.090424,
      2.392559,
      '10-15-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 6-2000',
      1.965918,
      3.332577,
      0,
      2,
      0.351568,
      3.683443,
      0,
      1.788137,
      1,
      8.601278,
      7,
      6.438931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1.798917,
      0,
      0,
      1,
      1,
      0,
      1.294548,
      1.308211,
      0,
      0.848202,
      4,
      8,
      0,
      2,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      3,
      3,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      0.691439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      2,
      5,
      2,
      1,
      2,
      0,
      0,
      NULL,
      0,
      0,
      1,
      4,
      NULL,
      1,
      1,
      NULL,
      0.756003,
      NULL,
      0,
      2,
      0,
      0,
      NULL,
      2,
      NULL,
      2,
      4,
      5,
      4,
      1,
      0,
      4,
      4,
      4,
      2,
      2,
      5,
      5,
      3,
      4,
      3,
      0,
      0,
      2,
      1.271978,
      0,
      ' 8- 7-1983',
      236,
      ' 0-23-1989',
      136,
      NULL,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      2,
      2,
      0.420813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.955044,
      7.749615,
      7,
      0.793451,
      3.791782,
      1.543572,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.242414,
      0,
      0.632446,
      NULL,
      1,
      2,
      9.549808,
      NULL,
      1.809890,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.571842,
      2,
      3,
      0,
      2,
      NULL,
      3,
      0,
      3,
      2,
      3,
      2.188574,
      3,
      1,
      2.742937,
      NULL,
      0.004839,
      0,
      1,
      1.829935,
      0,
      1.337180,
      1,
      0,
      NULL,
      1.546618,
      NULL,
      1,
      3.225153,
      1,
      8.635695,
      NULL,
      NULL,
      5,
      3.389133,
      2.621648,
      3.217304,
      1.456754,
      1,
      NULL,
      NULL,
      2.870675,
      2.598550,
      NULL,
      1,
      38,
      NULL,
      0,
      20.293988,
      4,
      3.945502,
      3.888314,
      '24302',
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      0.797698,
      NULL,
      NULL,
      '',
      NULL,
      12,
      53.823928,
      27.140502,
      0.367635,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      2.784738,
      1.828006,
      1.264492,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      4,
      1,
      1,
      1.672039,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.452926,
      1.768775,
      NULL,
      0,
      NULL,
      0,
      0,
      2,
      0,
      1,
      0.973414,
      1.182062,
      0,
      1,
      1.184462,
      1.205468,
      NULL,
      1,
      1.874326,
      1.696144,
      1,
      1,
      1,
      1.200214,
      0.573142,
      NULL,
      3.596519,
      NULL,
      NULL,
      NULL,
      NULL,
      2.702398,
      1.960358,
      0,
      4.384624,
      2.667273,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1.588467,
      NULL,
      NULL,
      NULL,
      1,
      1.783191,
      NULL,
      2.073691,
      NULL,
      4.546919,
      0.584166,
      2.419948,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3,
      6.444008,
      4.930625,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.811444,
      NULL,
      NULL,
      0.389230,
      3.442696,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      7.126362,
      5,
      6,
      4,
      7.052365,
      NULL,
      NULL,
      4,
      0.740515,
      0,
      0.049174,
      1,
      NULL,
      1,
      2,
      0.410210,
      NULL,
      0,
      1,
      2.471386,
      0.904880,
      1,
      1.958528,
      0.016200,
      2,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3.094715,
      6,
      8,
      NULL,
      4.437131,
      5,
      NULL,
      1,
      0,
      NULL,
      1.174863,
      1.104353,
      NULL,
      0.511857,
      1.944868,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868173,
      NULL,
      NULL,
      0.880345,
      NULL,
      NULL,
      1.727175,
      NULL,
      NULL,
      1.105237,
      NULL,
      NULL,
      0.830054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.687231,
      0,
      1,
      1.788590,
      3,
      1.973044,
      NULL,
      NULL,
      3.004596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.678907,
      NULL,
      NULL,
      NULL,
      3.463427,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.771734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.486618,
      NULL,
      NULL,
      NULL,
      0.564295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.450249,
      48,
      9.281920,
      NULL,
      26.285354,
      2,
      0,
      NULL,
      NULL,
      0.281694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793318,
      NULL,
      NULL,
      1.664041,
      NULL,
      0.740316,
      124.726696,
      34.863579,
      0.509218,
      2,
      1,
      NULL,
      1,
      0.656393,
      1.636505,
      NULL,
      0.811867,
      0.620973,
      0,
      1.599780,
      0.721391,
      0,
      0,
      1.019893,
      1,
      0,
      NULL,
      1.293171,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      50.666908,
      NULL,
      1.243122,
      2.893358,
      4.963162,
      1,
      2.381336,
      9,
      NULL,
      0.713583,
      NULL,
      0.189860,
      NULL,
      1.369479,
      NULL,
      NULL,
      NULL,
      1.884668,
      NULL,
      0.675096,
      NULL,
      3,
      NULL,
      0.066475,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.695880,
      NULL,
      NULL,
      NULL,
      1,
      3.926327,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.457204,
      NULL,
      1,
      NULL,
      185.492874,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.501699,
      NULL,
      0.870512,
      NULL,
      0.051965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358847,
      0.654667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.170857,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.318651,
      2,
      NULL,
      NULL,
      NULL,
      1.167715,
      NULL,
      208.120701,
      NULL,
      0.929117,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      5.604238,
      1,
      NULL,
      NULL,
      2.223480,
      8,
      3,
      3,
      0,
      4.365960,
      2.187703,
      5,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.916195,
      NULL,
      0,
      2,
      NULL,
      0.237270,
      NULL,
      NULL,
      2.263317,
      NULL,
      NULL,
      0.252624,
      0.488104,
      NULL,
      1,
      2,
      NULL,
      2,
      2.049814,
      NULL,
      1,
      1.064082,
      NULL,
      NULL,
      0,
      NULL,
      0.401779,
      NULL,
      NULL,
      2,
      1,
      1.869217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.819772,
      NULL,
      NULL,
      6,
      NULL,
      0,
      NULL,
      NULL,
      44.456875,
      65,
      NULL,
      NULL,
      0,
      '03422',
      NULL,
      NULL,
      0.701219,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


