set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5808669';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '4201231',
      3,
      0.557339,
      3,
      3,
      '3301',
      NULL,
      0.513962,
      NULL,
      12,
      ' 0-15-1990',
      11.996635,
      NULL,
      2,
      0.808818,
      NULL,
      ' 8-18-1994',
      29,
      3.897842,
      285.339936,
      72,
      4,
      NULL,
      NULL,
      NULL,
      0,
      1.674009,
      1.042677,
      NULL,
      1.623579,
      3.417288,
      8,
      0,
      1,
      NULL,
      2,
      NULL,
      11.595083,
      149.514308,
      173,
      0,
      2.299725,
      1,
      0,
      6.628850,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1.052804,
      0.655641,
      160.955756,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      4,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      2,
      NULL,
      3,
      1,
      NULL,
      5,
      1,
      2,
      0,
      1,
      NULL,
      3,
      NULL,
      5,
      2,
      NULL,
      3,
      1,
      3,
      1.584656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.078856,
      NULL,
      0.837205,
      1.578374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234644,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.864393,
      1.979090,
      1,
      NULL,
      NULL,
      0.302729,
      NULL,
      NULL,
      1.770410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      34,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378598,
      0.300159,
      '01231',
      NULL,
      NULL,
      1.599264,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      3,
      14.339795,
      295.241073,
      25.763881,
      1.655034,
      40,
      9,
      NULL,
      5,
      3.371984,
      2.328466,
      1,
      3.150796,
      1,
      1.545799,
      1.588921,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.275840,
      1,
      0.015011,
      NULL,
      NULL,
      NULL,
      NULL,
      0.034681,
      0.431204,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.599247,
      NULL,
      NULL,
      1.992754,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.865192,
      2,
      1.174488,
      1,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.239213,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.627523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.499078,
      0.734261,
      0.084758,
      NULL,
      NULL,
      NULL,
      NULL,
      0.869662,
      0.277565,
      1.815459,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.640905,
      1.006028,
      1.313409,
      NULL,
      NULL,
      1.703321,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.198124,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.030871,
      NULL,
      NULL,
      1.222743,
      NULL,
      4.237417,
      0,
      1.320233,
      2,
      NULL,
      NULL,
      2.676979,
      NULL,
      NULL,
      3,
      0,
      1.595404,
      0,
      11,
      0.454803,
      1,
      13.869096,
      1.504096,
      5.320235,
      NULL,
      6,
      3.925688,
      17.467577,
      2,
      2,
      15,
      NULL,
      0.441886,
      0,
      1,
      0,
      3.666893,
      NULL,
      4.873349,
      0,
      1.331628,
      7,
      NULL,
      1,
      0,
      0,
      NULL,
      3,
      2.265373,
      3,
      0.856006,
      0,
      0,
      3.881670,
      NULL,
      NULL,
      100,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.142245,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.769807,
      NULL,
      NULL,
      3.386478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.713968,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.838846,
      NULL,
      0,
      2.492818,
      3,
      NULL,
      NULL,
      0.393763,
      1.797676,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355947,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.378959,
      NULL,
      NULL,
      NULL,
      3.781268,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.419340,
      NULL,
      NULL,
      NULL,
      1.636810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.334126,
      NULL,
      NULL,
      NULL,
      14.782178,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.750857,
      9.338177,
      NULL,
      3,
      1,
      236.986253,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228195,
      NULL,
      NULL,
      NULL,
      264.364781,
      24.336830,
      3,
      NULL,
      6,
      3,
      3.531091,
      1,
      11277,
      NULL,
      0.611995,
      1.227334,
      NULL,
      0.377003,
      1.498909,
      0,
      1,
      0,
      1,
      1,
      0.114246,
      0,
      1.650078,
      1.757750,
      1.047144,
      0,
      1,
      0.490363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      0,
      3,
      3,
      6,
      3,
      1.509220,
      3,
      2,
      10.792238,
      1.148346,
      12.225301,
      1.939928,
      NULL,
      3.939015,
      18.542357,
      0,
      NULL,
      NULL,
      3,
      1.362223,
      1.374200,
      0,
      2.130262,
      2.933534,
      2.604499,
      0,
      1,
      1.903989,
      11,
      NULL,
      0,
      0.338400,
      0,
      1,
      1.042794,
      3,
      0.659144,
      2.322582,
      9,
      3,
      0.278604,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.662967,
      1,
      1,
      NULL,
      4,
      2,
      7,
      1,
      2,
      0.034315,
      79,
      NULL,
      NULL,
      0.614969,
      0,
      '22242',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


