set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7001218';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-4-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '4200424',
      1.064690,
      1.127060,
      0,
      NULL,
      '2320',
      2,
      0,
      NULL,
      NULL,
      NULL,
      43,
      NULL,
      4,
      1.677740,
      1,
      ' 8-18-1998',
      58.762488,
      2.406383,
      NULL,
      39.303867,
      0,
      ' 4- 3-1983',
      ' 0-25-1997',
      ' 4-29-1974',
      2.643747,
      0.739417,
      0,
      NULL,
      0,
      1.238872,
      0,
      0.148217,
      1,
      0.255777,
      3,
      8,
      1.360949,
      NULL,
      187,
      0,
      27.291310,
      0,
      1,
      NULL,
      1.640533,
      2,
      NULL,
      1,
      0,
      0,
      1.983782,
      0.209251,
      1.596245,
      0.302196,
      1,
      1,
      0,
      NULL,
      2,
      5,
      1,
      0,
      NULL,
      0,
      NULL,
      4,
      NULL,
      0,
      1,
      0,
      0,
      9,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.389938,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.051426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      1,
      2,
      2,
      1,
      5,
      2,
      NULL,
      0,
      1,
      0,
      8.100963,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      2.827958,
      1,
      0,
      3,
      0,
      3,
      0,
      3,
      4,
      5,
      1,
      2,
      2,
      0,
      5,
      5,
      1,
      NULL,
      5,
      2,
      3,
      NULL,
      3,
      NULL,
      2,
      2,
      9,
      1.392177,
      ' 2-18-1980',
      NULL,
      NULL,
      990,
      1,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.118798,
      1,
      1.505447,
      1.258606,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.532946,
      1.610235,
      1.988443,
      NULL,
      0.440289,
      NULL,
      0,
      114,
      2.741410,
      2,
      2,
      NULL,
      1568,
      2,
      1.243559,
      0.779819,
      0,
      3,
      0,
      3,
      3,
      0,
      3,
      0,
      NULL,
      0,
      NULL,
      2.997683,
      3,
      NULL,
      0.939518,
      1.606478,
      1.547124,
      0.261667,
      NULL,
      0,
      0.773123,
      1,
      1.419166,
      0,
      1.402075,
      1,
      1,
      2.578599,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445105,
      NULL,
      43,
      9,
      39,
      1,
      1.453695,
      NULL,
      '22131',
      NULL,
      '',
      1.360866,
      '',
      NULL,
      '',
      0.472665,
      '',
      '',
      '',
      1,
      13.992802,
      NULL,
      58,
      1.329937,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882759,
      NULL,
      NULL,
      1.397170,
      0,
      0.246800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.889783,
      NULL,
      NULL,
      0.020616,
      NULL,
      NULL,
      1.273722,
      NULL,
      NULL,
      10.474193,
      2.270870,
      NULL,
      1,
      1.793284,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.192761,
      NULL,
      3.444290,
      1.673609,
      0,
      0.342554,
      3.247258,
      0.877344,
      1,
      NULL,
      1,
      1.884586,
      2.184386,
      2.939893,
      2,
      NULL,
      2.177249,
      3,
      1,
      NULL,
      1.392513,
      0,
      0,
      0.589906,
      1.802076,
      0.107986,
      NULL,
      NULL,
      0.254630,
      NULL,
      NULL,
      3.607437,
      1,
      1.433881,
      8.511595,
      1.233282,
      4.771212,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      4,
      0,
      9.391448,
      NULL,
      2.808843,
      2,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      7.544649,
      1.886014,
      NULL,
      NULL,
      0.308031,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.137545,
      1,
      3,
      10.717278,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.274068,
      1,
      0.540571,
      3.868009,
      4,
      1.629068,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      3.226562,
      0.199158,
      NULL,
      2,
      3,
      2.867191,
      NULL,
      3,
      3.115472,
      1.605270,
      0,
      1,
      0,
      2,
      2.686412,
      1.376220,
      3.137796,
      0.933385,
      NULL,
      2,
      3.975629,
      8.689405,
      6.530543,
      5.909856,
      9,
      1.102519,
      NULL,
      3.444036,
      4,
      3,
      0.702411,
      0.676724,
      0.954709,
      1.227613,
      1,
      3.299439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.112570,
      NULL,
      NULL,
      2.738288,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.687920,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.044227,
      0,
      1.817263,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.316311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.322613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.076098,
      NULL,
      NULL,
      NULL,
      1,
      474,
      1501,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.568420,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.311058,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5048,
      509,
      NULL,
      2,
      NULL,
      NULL,
      0.063304,
      0.064837,
      1.584006,
      1.379782,
      0,
      1,
      1,
      0.185058,
      0,
      1,
      1.254980,
      0.588091,
      NULL,
      3.131791,
      NULL,
      1.304186,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      135.413742,
      NULL,
      NULL,
      40.216150,
      69.416905,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.136982,
      NULL,
      0.139848,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.565848,
      NULL,
      1.828732,
      NULL,
      2.718072,
      NULL,
      0.359024,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.770264,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.944632,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.918640,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.678032,
      0.772344,
      NULL,
      0.758972,
      NULL,
      NULL,
      0.295877,
      0,
      NULL,
      1,
      0.569981,
      NULL,
      0,
      3,
      NULL,
      0.971776,
      0.989844,
      NULL,
      2,
      NULL,
      0.324168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.965304,
      NULL,
      1,
      NULL,
      1.583440,
      NULL,
      2,
      2,
      NULL,
      0.709505,
      0,
      1.505032,
      63,
      35,
      4,
      0,
      3.379647,
      '02120',
      '',
      '',
      1.292574,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


