set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8514320';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-10-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      0,
      0.278846,
      0,
      1,
      '3131',
      1,
      0,
      NULL,
      NULL,
      NULL,
      4.704721,
      NULL,
      3,
      1,
      1.249048,
      ' 9-12-1977',
      10.245037,
      5.865609,
      336.666305,
      NULL,
      3,
      ' 9- 3-1997',
      '10- 3-1999',
      ' 7-25-1976',
      0.090294,
      1.530319,
      NULL,
      1.038996,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      18,
      7.003851,
      9,
      32.777642,
      NULL,
      14.356101,
      2,
      0,
      3.151947,
      1.365754,
      NULL,
      NULL,
      0,
      1,
      1.789946,
      NULL,
      0,
      2,
      NULL,
      0.495547,
      3,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      5,
      0,
      NULL,
      0,
      1,
      3,
      1,
      0,
      1,
      9.316208,
      0,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      0.872098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      3,
      0,
      4,
      1,
      0,
      3,
      0,
      4,
      1,
      4,
      2,
      4,
      4,
      0,
      NULL,
      0,
      0.997586,
      ' 7-18-1974',
      311,
      ' 1-29-2000',
      759,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      8,
      1,
      0.113994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691778,
      NULL,
      0.473439,
      0.643634,
      0,
      0.318378,
      NULL,
      NULL,
      NULL,
      NULL,
      1.682305,
      0.232495,
      1.258759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832703,
      NULL,
      0,
      1,
      0.875809,
      0.312534,
      1.245692,
      1.744550,
      69,
      2.530690,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314070,
      10,
      6,
      7,
      5,
      2.744535,
      NULL,
      4,
      3.264209,
      4,
      2,
      1,
      0.936001,
      20,
      NULL,
      0,
      NULL,
      NULL,
      5,
      11,
      0,
      0,
      1.533121,
      '13033',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.285037,
      '',
      '',
      '',
      3.878219,
      4.218010,
      366,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.481368,
      0.976672,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.552492,
      2.216982,
      3,
      NULL,
      13,
      18.966459,
      NULL,
      NULL,
      NULL,
      NULL,
      6.922957,
      15.454264,
      NULL,
      NULL,
      NULL,
      1.812571,
      NULL,
      NULL,
      1.687859,
      NULL,
      NULL,
      1.282463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.431776,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.084411,
      NULL,
      NULL,
      NULL,
      2.648533,
      8.502694,
      4,
      0.369252,
      NULL,
      NULL,
      0.829487,
      NULL,
      NULL,
      0.987159,
      1.893258,
      0.677419,
      0,
      NULL,
      1.502002,
      0.463672,
      NULL,
      0.119144,
      0.416156,
      0,
      0,
      1.725713,
      0.679880,
      0,
      0,
      0,
      NULL,
      NULL,
      0.686906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.815930,
      2.011386,
      1.715613,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.275610,
      NULL,
      NULL,
      NULL,
      2.948349,
      NULL,
      13.649690,
      1.775407,
      5,
      11,
      1,
      NULL,
      6,
      0.066381,
      NULL,
      NULL,
      7,
      1.578823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.669062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.644280,
      0.653938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      17,
      2.531826,
      1,
      NULL,
      NULL,
      8.536565,
      3.295832,
      5.583936,
      0.249498,
      NULL,
      6,
      0,
      6,
      15.119737,
      2.365564,
      19,
      0.373276,
      NULL,
      8,
      13.857495,
      NULL,
      3.736352,
      8.225069,
      1,
      NULL,
      NULL,
      0,
      4,
      2,
      1.725536,
      1,
      0,
      1,
      0.219376,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089022,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.501515,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.656150,
      1.897944,
      0.665989,
      0,
      1.974293,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673116,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      0.036140,
      NULL,
      NULL,
      NULL,
      1.639606,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.567593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154035,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      14147,
      1110.482903,
      NULL,
      1,
      1.261837,
      1.593885,
      NULL,
      0,
      1.574408,
      1.164503,
      1,
      1,
      0.618121,
      1,
      NULL,
      0.913107,
      0.387388,
      NULL,
      1.483637,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.456252,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      12.512784,
      11,
      NULL,
      15,
      16,
      NULL,
      NULL,
      9.577826,
      NULL,
      16,
      3,
      NULL,
      11,
      3,
      NULL,
      11.877649,
      NULL,
      NULL,
      7.337201,
      1.820900,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      11.777290,
      NULL,
      NULL,
      0.902274,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484599,
      0.870346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.656989,
      NULL,
      1,
      NULL,
      1,
      6,
      2,
      NULL,
      NULL,
      1,
      NULL,
      79,
      3,
      0.182789,
      1.504034,
      '21134',
      '',
      '',
      0,
      '',
      '',
      '',
      1.213676,
      '',
      '',
      '');
commit;
end;
/


