set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7100746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '0241210',
      1.463118,
      0.504525,
      1,
      2,
      '4004',
      2.681953,
      NULL,
      NULL,
      NULL,
      ' 9-20-1987',
      7,
      NULL,
      4,
      2,
      0,
      ' 2- 7-1984',
      1,
      2,
      NULL,
      376.223649,
      0,
      ' 0-25-1982',
      '10-14-1987',
      ' 9-17-1976',
      1,
      NULL,
      1.697370,
      1.298097,
      1,
      0.050035,
      NULL,
      0.990213,
      1.952520,
      152,
      6,
      6.329179,
      5.885095,
      187,
      109,
      1,
      12,
      2,
      3,
      8.180986,
      1,
      0,
      1,
      0.042576,
      1.285938,
      NULL,
      0,
      0.972829,
      0,
      0,
      117,
      6,
      NULL,
      4,
      NULL,
      2,
      1,
      1,
      0,
      1,
      NULL,
      3,
      0,
      5,
      0,
      1,
      0,
      9.417886,
      0,
      1,
      2,
      0,
      0.105662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2.777764,
      0,
      0,
      1.015607,
      1.531866,
      1,
      0,
      1,
      0.348923,
      0.113380,
      0.035472,
      1,
      0.058225,
      NULL,
      0.147562,
      1,
      NULL,
      0,
      0,
      NULL,
      0.226808,
      1,
      2,
      3.185412,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      5,
      NULL,
      2,
      0,
      2,
      1,
      0,
      1,
      1,
      1.327719,
      NULL,
      0,
      1,
      1,
      0.474041,
      NULL,
      1.768679,
      3,
      5,
      0,
      0,
      0,
      3,
      0,
      2,
      0,
      2,
      3,
      0,
      3,
      2,
      3,
      3,
      4,
      NULL,
      3,
      0,
      0,
      4,
      1,
      1,
      NULL,
      NULL,
      1.439960,
      '11-11-1977',
      1239,
      ' 8- 3-1999',
      1512,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      0,
      4.192411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.655252,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.294226,
      0,
      1,
      1,
      1.268407,
      0.106515,
      0,
      3.872487,
      3980.669413,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      26,
      39.625188,
      0,
      1.886081,
      NULL,
      NULL,
      NULL,
      '',
      0.909256,
      NULL,
      '',
      '',
      1.852021,
      '0234',
      '',
      '',
      NULL,
      36.019577,
      NULL,
      35.741009,
      2,
      NULL,
      13,
      46.125446,
      4,
      0.789531,
      NULL,
      0.910584,
      0.067758,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.395611,
      NULL,
      NULL,
      0,
      1.271685,
      0,
      0,
      NULL,
      NULL,
      3,
      3,
      3,
      2.023102,
      0.972747,
      1,
      1,
      2.154330,
      3.042578,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0,
      1.380091,
      NULL,
      NULL,
      NULL,
      1.428161,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.490023,
      2,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      1.509634,
      0.439429,
      NULL,
      1.272775,
      0.833646,
      1.270325,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1.718098,
      1,
      1.177223,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      0.633105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684496,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      1.391065,
      1.625075,
      1,
      NULL,
      NULL,
      7.028132,
      1,
      1,
      0,
      NULL,
      NULL,
      0.438387,
      NULL,
      NULL,
      NULL,
      4,
      0.519085,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2,
      0,
      0.506736,
      NULL,
      5,
      3.055483,
      NULL,
      2.693031,
      3.054239,
      1.350673,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.828797,
      2,
      2,
      0.064256,
      NULL,
      NULL,
      6,
      6,
      NULL,
      2.175589,
      NULL,
      2.876797,
      NULL,
      NULL,
      2,
      2.647089,
      2,
      1.438332,
      NULL,
      0.086529,
      NULL,
      1.131663,
      NULL,
      10.572674,
      2.126994,
      NULL,
      NULL,
      0,
      3,
      2,
      1.132274,
      1,
      NULL,
      0,
      1.739470,
      3,
      NULL,
      NULL,
      1.445258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.284329,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.052366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205881,
      NULL,
      NULL,
      0.234729,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.312889,
      0.323278,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.289980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.153381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365535,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      0.562922,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      823,
      539.732317,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.005243,
      14050,
      1700,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.586099,
      0.564763,
      0,
      0.525302,
      1.916701,
      0.424047,
      NULL,
      1.954427,
      1.881328,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357273,
      1.971263,
      0,
      1.836912,
      NULL,
      4.533527,
      3.830302,
      3.769089,
      1,
      19.006507,
      18.274833,
      NULL,
      NULL,
      NULL,
      NULL,
      19.760828,
      17,
      NULL,
      7,
      4,
      NULL,
      NULL,
      6,
      NULL,
      2,
      17.478505,
      NULL,
      11,
      18.946921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      13.004200,
      NULL,
      0.950501,
      1.776053,
      0.096550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.027530,
      NULL,
      0.703587,
      NULL,
      4,
      4,
      7,
      2.331674,
      NULL,
      3,
      7,
      41,
      0,
      NULL,
      3,
      '31413',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      1,
      '3411',
      '',
      '');
commit;
end;
/


