set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7100746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43',
      '44',
      12.798807,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      '0414',
      5.431257,
      1.783006,
      NULL,
      NULL,
      ' 1- 0-2001',
      31,
      0.208300,
      NULL,
      2,
      0,
      ' 4-21-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 7-1975',
      ' 5-22-1981',
      2.660071,
      0,
      NULL,
      1.540325,
      0.197648,
      0.272103,
      0,
      NULL,
      0,
      71.645737,
      1,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      0.486680,
      0,
      0,
      1,
      NULL,
      0,
      6,
      3,
      0,
      5,
      0,
      1,
      3,
      NULL,
      3,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.399074,
      NULL,
      0,
      0,
      2,
      0.556770,
      0.598644,
      0.601235,
      0,
      NULL,
      0,
      1,
      0,
      2.646345,
      1.511516,
      3,
      0,
      3,
      0,
      1,
      5.414542,
      0,
      1,
      3,
      0.549057,
      NULL,
      NULL,
      1.083650,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      5,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      1.660660,
      1,
      0,
      1,
      1,
      0.205679,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      5,
      1,
      4,
      NULL,
      2,
      1,
      5,
      0,
      3,
      0,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2,
      5,
      3,
      0.343592,
      1.619946,
      NULL,
      879.395275,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      1,
      1,
      0,
      4,
      1.757821,
      1.961594,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.885335,
      1,
      5,
      NULL,
      1,
      4,
      1.644221,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.385915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1.440481,
      1,
      0.739696,
      NULL,
      0,
      5,
      NULL,
      1.406702,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.135683,
      1,
      1,
      0,
      3,
      3,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0.096936,
      3,
      NULL,
      NULL,
      1.193375,
      1,
      0,
      0.445470,
      0,
      0.291251,
      0,
      NULL,
      0,
      1.289064,
      0,
      1.520004,
      NULL,
      0.624470,
      10,
      0.398295,
      5.544637,
      9,
      10.423762,
      1.297335,
      4,
      0.823046,
      NULL,
      0.780543,
      0,
      0.073200,
      21,
      NULL,
      NULL,
      7,
      NULL,
      55,
      4.882078,
      3,
      2,
      NULL,
      '21001',
      NULL,
      '',
      1.796346,
      '',
      '',
      NULL,
      NULL,
      '31240',
      '40202',
      '',
      NULL,
      NULL,
      231,
      36,
      0.695152,
      14,
      NULL,
      NULL,
      0,
      2,
      1.778249,
      0,
      0,
      NULL,
      NULL,
      1.678858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852165,
      NULL,
      NULL,
      1.290694,
      0.471486,
      0,
      0.435137,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      3.867516,
      3.739643,
      NULL,
      1.504164,
      2.963477,
      3,
      2.183760,
      1.128861,
      NULL,
      NULL,
      7,
      5,
      0.663983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.839637,
      0.242317,
      2.962129,
      NULL,
      NULL,
      1.839473,
      1.602314,
      0.113971,
      1,
      1,
      NULL,
      0,
      1.290887,
      3,
      2,
      1.759465,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.470317,
      NULL,
      NULL,
      NULL,
      0.394765,
      NULL,
      NULL,
      NULL,
      1.689348,
      0.216700,
      0.349016,
      NULL,
      3,
      0,
      2.704858,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8.342160,
      1,
      2,
      0.579577,
      0.479628,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.885979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.963974,
      1.083565,
      NULL,
      1.878998,
      NULL,
      0,
      6.654529,
      NULL,
      NULL,
      1,
      NULL,
      2.903901,
      0,
      NULL,
      NULL,
      2.408626,
      1.239995,
      1,
      1,
      0,
      1,
      0.036276,
      NULL,
      NULL,
      3,
      8,
      NULL,
      0.070175,
      1,
      0,
      2,
      3,
      1.716361,
      0,
      NULL,
      0.428731,
      0.508229,
      1,
      NULL,
      9,
      8,
      5,
      6,
      0,
      2,
      3,
      4,
      0,
      0,
      0,
      NULL,
      0.386603,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.419729,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.475715,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0.444759,
      0.264141,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.768713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.201698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.916175,
      NULL,
      2,
      2,
      0,
      NULL,
      341.134977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.757021,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.994234,
      NULL,
      NULL,
      0,
      NULL,
      0,
      437,
      NULL,
      1.815387,
      1,
      NULL,
      0.926743,
      0.668807,
      1.381165,
      0.666770,
      1,
      0.807783,
      1.124525,
      0,
      0.602866,
      NULL,
      1.265849,
      1.210245,
      0,
      1,
      1.224952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3,
      0,
      NULL,
      3,
      3,
      7,
      1,
      2,
      0.533082,
      1.776747,
      NULL,
      NULL,
      0,
      1.037256,
      NULL,
      2.170366,
      2.215958,
      NULL,
      0.715525,
      1.662961,
      NULL,
      NULL,
      0.798523,
      NULL,
      1,
      1.658162,
      NULL,
      0.516969,
      NULL,
      NULL,
      NULL,
      0.802760,
      NULL,
      1.509707,
      1.534260,
      NULL,
      0.912574,
      0.009900,
      NULL,
      0,
      0.981823,
      NULL,
      2.287032,
      0,
      1.029361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333613,
      NULL,
      NULL,
      NULL,
      1.279187,
      NULL,
      2,
      5,
      NULL,
      2,
      0,
      0.915255,
      56,
      31,
      5,
      NULL,
      2.098832,
      '20322',
      '',
      '',
      0.424886,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '20041',
      '');
commit;
end;
/


