set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8002651';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '4242204',
      1,
      1.837525,
      2,
      1,
      '1324',
      NULL,
      1.079409,
      1,
      1.759280,
      ' 3- 4-1975',
      14,
      NULL,
      3,
      1.853212,
      1.448483,
      '10-16-1989',
      56.383326,
      1.490848,
      220,
      22,
      0,
      ' 0-12-1981',
      NULL,
      NULL,
      2,
      1.257546,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.261211,
      141,
      2,
      3,
      2.039894,
      5.252455,
      12.781760,
      NULL,
      22,
      5,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.090693,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      NULL,
      0,
      0,
      3,
      NULL,
      5,
      1,
      0,
      1,
      5.415119,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      2,
      1,
      5,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1.261957,
      NULL,
      1.911134,
      0,
      2,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      2,
      0,
      2,
      2,
      0,
      3,
      0,
      3,
      4,
      4,
      1,
      2,
      2.159403,
      0.384573,
      ' 3- 7-1992',
      11.599510,
      ' 4-23-1974',
      900,
      1.483866,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1.675679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0.534517,
      0.542903,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.251386,
      1.100198,
      0.068305,
      0.497488,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.919256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.423970,
      2,
      1.330731,
      NULL,
      0,
      72,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.174511,
      1,
      NULL,
      3,
      3,
      0,
      2,
      0,
      3,
      3,
      1,
      NULL,
      2.641687,
      12.561787,
      19,
      NULL,
      NULL,
      1,
      3.785255,
      0.621037,
      NULL,
      NULL,
      0.455937,
      0.655538,
      1.537510,
      NULL,
      0.900767,
      0,
      13,
      NULL,
      NULL,
      1,
      NULL,
      3,
      4.451478,
      NULL,
      4,
      5.713672,
      2.917817,
      NULL,
      NULL,
      2,
      0,
      20,
      3,
      NULL,
      NULL,
      40,
      NULL,
      1,
      1,
      0,
      3.710115,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.375332,
      '',
      '',
      '',
      1.178535,
      22,
      215,
      41,
      NULL,
      18.218585,
      7.086673,
      11.627454,
      4,
      3.950555,
      0.474304,
      1.714297,
      0.002427,
      NULL,
      NULL,
      1.101897,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.284313,
      11.656021,
      12,
      1,
      NULL,
      NULL,
      0,
      1,
      0.000150,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.963526,
      NULL,
      3,
      NULL,
      0.513584,
      NULL,
      NULL,
      NULL,
      1.089787,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.271543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187516,
      NULL,
      NULL,
      0.163095,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.062387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.775822,
      NULL,
      1,
      0,
      0.026814,
      NULL,
      NULL,
      NULL,
      NULL,
      4.773774,
      2.842280,
      1.060272,
      NULL,
      0,
      3,
      1.756844,
      1,
      NULL,
      NULL,
      0.402952,
      0,
      NULL,
      NULL,
      0.057402,
      NULL,
      NULL,
      1.526877,
      NULL,
      NULL,
      1.094383,
      NULL,
      NULL,
      1.903697,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      0.146916,
      1.938822,
      1.349467,
      1.461939,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.780205,
      1.822693,
      1.212097,
      2,
      0,
      1.137539,
      0.478322,
      0.844924,
      1,
      0,
      1,
      2,
      5.442713,
      NULL,
      NULL,
      1,
      NULL,
      3,
      2.305186,
      3,
      0,
      0,
      0,
      0.509403,
      1,
      2,
      3,
      1.275398,
      8,
      3,
      6,
      4,
      3,
      2,
      4,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188390,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.778601,
      NULL,
      NULL,
      1.040825,
      NULL,
      NULL,
      0.261207,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.710128,
      NULL,
      NULL,
      7.369603,
      NULL,
      NULL,
      1.344640,
      0.284005,
      3,
      0.371044,
      NULL,
      3.231008,
      NULL,
      NULL,
      4.405423,
      5.715536,
      NULL,
      NULL,
      3.823236,
      9,
      NULL,
      NULL,
      1,
      0.199821,
      NULL,
      NULL,
      1.148980,
      1,
      NULL,
      NULL,
      1.296096,
      2.296877,
      NULL,
      NULL,
      1,
      2.064847,
      NULL,
      NULL,
      0.498336,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.549743,
      1,
      NULL,
      NULL,
      0.286641,
      NULL,
      NULL,
      NULL,
      NULL,
      0.115484,
      NULL,
      NULL,
      1.223516,
      NULL,
      NULL,
      NULL,
      2,
      2.120867,
      NULL,
      NULL,
      0,
      2.727281,
      NULL,
      NULL,
      0.170785,
      NULL,
      NULL,
      NULL,
      0.299492,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1.385532,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      110,
      0.944840,
      NULL,
      NULL,
      NULL,
      0.138399,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.070760,
      NULL,
      NULL,
      0.851452,
      NULL,
      NULL,
      3,
      2.491524,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339941,
      NULL,
      0,
      19038.297136,
      0.211953,
      NULL,
      1.798938,
      0.751206,
      1,
      0,
      1,
      NULL,
      0,
      0.795560,
      NULL,
      0,
      0,
      1,
      0,
      1.030386,
      1.444446,
      0.825677,
      1.313772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.994667,
      5.571121,
      0,
      NULL,
      2,
      18,
      1,
      2,
      0,
      1.687036,
      NULL,
      NULL,
      2.805854,
      0,
      NULL,
      3.243497,
      3,
      NULL,
      NULL,
      0.666381,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.445714,
      NULL,
      1,
      NULL,
      NULL,
      3.179108,
      2,
      NULL,
      1,
      1.602630,
      NULL,
      2.038305,
      1.071306,
      NULL,
      0,
      2.852665,
      NULL,
      3,
      1,
      0.990883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.639456,
      1,
      NULL,
      3,
      NULL,
      2.632702,
      NULL,
      2,
      NULL,
      0.734547,
      NULL,
      1.011834,
      NULL,
      NULL,
      NULL,
      2.827557,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3.254345,
      NULL,
      3.520080,
      NULL,
      3,
      NULL,
      38.744626,
      0,
      NULL,
      0.665997,
      NULL,
      NULL,
      NULL,
      1.107843,
      NULL,
      3,
      0,
      5,
      0.490851,
      0.255596,
      3.710926,
      NULL,
      74.858732,
      4,
      0,
      3.782555,
      '31312',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


