set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3372312';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      3,
      1.565171,
      0,
      2,
      1.855625,
      1.636556,
      3.624550,
      '134',
      '30424202',
      40,
      32.813334,
      '4044123',
      0.945490,
      0,
      2,
      1,
      '2421',
      3.414213,
      1.404750,
      NULL,
      NULL,
      ' 6-21-1994',
      3,
      35,
      NULL,
      1.465149,
      1.014431,
      ' 2-10-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 6-20-2002',
      3.986857,
      0.302331,
      1.735750,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.053815,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.204467,
      0,
      1,
      NULL,
      1.361940,
      1.499528,
      0.615238,
      1,
      0.248809,
      1.805932,
      0.639676,
      9,
      NULL,
      1,
      0.198193,
      1,
      0,
      2,
      0,
      1,
      0,
      4,
      1,
      0,
      2,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.660464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3,
      4,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      4,
      0,
      1,
      3,
      3,
      NULL,
      4,
      1,
      0,
      1,
      1,
      0,
      1,
      4,
      3,
      3,
      1,
      3,
      2,
      2,
      1,
      5,
      NULL,
      1,
      1.323424,
      0.302214,
      ' 7- 4-1994',
      500.986506,
      ' 2-16-1987',
      197,
      2,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.074504,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.776865,
      2.206380,
      1,
      1,
      1.843220,
      0.077910,
      0,
      5,
      6.160334,
      7.535847,
      NULL,
      5,
      0.909542,
      NULL,
      NULL,
      NULL,
      1.559767,
      3,
      1,
      NULL,
      2,
      9.249693,
      NULL,
      413,
      ' 5-26-1981',
      179,
      NULL,
      NULL,
      0.074126,
      NULL,
      3.619129,
      1.945307,
      0.832899,
      0,
      NULL,
      1.601718,
      NULL,
      NULL,
      1.485353,
      1.125993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.061768,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      3,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1.253414,
      NULL,
      0.830910,
      0,
      NULL,
      0.854440,
      1.283770,
      0.547365,
      1,
      0.378643,
      0,
      1.267973,
      2.955219,
      0,
      11.226578,
      NULL,
      1.519548,
      9.269071,
      5.039128,
      3.430962,
      5.123416,
      0.791393,
      7,
      1,
      NULL,
      NULL,
      43,
      1,
      1.291426,
      79,
      NULL,
      NULL,
      NULL,
      0,
      4,
      4,
      NULL,
      '3421',
      '',
      3,
      '10342',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      2,
      29,
      95.255204,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.097443,
      0,
      NULL,
      NULL,
      0.707477,
      NULL,
      NULL,
      0.307873,
      NULL,
      NULL,
      1.191023,
      NULL,
      NULL,
      0.904091,
      NULL,
      NULL,
      1,
      NULL,
      1.868229,
      1.795712,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.348603,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.061137,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.600135,
      0.351229,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.858261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.307551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273345,
      2,
      2.599370,
      1,
      NULL,
      2,
      2.201856,
      NULL,
      4.246510,
      7,
      NULL,
      NULL,
      NULL,
      0.516182,
      NULL,
      NULL,
      1.315182,
      NULL,
      NULL,
      1.037414,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.166811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.412466,
      NULL,
      NULL,
      3.382345,
      5,
      1,
      NULL,
      NULL,
      NULL,
      2.489443,
      NULL,
      3,
      1.495433,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.099301,
      0,
      0,
      1.759331,
      NULL,
      0,
      1.494225,
      0.428529,
      1.305706,
      2,
      3,
      NULL,
      2,
      3,
      5,
      NULL,
      4.699780,
      1,
      NULL,
      NULL,
      2.907937,
      0,
      3,
      NULL,
      1.306688,
      0.265982,
      NULL,
      1.726207,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      0,
      1,
      1,
      3.782613,
      NULL,
      NULL,
      NULL,
      249,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.578224,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.504736,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.716885,
      NULL,
      NULL,
      NULL,
      3.323318,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.782690,
      NULL,
      NULL,
      NULL,
      0.181430,
      NULL,
      NULL,
      NULL,
      18,
      5,
      1.294991,
      NULL,
      NULL,
      0.287290,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      120.554991,
      1,
      0,
      1,
      0,
      1,
      0.965049,
      1.255649,
      0,
      0.117390,
      1.764157,
      1.927993,
      0.940192,
      NULL,
      1.198818,
      NULL,
      1.244752,
      1,
      0,
      0.294232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      6.167569,
      6.986110,
      2,
      2,
      1,
      NULL,
      1.220738,
      2,
      0,
      1.919864,
      1.001581,
      NULL,
      0,
      1,
      NULL,
      3.923375,
      1.089692,
      NULL,
      1,
      1.287130,
      NULL,
      0,
      0.579003,
      NULL,
      1,
      1.554990,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3.652213,
      NULL,
      3,
      3,
      NULL,
      0.984881,
      3,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.359897,
      NULL,
      0,
      NULL,
      1.366672,
      NULL,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      61,
      56.192906,
      5,
      2.701794,
      3.809860,
      NULL,
      '1240',
      '',
      NULL,
      '33424',
      '',
      '',
      1.342122,
      '',
      NULL,
      NULL);
commit;
end;
/


