set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9646454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      '13',
      4,
      5,
      '4412304',
      NULL,
      0.240488,
      2,
      1,
      '1024',
      4.137463,
      NULL,
      NULL,
      NULL,
      ' 6-26-2003',
      7.722809,
      55.487158,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 9- 0-1976',
      ' 3- 3-1988',
      NULL,
      3.811332,
      1.554811,
      1,
      NULL,
      NULL,
      3,
      4,
      1.890113,
      3,
      NULL,
      NULL,
      14.153773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.924765,
      0,
      1,
      1.231499,
      1.257434,
      1,
      NULL,
      NULL,
      0.994418,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0.546705,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      3.189715,
      0,
      0,
      1,
      NULL,
      0.299292,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      3,
      3,
      0,
      0.296040,
      1,
      0.564789,
      0,
      1,
      NULL,
      1.617561,
      0.303432,
      0.989344,
      0,
      0.728329,
      0.398969,
      1,
      0,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      2,
      4,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      2,
      NULL,
      5,
      5,
      4,
      5,
      NULL,
      4,
      5,
      NULL,
      3,
      0.098630,
      ' 5-22-1999',
      NULL,
      ' 4-19-2000',
      NULL,
      1,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.178228,
      NULL,
      1,
      NULL,
      1,
      0.652002,
      3,
      NULL,
      1,
      4,
      1.702522,
      NULL,
      NULL,
      NULL,
      0.949899,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.388578,
      3.569397,
      NULL,
      0.823090,
      NULL,
      1,
      1,
      NULL,
      198,
      3.848175,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.494218,
      3,
      1,
      0,
      2,
      2,
      0,
      2,
      NULL,
      3,
      0,
      0.481378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      9.103443,
      7.500707,
      NULL,
      NULL,
      3,
      4,
      NULL,
      1,
      1,
      2.156279,
      1,
      25,
      2,
      2.639476,
      47,
      NULL,
      39,
      5,
      3,
      2,
      0.995357,
      NULL,
      '',
      '',
      1.820149,
      '',
      '',
      NULL,
      1.182672,
      '0411',
      '',
      '',
      2.919257,
      33,
      214.912367,
      8.148836,
      2,
      NULL,
      1.111792,
      25,
      1,
      0,
      0.256554,
      0,
      0.548346,
      NULL,
      NULL,
      1.028416,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.980681,
      2.067187,
      3,
      3.182113,
      NULL,
      2.264896,
      0,
      0.095776,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.874033,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4.387267,
      0,
      0.685524,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.537766,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627122,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.053233,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      0,
      3,
      2.822489,
      2.269991,
      0.141242,
      NULL,
      NULL,
      2.027948,
      0.449185,
      0,
      0,
      3.012721,
      3.565429,
      1,
      NULL,
      2,
      3,
      6,
      2,
      1.832216,
      NULL,
      NULL,
      1.044248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165620,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.034723,
      NULL,
      NULL,
      1.432338,
      1,
      0.678317,
      NULL,
      0.307914,
      2.843945,
      6.446430,
      1,
      1,
      NULL,
      2.822208,
      3.425310,
      4.106642,
      2,
      3.539941,
      1,
      2,
      2.935381,
      1.974116,
      1.875016,
      0,
      2.960199,
      NULL,
      1.302673,
      7,
      3.543040,
      2,
      NULL,
      1.938453,
      0,
      1,
      2,
      NULL,
      NULL,
      0.187155,
      3.346907,
      1,
      0,
      0,
      5,
      9.653613,
      NULL,
      2,
      1.505315,
      1,
      NULL,
      2,
      3,
      0,
      1.505931,
      0,
      1,
      1,
      3.822666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.318107,
      NULL,
      NULL,
      3.767220,
      NULL,
      NULL,
      0.989062,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714203,
      NULL,
      NULL,
      1.661111,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      1.000737,
      1.782684,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.710072,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001254,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.465796,
      NULL,
      NULL,
      NULL,
      0.005969,
      NULL,
      NULL,
      NULL,
      1.229112,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.223653,
      1,
      NULL,
      NULL,
      0.733621,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.764262,
      1,
      NULL,
      NULL,
      2,
      0.476557,
      NULL,
      NULL,
      1.310874,
      NULL,
      NULL,
      NULL,
      3.810764,
      NULL,
      33,
      1.087218,
      5,
      1324,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.526498,
      1131,
      1,
      NULL,
      NULL,
      0.954895,
      6.983591,
      1,
      350,
      0,
      1,
      0.741354,
      0,
      1.487742,
      1.541059,
      0.234421,
      1.965657,
      0,
      1.524590,
      0,
      0.687797,
      0.262022,
      1.000139,
      0,
      0,
      0.198409,
      1.184651,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      3.569645,
      1,
      0.377618,
      0.146436,
      0,
      0.790246,
      2.635315,
      1.312185,
      0,
      3.071536,
      0,
      1.019311,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      1,
      2.911726,
      0.332230,
      1.969440,
      NULL,
      1.236678,
      NULL,
      NULL,
      1.270015,
      1,
      0.798320,
      NULL,
      1,
      2,
      NULL,
      0.984365,
      NULL,
      3,
      0,
      0.935964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.712635,
      1,
      0,
      0.424159,
      0,
      NULL,
      0,
      3,
      6,
      1.348596,
      2,
      2,
      61.633201,
      81,
      1,
      NULL,
      3.967789,
      '31301',
      NULL,
      '',
      0.149485,
      NULL,
      '',
      NULL,
      NULL,
      '2302',
      NULL,
      '');
commit;
end;
/


