set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8719263';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '4412344',
      NULL,
      1,
      2,
      0,
      NULL,
      0.027218,
      2,
      NULL,
      NULL,
      '10- 8-1990',
      NULL,
      NULL,
      0,
      0.919785,
      1.437451,
      ' 8- 9-1974',
      16.718724,
      NULL,
      NULL,
      71,
      0,
      NULL,
      NULL,
      ' 3-20-2001',
      2,
      0,
      0,
      0.737467,
      1,
      0.962411,
      NULL,
      0.078300,
      NULL,
      NULL,
      NULL,
      4.009167,
      11.299339,
      NULL,
      14,
      NULL,
      NULL,
      3,
      NULL,
      3.676768,
      0.285975,
      1,
      NULL,
      0,
      NULL,
      5,
      0.226928,
      1,
      1.277447,
      1,
      0.123943,
      NULL,
      NULL,
      NULL,
      3.425766,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.503878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      2,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      1.568015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1.372458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.945142,
      0,
      0,
      0,
      0.243277,
      0.382054,
      NULL,
      0,
      0.693233,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      2,
      NULL,
      NULL,
      3,
      3,
      0,
      0,
      2,
      NULL,
      1,
      3.173371,
      3,
      1,
      7,
      NULL,
      1.255061,
      0.159536,
      1,
      0,
      0.536035,
      NULL,
      0.658255,
      0.232524,
      NULL,
      5,
      3,
      1,
      4,
      1.364672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.956776,
      19,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      '03302',
      NULL,
      NULL,
      1,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      1.559475,
      NULL,
      463.093544,
      54,
      2.559093,
      54.374183,
      2.195596,
      2,
      1,
      1,
      NULL,
      NULL,
      2.406533,
      NULL,
      NULL,
      1.312630,
      NULL,
      NULL,
      2.528972,
      NULL,
      0.940413,
      1,
      0.760621,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0.515466,
      NULL,
      0,
      1.856570,
      0.839628,
      NULL,
      NULL,
      NULL,
      1.020947,
      0,
      1,
      NULL,
      NULL,
      1.113676,
      0,
      0,
      1,
      0,
      NULL,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      0.960759,
      0.571868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.735287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996090,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5.596098,
      1.103911,
      0.141865,
      NULL,
      3.000067,
      2.098975,
      NULL,
      1.846101,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.144658,
      0.600381,
      0,
      NULL,
      NULL,
      1.040407,
      NULL,
      NULL,
      0.351330,
      0,
      0.094355,
      0.838727,
      1,
      NULL,
      3.377819,
      NULL,
      1.313380,
      2,
      1.950972,
      0.387344,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.632964,
      NULL,
      NULL,
      NULL,
      1.376074,
      NULL,
      0.916666,
      13,
      16,
      2.703432,
      NULL,
      1,
      0.374997,
      0.622539,
      1,
      0,
      NULL,
      NULL,
      0.710360,
      1,
      NULL,
      3,
      0,
      0.467726,
      NULL,
      NULL,
      0.678961,
      5,
      0.881964,
      5.873569,
      2.945643,
      1.645356,
      NULL,
      0.860970,
      1.498706,
      NULL,
      2.493732,
      1,
      NULL,
      NULL,
      0,
      0.233499,
      5.491308,
      1,
      NULL,
      7.925477,
      0.512865,
      NULL,
      0.455464,
      3,
      0,
      3,
      2,
      NULL,
      2,
      1.148655,
      1.321160,
      0,
      NULL,
      NULL,
      6.132877,
      NULL,
      NULL,
      2.520467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.188031,
      NULL,
      NULL,
      3.946922,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.508922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.851302,
      NULL,
      NULL,
      0.192450,
      NULL,
      3,
      0,
      3,
      1.840142,
      1.506187,
      NULL,
      1,
      4.641332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680048,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.595793,
      NULL,
      NULL,
      NULL,
      1.119355,
      NULL,
      NULL,
      NULL,
      1.346021,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.098812,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.530540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.935325,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      1.778364,
      NULL,
      0.349646,
      NULL,
      NULL,
      NULL,
      0.227396,
      NULL,
      NULL,
      0.555334,
      13.381786,
      2.103490,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.857060,
      61.680759,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.057746,
      9464.912098,
      321,
      1.133167,
      NULL,
      0,
      0,
      0.533243,
      NULL,
      0.271338,
      0,
      NULL,
      NULL,
      1.365270,
      0,
      1,
      0,
      NULL,
      1.508938,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      0.984920,
      2,
      1.050736,
      1,
      5.495821,
      0.166289,
      3,
      NULL,
      1.829165,
      0.576630,
      0,
      NULL,
      1,
      0,
      3,
      NULL,
      3.855331,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.616505,
      0,
      1.639877,
      1,
      1.092847,
      0,
      1,
      0.418518,
      0,
      0,
      1.232636,
      0,
      NULL,
      0.512806,
      0,
      0,
      0.470818,
      NULL,
      1,
      2.252082,
      1.484029,
      3.815648,
      0,
      NULL,
      1,
      2.904798,
      1,
      NULL,
      1,
      3,
      3.874750,
      2.772257,
      0,
      1,
      NULL,
      1.661014,
      1.249340,
      NULL,
      0,
      2.275159,
      3,
      1.440881,
      NULL,
      1,
      1.740042,
      7,
      1,
      NULL,
      2.177705,
      0.292427,
      1,
      NULL,
      1.341210,
      0,
      2.494153,
      2,
      0,
      1,
      3,
      2,
      1.709781,
      1,
      2,
      0.639016,
      3,
      0,
      0,
      NULL,
      3.800041,
      1,
      0.159776,
      0.175292,
      0.233685,
      NULL,
      1.551450,
      9,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      2,
      2.162210,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      138.599648,
      135.485131,
      3,
      0,
      2,
      NULL,
      '',
      '',
      0.671134,
      '',
      '',
      NULL,
      0.590951,
      '',
      '',
      '');
commit;
end;
/


