set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000173';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      0.632257,
      NULL,
      0,
      NULL,
      1.459159,
      3.474767,
      3.013606,
      57,
      ' 2-14-2001',
      55,
      NULL,
      4,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      50.185444,
      3,
      NULL,
      NULL,
      ' 4-13-1999',
      3,
      1.671547,
      NULL,
      0.150100,
      0,
      0.423162,
      0,
      2.185812,
      NULL,
      NULL,
      NULL,
      3.749198,
      0.357416,
      NULL,
      4,
      5,
      NULL,
      3,
      1,
      3,
      1,
      0,
      1,
      0.305416,
      0.548977,
      1,
      NULL,
      0,
      0,
      1.248766,
      NULL,
      NULL,
      1,
      1,
      2.212451,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.815297,
      0.613116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.028517,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0.132817,
      1,
      NULL,
      1,
      1,
      0.526861,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      0,
      4,
      2,
      2,
      0,
      0,
      1,
      4,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154141,
      1.494325,
      3.578007,
      1.936850,
      0,
      0,
      1.429041,
      NULL,
      NULL,
      NULL,
      0.620791,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      0,
      1.049652,
      NULL,
      1.120172,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.136079,
      2,
      NULL,
      2,
      0,
      0,
      3,
      0,
      2,
      1,
      3,
      2,
      NULL,
      2.717849,
      NULL,
      6.623328,
      1.206537,
      1.959503,
      6,
      0,
      1.415170,
      1,
      1.341639,
      NULL,
      1,
      0,
      1.078831,
      NULL,
      4.785962,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      5.260706,
      NULL,
      1,
      2,
      NULL,
      2.655305,
      1,
      3,
      40,
      NULL,
      1.977659,
      21,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.348133,
      '',
      '',
      '',
      1,
      '24140',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.481456,
      NULL,
      227,
      27.251013,
      0,
      21,
      NULL,
      1.658398,
      2,
      1.448192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.758480,
      NULL,
      0,
      0.936161,
      NULL,
      NULL,
      0.054853,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590955,
      NULL,
      NULL,
      2.796933,
      1,
      NULL,
      0,
      0.214183,
      NULL,
      NULL,
      NULL,
      1.801861,
      3.955000,
      1.222266,
      0,
      NULL,
      2,
      1,
      0.722036,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.577469,
      NULL,
      NULL,
      0.890480,
      NULL,
      NULL,
      5,
      5,
      5.080437,
      1,
      0.543259,
      NULL,
      NULL,
      NULL,
      2.229287,
      3,
      1.666561,
      1,
      1,
      NULL,
      NULL,
      0.723518,
      NULL,
      NULL,
      1,
      9.459635,
      2.806213,
      1.505056,
      NULL,
      NULL,
      1,
      0,
      2,
      1.266396,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.208590,
      NULL,
      NULL,
      0.966853,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.426420,
      NULL,
      NULL,
      0.267400,
      NULL,
      NULL,
      0.954616,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.254629,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.925976,
      NULL,
      NULL,
      2.043214,
      NULL,
      NULL,
      0.013441,
      NULL,
      NULL,
      0.792548,
      NULL,
      NULL,
      0,
      3.507663,
      1,
      12,
      NULL,
      NULL,
      2.876646,
      2,
      1,
      0,
      2,
      1,
      2,
      2,
      12,
      3,
      NULL,
      NULL,
      0.953540,
      7.796877,
      2.266066,
      2,
      NULL,
      0,
      3,
      3.786782,
      0,
      1,
      NULL,
      NULL,
      1.349667,
      1.252730,
      NULL,
      0.573679,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.815418,
      1,
      0.611825,
      NULL,
      NULL,
      1.864216,
      3.694787,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.797326,
      NULL,
      NULL,
      NULL,
      3.535374,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.076908,
      NULL,
      NULL,
      NULL,
      1.906961,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158173,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.887888,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.234903,
      3,
      NULL,
      NULL,
      1.228196,
      0,
      NULL,
      NULL,
      0.477993,
      0,
      NULL,
      NULL,
      2.328885,
      1,
      NULL,
      NULL,
      NULL,
      2.611182,
      NULL,
      NULL,
      0.620061,
      10,
      NULL,
      NULL,
      1.188262,
      2,
      NULL,
      2.379115,
      1.101130,
      2,
      6,
      0,
      9.838342,
      1.952276,
      0,
      23,
      4.153295,
      1,
      NULL,
      NULL,
      0.353957,
      NULL,
      NULL,
      0.811648,
      15.081668,
      346.676913,
      0.922998,
      NULL,
      NULL,
      3.484771,
      18,
      0.474224,
      68.330907,
      NULL,
      1.958079,
      0,
      NULL,
      1.201446,
      NULL,
      1,
      1.325510,
      0.046757,
      0.864639,
      NULL,
      0,
      0.673630,
      1,
      1,
      1,
      1,
      0.621827,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7.553108,
      1,
      2.624834,
      5,
      NULL,
      20,
      NULL,
      1.142454,
      0.355744,
      NULL,
      0.574397,
      NULL,
      NULL,
      NULL,
      1.094147,
      NULL,
      1,
      0,
      2,
      1.752992,
      NULL,
      1,
      2.827382,
      3,
      1.387927,
      1,
      0.142758,
      2,
      1.806793,
      3.464103,
      NULL,
      0.543901,
      2.155793,
      1.792330,
      1,
      NULL,
      1,
      0,
      1.755438,
      1.592190,
      NULL,
      0.981947,
      NULL,
      0.943883,
      0.272947,
      NULL,
      1.163316,
      0,
      NULL,
      3.047201,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.901652,
      NULL,
      1.949990,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      31,
      0.243752,
      1,
      1.820869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.694385,
      1.219021,
      4,
      6,
      1,
      NULL,
      2.527683,
      0.798380,
      25,
      84,
      3,
      0,
      NULL,
      '21041',
      '',
      NULL,
      0.220693,
      '31421',
      NULL,
      '',
      NULL,
      '41244',
      NULL,
      '');
commit;
end;
/


