set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9637950';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '23',
      '00',
      3,
      19.700172,
      NULL,
      2.338698,
      1,
      NULL,
      2,
      NULL,
      5,
      0,
      NULL,
      NULL,
      ' 7- 9-1977',
      5.746642,
      50.613725,
      NULL,
      2,
      1,
      ' 1-23-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 8- 0-1987',
      2.029988,
      1.047626,
      1,
      0,
      1.548011,
      3.151198,
      NULL,
      3.627127,
      NULL,
      NULL,
      NULL,
      3,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0.458923,
      0,
      2,
      0,
      0,
      0,
      1.227624,
      0.314680,
      0,
      0.605333,
      1.330041,
      3,
      1,
      NULL,
      3.068893,
      4,
      3,
      2,
      1,
      0,
      3,
      0,
      NULL,
      0,
      1,
      1,
      0,
      9.915379,
      NULL,
      2,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      2,
      1,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.225384,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      3,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      3,
      0,
      NULL,
      2,
      4,
      NULL,
      1,
      NULL,
      1,
      1,
      1.094792,
      NULL,
      ' 9-11-1975',
      11,
      '10-14-1991',
      8.627351,
      0,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      16.886688,
      1,
      0.926962,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.035273,
      NULL,
      0,
      2.375169,
      NULL,
      NULL,
      0,
      6,
      5.770753,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672631,
      6.049735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000724,
      1.575733,
      0,
      1,
      0.527246,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.131741,
      0.729304,
      3,
      1,
      0,
      0,
      0,
      1,
      2,
      2,
      0,
      2,
      1,
      3.850380,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      0.692608,
      1,
      0,
      NULL,
      0.353637,
      0.386015,
      6,
      NULL,
      NULL,
      4.915726,
      7,
      5.654213,
      NULL,
      1.001255,
      NULL,
      NULL,
      3.696984,
      1,
      12.363522,
      3,
      1,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.648514,
      '0002',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1.381356,
      '0002',
      '',
      NULL,
      2.254177,
      NULL,
      NULL,
      22,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.950201,
      2,
      3,
      1.335666,
      NULL,
      1.052597,
      0,
      NULL,
      3.025400,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      NULL,
      3.789343,
      0.215089,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703400,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.374053,
      3.276278,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.985026,
      NULL,
      NULL,
      0.225277,
      NULL,
      NULL,
      0.761113,
      NULL,
      NULL,
      0.119313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.727197,
      NULL,
      NULL,
      0.862575,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.084240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265915,
      NULL,
      NULL,
      1.601350,
      NULL,
      NULL,
      0.087371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139219,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.207081,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.516086,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.169996,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.784221,
      3.008223,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.353653,
      0.333182,
      3.079889,
      2.191182,
      1,
      1.164827,
      2,
      0,
      2,
      0,
      NULL,
      3.709122,
      2.619620,
      NULL,
      1,
      4,
      6.632640,
      0.568221,
      NULL,
      NULL,
      3,
      0,
      4,
      1.189671,
      NULL,
      0.632120,
      0.411511,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.937086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.964737,
      NULL,
      NULL,
      5.413746,
      NULL,
      NULL,
      2.279893,
      3,
      NULL,
      0.492610,
      NULL,
      1,
      1.943049,
      NULL,
      NULL,
      4.741460,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.372250,
      NULL,
      NULL,
      1.650259,
      3.247084,
      NULL,
      NULL,
      1,
      1.511767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391179,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798315,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.053500,
      NULL,
      NULL,
      NULL,
      0.150039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.742178,
      1,
      NULL,
      NULL,
      1.554842,
      1.385005,
      NULL,
      NULL,
      NULL,
      1.206172,
      NULL,
      NULL,
      3.062543,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.553114,
      0,
      NULL,
      NULL,
      0,
      0.994506,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      12,
      56.546431,
      NULL,
      NULL,
      NULL,
      0.878739,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183460,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2.122595,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.135992,
      0.015287,
      1,
      0,
      0.458140,
      0.814083,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186248,
      NULL,
      0.578897,
      NULL,
      56,
      NULL,
      0,
      14.981936,
      43,
      0,
      1,
      NULL,
      NULL,
      0.851974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464462,
      NULL,
      1.037199,
      NULL,
      3.718441,
      NULL,
      1.997671,
      NULL,
      0.612676,
      NULL,
      0.139666,
      NULL,
      1.478551,
      NULL,
      0.018327,
      NULL,
      1.758884,
      NULL,
      NULL,
      NULL,
      0.706112,
      3,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223068,
      NULL,
      0.348426,
      NULL,
      0.143626,
      NULL,
      1,
      NULL,
      0.985506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.274272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307794,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266076,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.580219,
      NULL,
      0.765512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.453384,
      NULL,
      NULL,
      0,
      NULL,
      0.109497,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.262922,
      0.693695,
      5,
      1,
      NULL,
      3,
      3.632974,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0.920595,
      NULL,
      NULL,
      1.992353,
      NULL,
      0,
      3.760455,
      1.964843,
      1.541393,
      1.723878,
      NULL,
      0.426907,
      0,
      NULL,
      1.101896,
      1.373457,
      1.369427,
      NULL,
      1.242473,
      1.053416,
      0,
      1.043566,
      1,
      2,
      1.038427,
      1.514861,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.482993,
      0,
      NULL,
      5,
      1,
      NULL,
      NULL,
      15,
      80,
      0,
      NULL,
      2.456153,
      '1042',
      '43313',
      NULL,
      1.136942,
      '',
      NULL,
      '',
      NULL,
      '2333',
      NULL,
      NULL);
commit;
end;
/


