set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8808505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4302324',
      2.053931,
      0,
      3,
      NULL,
      '1312',
      1,
      1,
      NULL,
      NULL,
      NULL,
      6.431554,
      NULL,
      NULL,
      2.631234,
      1.499442,
      ' 5-17-1976',
      102.868105,
      0.482437,
      290.476631,
      NULL,
      1,
      ' 8-27-1984',
      ' 0- 4-1987',
      NULL,
      0.795208,
      NULL,
      NULL,
      NULL,
      0.327598,
      0,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      4.731503,
      17.344420,
      NULL,
      163,
      3,
      6,
      5,
      3,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1.147581,
      1,
      0,
      NULL,
      0,
      3,
      2,
      3.642691,
      1,
      1,
      1,
      2,
      0,
      1,
      2,
      0,
      2,
      1,
      1,
      1,
      3.517534,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      1.104450,
      0.169386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      2.819986,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.949518,
      NULL,
      NULL,
      1,
      1,
      NULL,
      5,
      1,
      5,
      1,
      1,
      0,
      2,
      5,
      1,
      0,
      2,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      0,
      3,
      0,
      0,
      1,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      2,
      1,
      3,
      4,
      2,
      3,
      3,
      4,
      0,
      NULL,
      1,
      NULL,
      ' 1-19-2001',
      36,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      3,
      1.831952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.505457,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.970663,
      0.644841,
      0,
      1.342893,
      1.139636,
      NULL,
      0.595881,
      3,
      30,
      1.872639,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901803,
      NULL,
      4,
      7,
      NULL,
      4.064655,
      4.207088,
      4,
      NULL,
      NULL,
      NULL,
      1.899689,
      0,
      32,
      1,
      3,
      NULL,
      13,
      NULL,
      70.351316,
      5,
      NULL,
      2.636954,
      '12323',
      '',
      '',
      0.425212,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      65.915166,
      NULL,
      4.904771,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.801813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.326435,
      3,
      1,
      2.877490,
      0.051953,
      0,
      NULL,
      NULL,
      2,
      NULL,
      18.680790,
      0.130053,
      NULL,
      NULL,
      1.726167,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.527206,
      NULL,
      NULL,
      10.532369,
      11.189702,
      4.176237,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.847710,
      NULL,
      NULL,
      NULL,
      0,
      2.784050,
      17,
      1.352191,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490084,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.636725,
      0.031677,
      6.858893,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.142655,
      NULL,
      NULL,
      NULL,
      0.834009,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.632966,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.683691,
      NULL,
      NULL,
      1.695283,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.604526,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.203965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051738,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.495191,
      NULL,
      0,
      1.999649,
      NULL,
      NULL,
      0.633832,
      NULL,
      NULL,
      0,
      3.508444,
      0,
      1,
      0,
      1,
      0.040114,
      3,
      2,
      NULL,
      3.443270,
      0.204837,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      3,
      0.681662,
      0.411558,
      1.635926,
      1.999081,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220627,
      NULL,
      NULL,
      0.269449,
      NULL,
      NULL,
      1.868911,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.707833,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.083405,
      0.883064,
      1.665663,
      0.473566,
      0,
      NULL,
      NULL,
      1.367202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.659385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.511008,
      NULL,
      NULL,
      NULL,
      1.390036,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.070054,
      NULL,
      NULL,
      1.572778,
      NULL,
      NULL,
      1.135472,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      11678,
      896.329249,
      1.342291,
      1,
      NULL,
      1.622325,
      NULL,
      0.999710,
      NULL,
      0,
      0,
      1.593536,
      1,
      0.190258,
      1.758153,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856203,
      2.966680,
      1.526313,
      NULL,
      10.594636,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      19.086785,
      0.543648,
      NULL,
      NULL,
      1.027516,
      NULL,
      18.725082,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      10.569746,
      0,
      NULL,
      NULL,
      1,
      NULL,
      17,
      0,
      NULL,
      1.673331,
      1,
      0.257055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.963530,
      NULL,
      1,
      NULL,
      6,
      1.120804,
      NULL,
      NULL,
      42,
      NULL,
      2,
      NULL,
      3.880728,
      NULL,
      '',
      '',
      1.646379,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


