set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027574';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      2,
      1.648217,
      0,
      1,
      '4131',
      1,
      1,
      NULL,
      NULL,
      ' 5-13-1995',
      6.735460,
      NULL,
      5,
      1,
      0.811160,
      ' 2-18-1976',
      24,
      3.160768,
      NULL,
      35.871144,
      3,
      ' 6-28-2001',
      NULL,
      ' 8-26-1985',
      0.221249,
      NULL,
      2.387761,
      1.946514,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      3,
      NULL,
      5,
      4.825157,
      25,
      1,
      16.456050,
      2,
      4,
      7,
      1.233536,
      1,
      0,
      1.486822,
      0,
      1.379492,
      NULL,
      2.464750,
      1.997383,
      1.077460,
      0.960727,
      0,
      4,
      5,
      3,
      4,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      3.828439,
      0,
      2,
      NULL,
      NULL,
      1.049879,
      NULL,
      NULL,
      0.706939,
      NULL,
      NULL,
      2,
      0,
      1.242494,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.071832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      2,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1.006054,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      5,
      5,
      3,
      NULL,
      0,
      4,
      NULL,
      0,
      4,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.513292,
      4,
      0,
      0.214498,
      0.680555,
      0.521703,
      NULL,
      NULL,
      NULL,
      0.979041,
      2.448923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.819931,
      0,
      1.542464,
      0.726768,
      0,
      0.267523,
      3.775939,
      9.471259,
      0.917199,
      0.720814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      3,
      0,
      1,
      3,
      1,
      0,
      2,
      3.325898,
      1,
      0,
      NULL,
      0.098268,
      0,
      1,
      0,
      NULL,
      1.013258,
      0.631465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.436889,
      0,
      2,
      11.826983,
      6,
      4.222486,
      NULL,
      0.645912,
      0,
      0.107464,
      6,
      3.192080,
      0.205585,
      NULL,
      NULL,
      0,
      0.148998,
      NULL,
      NULL,
      NULL,
      24,
      5,
      0,
      0.862590,
      NULL,
      '',
      '',
      1,
      '14220',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      28.706992,
      43,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.625635,
      1,
      2.112289,
      1.742443,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.738114,
      NULL,
      NULL,
      0.016639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.712825,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.587056,
      NULL,
      NULL,
      0.568952,
      NULL,
      NULL,
      5.072552,
      0.990489,
      5.151480,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.305849,
      NULL,
      NULL,
      NULL,
      0.370734,
      NULL,
      NULL,
      1.541428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277963,
      NULL,
      NULL,
      0.199994,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107371,
      0,
      0.757244,
      2,
      2.150701,
      0.706207,
      NULL,
      NULL,
      NULL,
      NULL,
      1.214737,
      1.917676,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.469509,
      NULL,
      NULL,
      1.547068,
      NULL,
      NULL,
      0.757120,
      NULL,
      NULL,
      0.536571,
      NULL,
      NULL,
      1.230443,
      NULL,
      NULL,
      0.818190,
      NULL,
      NULL,
      2,
      3,
      0,
      2,
      2.484969,
      1.789704,
      NULL,
      4.997330,
      NULL,
      1.463184,
      1.788898,
      2.506791,
      0.307793,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.960844,
      1,
      NULL,
      3.337568,
      3.209399,
      0,
      NULL,
      0.363853,
      7,
      2,
      0,
      0.124239,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2.479070,
      2,
      0.234298,
      NULL,
      1.387770,
      NULL,
      9,
      5,
      2,
      1.381395,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.616750,
      0.102601,
      1.207224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.863079,
      0.843118,
      1,
      1,
      0.673427,
      1.877317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707814,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.431495,
      NULL,
      0,
      1.924412,
      NULL,
      1,
      0.713273,
      1.962737,
      NULL,
      0.981553,
      0,
      0,
      NULL,
      1.876581,
      1,
      NULL,
      1,
      0,
      1.181177,
      0.192321,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      7.026801,
      NULL,
      NULL,
      1.283801,
      2,
      5,
      0,
      1.487742,
      1.283894,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853748,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.692128,
      NULL,
      NULL,
      1.483032,
      NULL,
      NULL,
      1.386488,
      NULL,
      NULL,
      0.609722,
      NULL,
      NULL,
      3,
      1.308046,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.472050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555785,
      NULL,
      NULL,
      NULL,
      0.945289,
      NULL,
      2,
      4,
      1,
      0,
      0.920413,
      2,
      18,
      84,
      1,
      0.071038,
      1.385954,
      '',
      '',
      '',
      1.522135,
      '14013',
      '',
      NULL,
      1.544611,
      '',
      NULL,
      '');
commit;
end;
/


