set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027574';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '4104313',
      2.926828,
      0,
      0,
      3,
      NULL,
      1.050345,
      0.609097,
      NULL,
      NULL,
      ' 8-10-1994',
      19,
      NULL,
      2,
      1,
      4,
      ' 4-19-1992',
      15.860209,
      NULL,
      231.538649,
      96.880523,
      1,
      ' 6-27-1982',
      ' 7-26-1980',
      NULL,
      3.866167,
      NULL,
      NULL,
      NULL,
      NULL,
      2.081477,
      0,
      1,
      0.417306,
      7,
      5,
      12,
      4,
      18.534466,
      18,
      3,
      9.793469,
      5,
      2,
      0.997498,
      1.197687,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.683528,
      1,
      0.990875,
      1,
      0,
      2,
      1,
      0.237512,
      NULL,
      0,
      3,
      0,
      3,
      1,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1.232352,
      NULL,
      NULL,
      0.963855,
      NULL,
      NULL,
      1,
      1,
      0,
      1.536344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      3,
      3,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.392537,
      NULL,
      NULL,
      4,
      5,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      NULL,
      5,
      0,
      1,
      1,
      0,
      4,
      4,
      3,
      2,
      NULL,
      0,
      5,
      4,
      4,
      1,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597919,
      1.248347,
      NULL,
      NULL,
      2.612866,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.065215,
      0,
      2,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      6,
      1.489048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571948,
      0,
      0,
      0,
      1,
      1,
      0.588334,
      NULL,
      22.586739,
      3,
      0.204344,
      NULL,
      NULL,
      NULL,
      2,
      0.699443,
      3.946220,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      2,
      2,
      3.289398,
      1.217920,
      0.298619,
      1.977046,
      NULL,
      1,
      1,
      1,
      0.776099,
      NULL,
      0,
      0.589707,
      1,
      0,
      NULL,
      2,
      0,
      7.065570,
      8,
      2,
      7.078938,
      8,
      NULL,
      2,
      2.071170,
      2.263049,
      1,
      1,
      NULL,
      53,
      3,
      1.763826,
      NULL,
      69,
      48,
      38,
      1,
      0.409571,
      1,
      '',
      NULL,
      NULL,
      1,
      '43214',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      3,
      NULL,
      57,
      20.595755,
      0.051047,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.138669,
      0.387127,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.344312,
      NULL,
      NULL,
      1.213520,
      NULL,
      NULL,
      0.017183,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.011754,
      NULL,
      NULL,
      1.764774,
      NULL,
      NULL,
      1.786843,
      NULL,
      NULL,
      1.365059,
      NULL,
      NULL,
      0.906455,
      NULL,
      NULL,
      1.260774,
      5,
      4.341676,
      NULL,
      1.116338,
      NULL,
      NULL,
      NULL,
      1.215296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205164,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574757,
      NULL,
      NULL,
      2,
      1.408702,
      2.246757,
      1,
      NULL,
      1,
      0,
      1,
      2,
      1,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.084328,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.495554,
      1.512856,
      1,
      0,
      1.208865,
      1,
      2.964166,
      NULL,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      2.370364,
      1,
      3.943153,
      1,
      2.940810,
      0.635341,
      2,
      1,
      3.714726,
      1,
      2,
      0.377442,
      1.144585,
      3.933608,
      0,
      3,
      1,
      0.192904,
      0.142148,
      NULL,
      NULL,
      1,
      0.094514,
      3.731812,
      1,
      1.280082,
      7.907566,
      2,
      NULL,
      1,
      1.113603,
      NULL,
      NULL,
      1,
      0.079191,
      NULL,
      0.639311,
      1.260826,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.149778,
      1.965854,
      1.379764,
      NULL,
      0.330743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.229308,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.587141,
      NULL,
      NULL,
      1,
      NULL,
      1.249945,
      NULL,
      0,
      1,
      0,
      0.401086,
      0,
      1.143428,
      0,
      1.152594,
      0,
      NULL,
      1,
      1,
      NULL,
      0.570491,
      0.525828,
      1,
      1.299535,
      0.607461,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      2.727988,
      7,
      2,
      NULL,
      3,
      16.740325,
      0,
      NULL,
      1.748798,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.949750,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.561314,
      NULL,
      NULL,
      1.696275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.233868,
      NULL,
      NULL,
      0,
      1.232212,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      6,
      7,
      1,
      3,
      1.238325,
      25.239584,
      31.277529,
      4,
      1.264146,
      NULL,
      '',
      '',
      '',
      0.571075,
      '04203',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


