set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6302129';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      1.280228,
      1.322232,
      NULL,
      NULL,
      '1420',
      1,
      1,
      NULL,
      NULL,
      '11- 0-1976',
      18,
      NULL,
      4,
      1.231603,
      1,
      ' 7-19-1974',
      NULL,
      1,
      NULL,
      51,
      0,
      ' 1- 8-1991',
      '11-21-1975',
      ' 7-11-1993',
      2,
      3.252019,
      3,
      0,
      1,
      0.453752,
      2,
      1,
      0,
      1.695980,
      1,
      1,
      2,
      17.871371,
      12,
      1,
      31,
      5,
      2,
      NULL,
      0.123621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.331816,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      4,
      1,
      4,
      0,
      1,
      1,
      NULL,
      0,
      2,
      2,
      0,
      0,
      NULL,
      NULL,
      0.909322,
      NULL,
      NULL,
      0,
      1,
      11,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2,
      0,
      0,
      3.211928,
      NULL,
      NULL,
      1.244534,
      NULL,
      0.494586,
      1.806355,
      0,
      1,
      4,
      7.497682,
      0,
      NULL,
      0.839455,
      0,
      NULL,
      NULL,
      0.790411,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      3,
      2,
      0,
      NULL,
      1,
      5,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      1.363437,
      NULL,
      0.662917,
      5,
      4,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      3,
      5,
      4,
      1,
      2,
      1,
      1,
      1,
      1,
      4,
      0,
      NULL,
      1,
      2,
      1,
      4,
      NULL,
      NULL,
      2.455711,
      ' 8- 6-1990',
      33,
      ' 3-26-1988',
      4.331310,
      2,
      0,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      66,
      NULL,
      NULL,
      4,
      NULL,
      0.632551,
      NULL,
      1,
      0.738835,
      1,
      0.834007,
      1,
      NULL,
      2,
      1.052902,
      2,
      NULL,
      NULL,
      7.235218,
      9.592092,
      4.599448,
      6,
      1,
      NULL,
      NULL,
      1.923022,
      12,
      3,
      0,
      4,
      2,
      NULL,
      '11-20-1998',
      NULL,
      ' 7-14-1983',
      44,
      NULL,
      1,
      NULL,
      0,
      1.894619,
      0.090482,
      0,
      1.183539,
      1.370487,
      NULL,
      3,
      164,
      NULL,
      1,
      NULL,
      NULL,
      107,
      2,
      1,
      2.908331,
      0,
      3,
      0,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      2.416920,
      5,
      NULL,
      55.082349,
      NULL,
      153.753881,
      137,
      NULL,
      94.756649,
      NULL,
      1.748088,
      0,
      0.935746,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      6,
      2.319393,
      1,
      4.357753,
      3.194831,
      3.967689,
      2,
      1.338025,
      NULL,
      3.694071,
      15.385882,
      0,
      0.374247,
      NULL,
      61,
      12,
      64.424298,
      4,
      1.004756,
      NULL,
      '13233',
      '',
      '',
      1,
      '',
      '',
      '',
      1.964399,
      '',
      '',
      '',
      NULL,
      13.724968,
      161.898054,
      33.775475,
      2.682055,
      12,
      4.732198,
      3.512854,
      3,
      3.022806,
      0.545446,
      1.569824,
      1.280165,
      NULL,
      NULL,
      0.121143,
      NULL,
      NULL,
      0.366009,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.616589,
      NULL,
      NULL,
      NULL,
      2,
      1.839049,
      0.653491,
      NULL,
      NULL,
      1.824010,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      0.518729,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.483684,
      1.746829,
      1.311933,
      3,
      2.715441,
      1.051401,
      NULL,
      2,
      1,
      1,
      0.432547,
      3.407685,
      0,
      1,
      0,
      2,
      0,
      1.025245,
      3.752558,
      2,
      NULL,
      NULL,
      0,
      3.884803,
      0,
      0.197152,
      1,
      1,
      NULL,
      NULL,
      0.706718,
      NULL,
      NULL,
      0.416707,
      3,
      1,
      2.873911,
      5,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.866357,
      1.502524,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843369,
      NULL,
      NULL,
      2.876186,
      0,
      0.920157,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.497704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.189426,
      NULL,
      NULL,
      0.785618,
      NULL,
      NULL,
      2.787282,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.499872,
      7.872060,
      3.834792,
      7.990290,
      5,
      1,
      0,
      NULL,
      NULL,
      1.831035,
      NULL,
      1.518925,
      2.067552,
      3,
      1,
      1.094629,
      2,
      1,
      5,
      4,
      NULL,
      3.242579,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.741305,
      3.490172,
      1,
      NULL,
      NULL,
      0.274914,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.344820,
      0,
      1.519223,
      NULL,
      0,
      NULL,
      NULL,
      3.098364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.431557,
      NULL,
      NULL,
      1.162442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.066712,
      2.154955,
      0,
      0,
      1.204476,
      5.378787,
      NULL,
      NULL,
      1.897196,
      5.327419,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.037442,
      NULL,
      NULL,
      NULL,
      3.943127,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.082954,
      2.777802,
      NULL,
      NULL,
      0.082453,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      1.308025,
      3,
      NULL,
      NULL,
      1,
      0.538817,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.264050,
      3,
      NULL,
      NULL,
      0.327070,
      0.300776,
      NULL,
      NULL,
      0,
      2.301791,
      NULL,
      NULL,
      1,
      3.643201,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0.890230,
      2,
      NULL,
      NULL,
      NULL,
      10.829962,
      NULL,
      NULL,
      2.341865,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      24.923351,
      61.098445,
      2.695543,
      9.070723,
      2,
      0.406756,
      NULL,
      NULL,
      1.127395,
      0,
      1,
      0.931792,
      4.029614,
      1,
      1.052515,
      NULL,
      NULL,
      1.673398,
      NULL,
      1,
      136,
      0,
      0,
      0.511645,
      1.908901,
      0.318567,
      NULL,
      1.126549,
      1.113532,
      NULL,
      1.312049,
      0,
      0,
      1,
      0,
      0,
      0.702752,
      1.742574,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.062741,
      0,
      NULL,
      1.715528,
      3,
      NULL,
      0.364033,
      0,
      3.857730,
      0.161152,
      0.307529,
      0.898341,
      1.372757,
      0.321207,
      NULL,
      0,
      3,
      1,
      1.733935,
      1.448966,
      0,
      3.695321,
      3,
      1,
      1.751391,
      1,
      0,
      1.548080,
      0,
      1,
      NULL,
      2.364282,
      0,
      1.479554,
      1.827568,
      1.980852,
      0.808559,
      0.233405,
      NULL,
      0,
      0.334629,
      NULL,
      0.299791,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.222895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.492913,
      1.290374,
      1,
      1.444510,
      NULL,
      4,
      NULL,
      6,
      3.593639,
      1,
      1.553072,
      49,
      24.096950,
      NULL,
      0.065550,
      2.252315,
      '01203',
      NULL,
      NULL,
      1.413178,
      NULL,
      '',
      '',
      1.769785,
      '',
      NULL,
      '');
commit;
end;
/


