set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4801449';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '2224212',
      2.699426,
      1.351840,
      3,
      1,
      '4413',
      NULL,
      1.281966,
      NULL,
      NULL,
      ' 8-20-2003',
      NULL,
      NULL,
      1,
      NULL,
      0,
      ' 3-16-1998',
      54,
      NULL,
      44,
      160,
      5,
      NULL,
      NULL,
      ' 8- 8-1985',
      0.704109,
      0,
      2.270880,
      NULL,
      NULL,
      1.727534,
      3,
      1,
      1,
      2.823721,
      7,
      18,
      3.663167,
      10.590879,
      3,
      5,
      21.463500,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      3,
      3,
      1,
      1,
      0,
      1,
      4,
      0,
      1,
      1,
      0,
      0,
      1,
      2,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.638827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.822688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0.692600,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      3,
      1,
      0,
      2,
      1,
      4,
      3,
      0,
      1,
      NULL,
      1,
      3,
      NULL,
      650,
      ' 0-19-1974',
      NULL,
      1.904346,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1.481630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951137,
      1.211631,
      1,
      NULL,
      2,
      1,
      NULL,
      1.298849,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896934,
      NULL,
      0,
      0,
      0.287222,
      1.896918,
      1.107934,
      0.987265,
      NULL,
      2,
      1.874913,
      1.552634,
      14.257201,
      0,
      3,
      2,
      1,
      3,
      0,
      NULL,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      5.132472,
      2,
      0,
      1,
      3,
      3.109798,
      1,
      1,
      0.155393,
      0.161229,
      1.119998,
      0,
      0.177707,
      0,
      1,
      1.726572,
      NULL,
      8.486880,
      NULL,
      0.878703,
      NULL,
      NULL,
      1,
      4.724439,
      1.525647,
      NULL,
      NULL,
      0.067246,
      3,
      0,
      NULL,
      0.219835,
      53,
      NULL,
      NULL,
      NULL,
      1,
      0.003152,
      2.147934,
      '31231',
      '',
      NULL,
      0.003237,
      NULL,
      '',
      '',
      2,
      '30441',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      4.780022,
      2.302317,
      51.799410,
      4,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.152382,
      2,
      1.417653,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.503147,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.365011,
      4,
      1.055485,
      1,
      0.718952,
      NULL,
      NULL,
      NULL,
      0.201623,
      NULL,
      NULL,
      NULL,
      1.053516,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.247068,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.977076,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.968160,
      NULL,
      NULL,
      1.847220,
      NULL,
      NULL,
      0.094138,
      NULL,
      NULL,
      0.749231,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.702452,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.774820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.349434,
      3,
      0.651395,
      1,
      0.895928,
      NULL,
      0,
      5,
      0,
      1,
      0,
      NULL,
      2.662431,
      3,
      1,
      0.096381,
      3,
      0,
      1,
      NULL,
      1,
      1,
      3.605256,
      3,
      2,
      2,
      0,
      1,
      NULL,
      NULL,
      1.094170,
      NULL,
      0.887582,
      1,
      NULL,
      2.459269,
      7,
      NULL,
      3,
      0,
      5.380463,
      1.178372,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.781584,
      0.390416,
      NULL,
      NULL,
      0.021464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.283317,
      NULL,
      NULL,
      1.722163,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.962817,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.428828,
      0,
      0.952136,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.874608,
      NULL,
      NULL,
      NULL,
      1.750001,
      NULL,
      NULL,
      NULL,
      1.975792,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.396683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901723,
      NULL,
      NULL,
      NULL,
      2,
      41.622588,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      44.314619,
      2,
      1,
      NULL,
      NULL,
      0.308687,
      NULL,
      NULL,
      2.557655,
      NULL,
      NULL,
      0,
      19,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.036324,
      0.557290,
      1,
      NULL,
      NULL,
      0.921031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.769767,
      0.993649,
      3,
      3.552575,
      0,
      NULL,
      2,
      2.639728,
      0,
      NULL,
      0.035865,
      NULL,
      1.966929,
      1.393585,
      NULL,
      1.066981,
      3.913639,
      NULL,
      0,
      NULL,
      NULL,
      0.209636,
      3.953196,
      NULL,
      0,
      1,
      NULL,
      3,
      2.401155,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1.613544,
      NULL,
      1.982172,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.293000,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.067520,
      NULL,
      0,
      NULL,
      2.185905,
      NULL,
      1.630040,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.377773,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.613603,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      96,
      93.354905,
      3,
      0.649113,
      2,
      NULL,
      '',
      NULL,
      1.876537,
      '',
      NULL,
      '',
      0.153553,
      '41103',
      NULL,
      NULL);
commit;
end;
/


