set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9800326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2.201505,
      0,
      3,
      1,
      3.530610,
      NULL,
      3,
      '322',
      '41201412',
      NULL,
      38,
      '2443331',
      1,
      0.044272,
      6,
      1,
      '4033',
      3.249734,
      NULL,
      NULL,
      NULL,
      NULL,
      2.985367,
      45.620192,
      NULL,
      2,
      0,
      '10-24-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-1985',
      2.228647,
      NULL,
      1.951901,
      1,
      0,
      2,
      1,
      0.920288,
      NULL,
      NULL,
      NULL,
      5.851163,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.755664,
      1,
      1,
      0,
      1.712335,
      1.265810,
      1.329883,
      1.858368,
      0.655986,
      1,
      0.889389,
      0,
      NULL,
      NULL,
      2.787742,
      4,
      0,
      0,
      5,
      3,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      7.469059,
      NULL,
      NULL,
      2,
      0,
      0.511667,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      7.265404,
      1.737804,
      NULL,
      0,
      1.850554,
      NULL,
      NULL,
      3.166150,
      2,
      0,
      1,
      2,
      2.574873,
      0,
      3,
      2,
      0,
      0,
      4,
      NULL,
      NULL,
      NULL,
      0,
      0.131431,
      0,
      NULL,
      NULL,
      1.657558,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      2,
      5,
      2,
      5,
      4,
      NULL,
      5,
      NULL,
      0,
      NULL,
      0,
      0.628839,
      3.202141,
      ' 3-11-1986',
      27,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0.465924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.472435,
      0,
      1.483167,
      3,
      2,
      2.186115,
      1.904737,
      NULL,
      NULL,
      NULL,
      2.363053,
      0,
      2,
      0,
      1.040227,
      4.138863,
      0.695713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.712067,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.361257,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.186037,
      NULL,
      3,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      2,
      1,
      2.849700,
      3.010997,
      0.812830,
      NULL,
      0.530842,
      1,
      1,
      0.854024,
      1,
      1.912188,
      0.829727,
      0,
      1,
      0,
      NULL,
      0,
      1,
      1.261929,
      0,
      7,
      7,
      NULL,
      0,
      NULL,
      7.394874,
      1.749639,
      3.863959,
      NULL,
      2.820235,
      1,
      3.678255,
      NULL,
      3,
      0,
      55,
      NULL,
      NULL,
      NULL,
      2,
      4,
      4,
      NULL,
      '43104',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      38.565466,
      18.183381,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.932344,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      2,
      1.837329,
      1.104687,
      NULL,
      NULL,
      1,
      0.558239,
      1,
      1.598309,
      NULL,
      NULL,
      3,
      3.019063,
      0.894264,
      1.063668,
      2,
      1.348070,
      3.367229,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.436538,
      5.748559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.917300,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.662071,
      0,
      0.671389,
      1.029733,
      1.243174,
      0,
      NULL,
      NULL,
      0,
      1,
      0.207162,
      0,
      3.825889,
      1,
      3,
      0,
      NULL,
      NULL,
      3.404326,
      3.840610,
      1.782054,
      1.420354,
      0.346452,
      1,
      4,
      2.637872,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.261707,
      NULL,
      NULL,
      1.251604,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      4,
      1.729015,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358655,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266945,
      NULL,
      NULL,
      0.755546,
      NULL,
      NULL,
      0.692126,
      NULL,
      NULL,
      0.018698,
      NULL,
      NULL,
      0.341246,
      NULL,
      NULL,
      3.946251,
      NULL,
      NULL,
      0,
      0,
      0,
      2.476101,
      2,
      1.793446,
      1,
      5,
      5.781472,
      NULL,
      1,
      1.116745,
      2.318456,
      3.599528,
      0,
      3.887324,
      2.349917,
      1.344591,
      2,
      2.747743,
      0,
      NULL,
      3.193770,
      4.320728,
      1.097156,
      NULL,
      NULL,
      2,
      2,
      4,
      0.553887,
      0,
      0.729580,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.671434,
      NULL,
      NULL,
      1.818098,
      NULL,
      NULL,
      0.690800,
      0.415590,
      1,
      1,
      1,
      3.899990,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.478311,
      NULL,
      NULL,
      NULL,
      0.179770,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.184791,
      NULL,
      NULL,
      NULL,
      2.458647,
      NULL,
      NULL,
      NULL,
      1.399205,
      NULL,
      NULL,
      NULL,
      2.210461,
      NULL,
      NULL,
      NULL,
      0.768493,
      NULL,
      NULL,
      NULL,
      NULL,
      14.798901,
      0.048808,
      NULL,
      NULL,
      NULL,
      0.173201,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.080163,
      NULL,
      NULL,
      0,
      NULL,
      1.479522,
      317,
      2.244065,
      1.729676,
      1.098835,
      1,
      1,
      1,
      1.317629,
      1.710464,
      0,
      0,
      NULL,
      1.649385,
      1,
      0.578440,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737808,
      0.675490,
      0.961428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.037142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      1.198578,
      NULL,
      NULL,
      NULL,
      0.792520,
      1.587664,
      NULL,
      NULL,
      3,
      1.261369,
      1.410555,
      NULL,
      22,
      1.712990,
      1,
      1.096785,
      1,
      1.108060,
      1,
      NULL,
      NULL,
      26,
      26,
      2.413622,
      2.287916,
      1.028132,
      NULL,
      NULL,
      1,
      1,
      1.067539,
      0,
      1,
      3.798150,
      0,
      4,
      2,
      3.884805,
      1,
      1,
      0.386575,
      NULL,
      0.068529,
      3.248843,
      NULL,
      0.545009,
      0,
      NULL,
      0,
      0.176098,
      NULL,
      0,
      0,
      NULL,
      0.312316,
      0,
      NULL,
      0.803300,
      NULL,
      NULL,
      1.289025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.950303,
      1,
      NULL,
      NULL,
      1.898284,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.546819,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      4,
      1,
      NULL,
      NULL,
      73.014442,
      95,
      0,
      4,
      NULL,
      NULL,
      '43243',
      '',
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


