set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8103026';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '0043030',
      0,
      1,
      3,
      1,
      '3122',
      2,
      NULL,
      1,
      NULL,
      '11-24-1981',
      61,
      NULL,
      4,
      1,
      NULL,
      ' 1-16-1985',
      15.821041,
      3.165495,
      74,
      77,
      2,
      ' 8-12-1989',
      ' 7-19-1992',
      ' 0-21-1996',
      2.983520,
      1.302750,
      NULL,
      0.805530,
      0.528681,
      NULL,
      2,
      0.442501,
      0,
      28,
      3,
      NULL,
      NULL,
      NULL,
      24,
      0,
      13,
      2,
      0,
      3,
      0,
      NULL,
      0,
      1.949754,
      0.258841,
      0.565113,
      1,
      0.476422,
      1.487714,
      0,
      0.740385,
      5,
      NULL,
      3,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0.200886,
      NULL,
      NULL,
      0.127147,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.363740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.840334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      2,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1.340377,
      1,
      1,
      5,
      NULL,
      0,
      3,
      0,
      NULL,
      0,
      5,
      0,
      1,
      4,
      4,
      3,
      2,
      0,
      5,
      5,
      0,
      5,
      NULL,
      5,
      NULL,
      1,
      NULL,
      0.664519,
      ' 0-27-1974',
      216.644457,
      ' 5- 1-1994',
      88.391223,
      2.495731,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.862051,
      0,
      1.352608,
      2.410523,
      NULL,
      1,
      1.417125,
      2.660909,
      0,
      NULL,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.304730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260398,
      0,
      1.694913,
      0.330824,
      1.925747,
      NULL,
      1,
      0.027333,
      4,
      3,
      1.149360,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      2,
      0,
      3,
      NULL,
      1,
      2,
      0.392362,
      2.591659,
      3,
      3.838626,
      1.993553,
      1,
      4.010488,
      3,
      0.761570,
      1,
      1,
      NULL,
      1,
      0,
      1.834842,
      0,
      NULL,
      1,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      1.448254,
      2,
      1,
      2.141079,
      1,
      1.537698,
      3.533707,
      23.699150,
      2,
      1,
      NULL,
      41,
      39,
      59.754240,
      NULL,
      NULL,
      5,
      '32002',
      '44131',
      '00122',
      0.881843,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      31.992114,
      47,
      9,
      2.506780,
      34,
      NULL,
      14,
      0,
      0,
      NULL,
      0.683123,
      0.597250,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.561631,
      3.480462,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.712506,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.034576,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.609076,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.302057,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0.353589,
      NULL,
      1.567495,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      4.537206,
      0,
      1,
      3,
      0.084825,
      NULL,
      NULL,
      NULL,
      0.843908,
      NULL,
      NULL,
      NULL,
      1.067698,
      NULL,
      NULL,
      1,
      3,
      0.314320,
      2,
      3,
      3,
      0.732631,
      NULL,
      NULL,
      NULL,
      3.211422,
      1.025510,
      3.059787,
      0.598255,
      NULL,
      2,
      1,
      NULL,
      5.134324,
      4.077823,
      NULL,
      1.371884,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0.992971,
      0.625825,
      3.873406,
      2,
      NULL,
      3,
      0.734297,
      2.644747,
      5.045485,
      11,
      10.025481,
      NULL,
      8,
      NULL,
      5.023923,
      2,
      6,
      0.182968,
      2,
      0.842123,
      2,
      0,
      NULL,
      2.090027,
      0,
      2.704577,
      0,
      1.870526,
      1,
      3.626370,
      0.239803,
      1,
      3.012864,
      NULL,
      3,
      0.518259,
      0.410938,
      NULL,
      3.675081,
      1.762629,
      0.501887,
      2,
      2.326197,
      0.899172,
      2,
      0.671340,
      NULL,
      3.842429,
      4,
      1,
      3,
      3.900973,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1144,
      NULL,
      NULL,
      0.027782,
      NULL,
      NULL,
      3.896032,
      NULL,
      NULL,
      0.316563,
      NULL,
      NULL,
      1.969327,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.805038,
      NULL,
      NULL,
      NULL,
      NULL,
      0.718377,
      NULL,
      0.898651,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.087363,
      NULL,
      NULL,
      64.888318,
      183.118818,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.468499,
      NULL,
      NULL,
      NULL,
      1.705407,
      NULL,
      NULL,
      NULL,
      0.813680,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.054081,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.668424,
      1,
      NULL,
      NULL,
      1,
      0.083495,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.968166,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.121569,
      2.108180,
      NULL,
      NULL,
      1.951038,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.913424,
      0.695626,
      NULL,
      NULL,
      7.854526,
      9.375267,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.215099,
      NULL,
      17.515510,
      0,
      NULL,
      NULL,
      1.090793,
      NULL,
      NULL,
      0.960076,
      NULL,
      NULL,
      0.124893,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.471454,
      17651,
      NULL,
      NULL,
      0.304882,
      1,
      NULL,
      0.868977,
      0.171460,
      2,
      1,
      3.888430,
      1,
      1.640954,
      0,
      2.254573,
      1.214175,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.721383,
      NULL,
      0.299666,
      NULL,
      1,
      NULL,
      0.038082,
      NULL,
      NULL,
      NULL,
      2.187435,
      NULL,
      NULL,
      NULL,
      2.140108,
      0,
      NULL,
      0.097906,
      NULL,
      NULL,
      NULL,
      0.903529,
      NULL,
      1.397419,
      NULL,
      0.194540,
      NULL,
      1,
      NULL,
      1.619778,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.736479,
      NULL,
      0.948166,
      NULL,
      0.024769,
      NULL,
      0.665773,
      0,
      0.723425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188945,
      3.151695,
      NULL,
      0.941181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.060719,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.579779,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.072850,
      2.493041,
      NULL,
      3,
      NULL,
      0.833302,
      NULL,
      NULL,
      0.113702,
      0,
      1.060821,
      0,
      1,
      1.592584,
      1,
      0.816470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      10,
      1.111350,
      NULL,
      9,
      18.974175,
      NULL,
      2,
      0.942626,
      NULL,
      12.833807,
      NULL,
      NULL,
      3,
      0,
      NULL,
      2,
      2.407948,
      NULL,
      11,
      NULL,
      NULL,
      3,
      2,
      NULL,
      12,
      7,
      NULL,
      3.916362,
      3.712596,
      NULL,
      0,
      6.938969,
      NULL,
      2.611824,
      0,
      0.497597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.091113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.821757,
      1,
      1.632223,
      68,
      NULL,
      4,
      0.034032,
      6.417532,
      '00310',
      '32121',
      '00433',
      1,
      '',
      '',
      NULL,
      0.296752,
      '',
      '',
      '');
commit;
end;
/


