set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209216';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      1.148908,
      3.002327,
      0,
      7.171065,
      NULL,
      NULL,
      NULL,
      '442',
      '42434402',
      4.485630,
      60.308846,
      NULL,
      1,
      1,
      2,
      0,
      '3310',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      68,
      30,
      NULL,
      NULL,
      4,
      ' 2-14-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8-28-1996',
      ' 7-19-1995',
      NULL,
      3.895712,
      NULL,
      1.221708,
      NULL,
      1,
      0.510730,
      0,
      NULL,
      0.711238,
      44,
      4,
      19,
      9.103215,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0,
      0,
      0.466860,
      NULL,
      NULL,
      1,
      0,
      0.514296,
      NULL,
      NULL,
      2,
      0,
      3,
      2,
      4,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      4,
      1,
      1,
      9,
      2,
      NULL,
      NULL,
      NULL,
      0.152808,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.915398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      5,
      3,
      0,
      NULL,
      0,
      1,
      3,
      NULL,
      4.521934,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      5,
      4,
      0,
      1,
      0,
      5,
      NULL,
      NULL,
      0,
      3,
      1,
      5,
      3,
      0,
      0,
      0,
      2,
      0,
      2,
      1,
      1,
      2,
      NULL,
      2,
      NULL,
      2,
      3,
      ' 8-21-1977',
      301,
      ' 2-25-1999',
      4.131784,
      0.811825,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.683013,
      NULL,
      NULL,
      0,
      1.190846,
      0,
      3.316526,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.004111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071683,
      0.036298,
      1.690319,
      0.190334,
      0.171313,
      NULL,
      NULL,
      NULL,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.593745,
      NULL,
      NULL,
      2,
      1,
      1,
      3,
      0,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.377247,
      3,
      1.973637,
      0.582631,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1.610216,
      0,
      0.289813,
      8.874213,
      7,
      10,
      5,
      NULL,
      5,
      2,
      7,
      1.698762,
      1.584202,
      2.112475,
      30.688584,
      3,
      1.570258,
      46,
      NULL,
      NULL,
      5,
      0,
      4,
      1.369345,
      '44313',
      NULL,
      '',
      3,
      '20432',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.557746,
      NULL,
      99.416995,
      6,
      1,
      18,
      0,
      NULL,
      3,
      1,
      1.998881,
      1,
      0.918669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735298,
      NULL,
      NULL,
      0.205617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.147936,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.979397,
      3.866034,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.964530,
      NULL,
      NULL,
      0.075998,
      3,
      NULL,
      3,
      1.350717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.605309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.375884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824536,
      NULL,
      NULL,
      1.372803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882176,
      NULL,
      NULL,
      0.993041,
      NULL,
      NULL,
      NULL,
      1.964433,
      1.304802,
      1,
      NULL,
      NULL,
      4.609415,
      NULL,
      NULL,
      2.243828,
      1.270435,
      1.593294,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1,
      0.631252,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.621793,
      NULL,
      NULL,
      0.335795,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.491259,
      2.616933,
      3.801158,
      3.607227,
      4.351821,
      7,
      0.834431,
      NULL,
      NULL,
      NULL,
      2,
      1.716400,
      1.012078,
      1.700398,
      0.889999,
      3.446489,
      0.314517,
      0,
      3,
      7.798043,
      1,
      5,
      0,
      3.815890,
      0,
      0,
      3.583416,
      1,
      2,
      NULL,
      3,
      NULL,
      1.282345,
      0,
      1.931358,
      1.314463,
      NULL,
      5,
      1.722140,
      3.559708,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.530651,
      0.234489,
      0.948282,
      1.365130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.481329,
      NULL,
      1,
      1.435326,
      1,
      1,
      NULL,
      6.838420,
      NULL,
      NULL,
      NULL,
      13.935994,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149997,
      NULL,
      NULL,
      NULL,
      0.958002,
      NULL,
      NULL,
      NULL,
      0.500188,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.375688,
      NULL,
      NULL,
      NULL,
      0.313621,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.479623,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.098309,
      NULL,
      NULL,
      NULL,
      0.213714,
      NULL,
      NULL,
      NULL,
      3.208805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      0.048337,
      0,
      NULL,
      NULL,
      NULL,
      2.371280,
      3.401951,
      1,
      0.965782,
      9,
      0.081487,
      1.204425,
      NULL,
      NULL,
      1.911292,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.894810,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.188696,
      0,
      0.834030,
      1,
      0.120801,
      0.510730,
      0.198717,
      1.738507,
      1,
      1,
      1.874173,
      1.722743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215931,
      0,
      0.782719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      70,
      NULL,
      1.240122,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.179351,
      NULL,
      0,
      2,
      NULL,
      0.962379,
      NULL,
      0,
      NULL,
      618,
      NULL,
      1.845583,
      NULL,
      1.372400,
      NULL,
      1.219016,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.128980,
      NULL,
      1.782629,
      NULL,
      1.237957,
      NULL,
      NULL,
      NULL,
      2.386506,
      1.835883,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      650.255812,
      NULL,
      3,
      NULL,
      1.812203,
      NULL,
      1.536374,
      NULL,
      2,
      0.754959,
      25.355376,
      NULL,
      1.311171,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      4,
      1,
      1,
      2,
      2,
      2,
      0,
      0.202418,
      1,
      1,
      1.936403,
      NULL,
      1,
      1.976242,
      NULL,
      NULL,
      1.306813,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.427897,
      NULL,
      0.233710,
      NULL,
      NULL,
      0,
      0.779199,
      NULL,
      0,
      0.839555,
      NULL,
      1,
      0,
      NULL,
      1.956115,
      3.676700,
      NULL,
      1.184455,
      1.938644,
      NULL,
      3.009729,
      1,
      0.528819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358820,
      NULL,
      1.924993,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.607426,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.611454,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.624942,
      NULL,
      1.712896,
      NULL,
      1,
      NULL,
      22.231197,
      1,
      NULL,
      1.956369,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      109,
      NULL,
      2,
      7.552664,
      '23302',
      NULL,
      '21312',
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


