set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217062';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '3122032',
      NULL,
      NULL,
      2,
      NULL,
      '3101',
      NULL,
      1,
      NULL,
      NULL,
      ' 9-19-1978',
      12.287601,
      NULL,
      1,
      1,
      3.631140,
      ' 7- 1-1996',
      23.346018,
      3.220722,
      198.954304,
      69,
      1,
      ' 9- 4-1997',
      ' 9- 4-1991',
      NULL,
      0,
      3,
      1.796267,
      3,
      NULL,
      1,
      NULL,
      1.579197,
      NULL,
      NULL,
      NULL,
      12,
      3.036274,
      27,
      NULL,
      2,
      2,
      2,
      0,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      0.241283,
      1,
      1,
      NULL,
      1,
      0,
      0,
      4,
      0,
      0,
      0,
      1,
      NULL,
      2,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.820984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      1,
      1,
      5,
      0,
      1,
      2,
      4,
      NULL,
      1,
      2,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      2,
      0,
      NULL,
      3,
      5,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      4,
      0,
      0,
      NULL,
      NULL,
      5,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      3,
      0,
      '10- 1-1993',
      10.167360,
      ' 7-19-1992',
      4.933007,
      0,
      2,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0.161301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      21.453714,
      3,
      0.363657,
      NULL,
      0.678286,
      NULL,
      1.871790,
      0,
      2.765388,
      2,
      0,
      0,
      1,
      1,
      0.469947,
      0,
      1.080411,
      NULL,
      0.335362,
      0,
      6.441405,
      0.548492,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.422466,
      NULL,
      0,
      NULL,
      1.297212,
      2.511923,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.047215,
      1,
      3,
      3,
      NULL,
      1,
      2,
      NULL,
      2,
      3,
      0,
      NULL,
      1.462488,
      1,
      0,
      NULL,
      0.024998,
      1,
      9,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.021766,
      0,
      NULL,
      0,
      1,
      2.915312,
      1,
      9.292399,
      0,
      NULL,
      NULL,
      1,
      1.413061,
      2.786468,
      2,
      4.944966,
      3.296136,
      0,
      NULL,
      28.941933,
      0,
      2.281949,
      NULL,
      5,
      18,
      68,
      1,
      0.949263,
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      0,
      29.614111,
      1.066271,
      NULL,
      NULL,
      NULL,
      NULL,
      0.467198,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.108833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.200300,
      NULL,
      NULL,
      1.132280,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946813,
      NULL,
      NULL,
      0.121364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853644,
      NULL,
      NULL,
      0.816643,
      NULL,
      NULL,
      0.882966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.225274,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.351248,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.283010,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.240580,
      NULL,
      NULL,
      1.336095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.310021,
      NULL,
      NULL,
      0.535300,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.256174,
      3,
      0,
      2.801866,
      NULL,
      1.434862,
      2,
      2,
      1.206561,
      1,
      2.443986,
      0.205207,
      0.273094,
      3.285090,
      1,
      4,
      NULL,
      4,
      1,
      NULL,
      NULL,
      1,
      0.454493,
      1.276709,
      NULL,
      0.108209,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      1.732010,
      0.649489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066201,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.000057,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.349478,
      580,
      6.286027,
      1,
      NULL,
      0.708273,
      1.933164,
      1.187048,
      0,
      NULL,
      0.662431,
      1,
      1.096546,
      1.394574,
      NULL,
      NULL,
      1.170884,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.753098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      3.689769,
      1,
      1.354026,
      1.924505,
      1,
      7,
      1.891004,
      NULL,
      0,
      0.400993,
      NULL,
      NULL,
      NULL,
      1.569410,
      NULL,
      0.738608,
      3.835721,
      NULL,
      1.335350,
      1,
      NULL,
      0,
      2.734595,
      NULL,
      0,
      1.657785,
      NULL,
      0.200800,
      1.977654,
      NULL,
      1,
      1.312326,
      NULL,
      0,
      1,
      NULL,
      0.342979,
      0,
      NULL,
      1.464718,
      0,
      NULL,
      3,
      1.435127,
      1.242991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.907411,
      NULL,
      NULL,
      0,
      NULL,
      0.886341,
      NULL,
      0,
      NULL,
      1.779164,
      NULL,
      0.078152,
      NULL,
      0.212234,
      NULL,
      1.202808,
      NULL,
      1.813421,
      NULL,
      1.446846,
      NULL,
      NULL,
      NULL,
      1.075469,
      NULL,
      2,
      NULL,
      35,
      0,
      0.344813,
      1.292210,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      109.140657,
      82.921248,
      NULL,
      1.022570,
      2.036703,
      '12202',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


