set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '2302340',
      0,
      1,
      2,
      NULL,
      '4400',
      0.712917,
      1,
      NULL,
      NULL,
      ' 2-29-1976',
      46.484377,
      NULL,
      4,
      2,
      3.165123,
      ' 2-20-1991',
      3.331352,
      0,
      NULL,
      87.947652,
      3,
      ' 7- 3-1986',
      ' 4-28-1976',
      ' 7- 1-1984',
      3,
      0.921062,
      0,
      1,
      0.838032,
      3.265763,
      NULL,
      2.915729,
      NULL,
      NULL,
      NULL,
      12,
      2,
      24.388863,
      22.632167,
      4,
      13,
      2,
      3,
      1,
      NULL,
      1,
      1,
      1.474362,
      1,
      1,
      0,
      0.187504,
      1,
      NULL,
      NULL,
      5,
      2,
      7,
      1.599605,
      NULL,
      NULL,
      5,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0.551122,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.121422,
      3.746844,
      0.963781,
      0.546963,
      NULL,
      0,
      NULL,
      1,
      1.032501,
      1,
      0.749433,
      2,
      1.243520,
      1,
      NULL,
      0.437865,
      0,
      2,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0.086217,
      1,
      1,
      NULL,
      0,
      1.230266,
      NULL,
      1.116500,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      2,
      2,
      NULL,
      0,
      3,
      1,
      2,
      4,
      4,
      2,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.918412,
      '10-15-1992',
      54,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.700754,
      NULL,
      0.234125,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.412534,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.827520,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.578061,
      0.209138,
      1,
      0,
      1.531819,
      1,
      15,
      0.375388,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      2,
      1,
      NULL,
      1,
      2,
      NULL,
      3,
      2,
      NULL,
      0.419025,
      2,
      3.231083,
      0.824644,
      0,
      0,
      1.500849,
      1,
      0,
      1.395071,
      1.837981,
      NULL,
      0,
      1.086696,
      0,
      NULL,
      3,
      0.662277,
      11.636135,
      7,
      NULL,
      1,
      10.951306,
      NULL,
      1,
      0.854609,
      1.825403,
      0,
      3.342354,
      NULL,
      NULL,
      2,
      0.707824,
      NULL,
      24,
      33,
      56.634456,
      2,
      0,
      3,
      '31134',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      0,
      29,
      11.505276,
      26,
      1.538988,
      37.631680,
      5,
      2.781650,
      4,
      2,
      1.517467,
      0.771624,
      0.602921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640197,
      NULL,
      NULL,
      2,
      1.238041,
      1.081448,
      0,
      NULL,
      NULL,
      1.249842,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      0.377895,
      1,
      0.064481,
      NULL,
      NULL,
      0.570751,
      0.789288,
      1.661859,
      NULL,
      1.468664,
      1.341458,
      5.239876,
      6,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      2.320278,
      3.202411,
      NULL,
      NULL,
      NULL,
      NULL,
      0.733177,
      1,
      1.341701,
      NULL,
      3,
      NULL,
      2,
      3,
      1.374233,
      0.597932,
      0.405547,
      0,
      0.724118,
      0.377014,
      1,
      3,
      NULL,
      3.886268,
      0.324888,
      0,
      0,
      1,
      0,
      NULL,
      0.003581,
      NULL,
      5.441526,
      NULL,
      0,
      0.454746,
      NULL,
      NULL,
      NULL,
      0.982012,
      NULL,
      NULL,
      NULL,
      1.261245,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.074896,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328047,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.179285,
      NULL,
      NULL,
      0.295621,
      NULL,
      NULL,
      0.546309,
      NULL,
      NULL,
      0.143119,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.626343,
      NULL,
      NULL,
      5,
      2.043509,
      NULL,
      4.986735,
      3.419932,
      3,
      0.008434,
      NULL,
      NULL,
      0.283141,
      NULL,
      1.520759,
      3,
      2.671505,
      2.782808,
      3,
      0.571510,
      NULL,
      2.607967,
      0.087538,
      4,
      NULL,
      3,
      1.827153,
      2,
      3.639336,
      1.008046,
      0,
      0.471197,
      0.523712,
      3.103188,
      0.780583,
      0.834864,
      4.941036,
      0,
      7.401106,
      4.832100,
      0,
      NULL,
      2,
      0,
      3,
      0.697888,
      NULL,
      1.261128,
      0.008200,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.964640,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.139327,
      NULL,
      NULL,
      1.625137,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.110055,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.143944,
      NULL,
      NULL,
      NULL,
      0.684821,
      NULL,
      NULL,
      NULL,
      1.571768,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.766336,
      NULL,
      NULL,
      3.288824,
      0,
      NULL,
      NULL,
      0.067941,
      NULL,
      NULL,
      NULL,
      2.834317,
      NULL,
      NULL,
      NULL,
      NULL,
      1.309700,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.877097,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3,
      2.344951,
      0,
      2.673355,
      1,
      0.585345,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.683719,
      NULL,
      NULL,
      NULL,
      1.965790,
      NULL,
      0.418671,
      NULL,
      1,
      42,
      1,
      1.646778,
      1.555457,
      0.347297,
      0.453659,
      1.830749,
      NULL,
      0.065632,
      0,
      0,
      NULL,
      0.012951,
      NULL,
      NULL,
      1.448629,
      1,
      1,
      1.310209,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354299,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.385918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.762184,
      0.016588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049167,
      1.067024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887035,
      3.701732,
      NULL,
      NULL,
      NULL,
      0.113011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2.744203,
      NULL,
      NULL,
      2.099984,
      NULL,
      1,
      NULL,
      0.070823,
      0,
      NULL,
      0,
      NULL,
      1.294845,
      0,
      NULL,
      0.544778,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.967592,
      NULL,
      0.200395,
      1,
      NULL,
      NULL,
      0.452645,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.365729,
      NULL,
      1,
      0.187304,
      NULL,
      1,
      1.459844,
      NULL,
      0.786266,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.595356,
      NULL,
      0,
      NULL,
      1,
      3,
      3,
      0,
      NULL,
      NULL,
      100,
      12,
      NULL,
      1,
      1.564861,
      '02443',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


