set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9691800';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00',
      NULL,
      NULL,
      4.881465,
      '4104221',
      3,
      1.793202,
      NULL,
      NULL,
      '1413',
      NULL,
      0.702597,
      NULL,
      NULL,
      ' 1- 8-1985',
      109,
      5.570779,
      NULL,
      0,
      0,
      ' 9-11-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 2-11-1986',
      ' 9- 6-1988',
      '11-23-1999',
      NULL,
      3.174183,
      0,
      2.516773,
      2,
      0.368255,
      1,
      NULL,
      1,
      10,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.827986,
      1,
      0.557082,
      NULL,
      NULL,
      0,
      3,
      2,
      7,
      1.829202,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      NULL,
      0,
      0,
      3.113207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1.253072,
      2,
      NULL,
      1.218114,
      NULL,
      0.176663,
      2.767404,
      2.227345,
      NULL,
      0,
      0,
      2.181600,
      1.297471,
      NULL,
      1.124282,
      NULL,
      1,
      0,
      1,
      1,
      6.491610,
      NULL,
      NULL,
      1.771939,
      1.593054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      0,
      4,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      1.914002,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      2,
      4,
      5,
      5,
      1,
      1,
      0,
      0,
      1,
      0,
      1.795476,
      '10-23-1982',
      694,
      ' 8- 0-1977',
      410.373294,
      0.594465,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.809979,
      1,
      0,
      1,
      1.375114,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.859106,
      NULL,
      0.946166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.414425,
      1,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      0.740284,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.313857,
      3,
      1,
      NULL,
      3,
      2,
      0,
      NULL,
      1,
      2,
      2,
      5.008707,
      2.725087,
      1.542671,
      6.507522,
      0,
      1,
      5,
      1.216698,
      1,
      1.365040,
      0,
      1,
      3,
      0.501464,
      0.691122,
      0,
      3.507076,
      0,
      1.420781,
      11.963476,
      7.979410,
      0.195913,
      2,
      0,
      NULL,
      5,
      0,
      0,
      3.459283,
      2.681155,
      2,
      65,
      0,
      3.094648,
      28,
      NULL,
      47,
      80.920047,
      0,
      4.655549,
      NULL,
      '01242',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      1.447130,
      '',
      NULL,
      NULL,
      0,
      56.832630,
      212.621414,
      13.315806,
      NULL,
      31.159264,
      2,
      1.764211,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.599633,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.177772,
      NULL,
      NULL,
      0.752734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1.638713,
      2.718260,
      3.951427,
      3.847344,
      2,
      0,
      1.522457,
      1,
      1.072280,
      NULL,
      2.252245,
      3.484482,
      1,
      NULL,
      0.061915,
      2.830426,
      2.918800,
      NULL,
      0.780090,
      0,
      0.805543,
      1.107414,
      1,
      NULL,
      NULL,
      1.359587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      4.127523,
      3,
      0.833997,
      NULL,
      NULL,
      NULL,
      0.739891,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830613,
      NULL,
      NULL,
      1.728432,
      NULL,
      NULL,
      1.888349,
      NULL,
      NULL,
      0.502858,
      NULL,
      NULL,
      0.656918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.464696,
      NULL,
      NULL,
      1.339944,
      NULL,
      NULL,
      0.261040,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.424760,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.880643,
      1,
      NULL,
      NULL,
      0.296014,
      0.170617,
      3,
      0,
      0,
      0.533515,
      0,
      1.792233,
      1.313261,
      NULL,
      NULL,
      0,
      1,
      1.389086,
      4.372378,
      0,
      NULL,
      0.987556,
      NULL,
      NULL,
      2.866676,
      3,
      0,
      1.514431,
      0.912672,
      0,
      0.135075,
      1.234366,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.339681,
      NULL,
      NULL,
      1.675793,
      NULL,
      NULL,
      0.381614,
      NULL,
      NULL,
      1.660901,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.785486,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      2,
      NULL,
      NULL,
      5.109783,
      0,
      NULL,
      NULL,
      0.224091,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.583570,
      NULL,
      NULL,
      NULL,
      1.442813,
      0.651151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986667,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.621419,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.481086,
      NULL,
      NULL,
      NULL,
      0,
      1.266934,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.915071,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.356290,
      NULL,
      NULL,
      9,
      3,
      NULL,
      NULL,
      3.325531,
      1,
      6,
      4,
      NULL,
      NULL,
      8,
      0,
      2,
      8,
      0.733679,
      NULL,
      NULL,
      1.721038,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.429119,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      164.759240,
      20.063091,
      1,
      3.301319,
      0.770126,
      1,
      1,
      0.180120,
      NULL,
      1.446838,
      1.924832,
      0,
      0,
      1.673448,
      1,
      0.425842,
      0,
      0.457059,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.790104,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.235630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      1.144709,
      0,
      1,
      NULL,
      NULL,
      0.130481,
      1.484412,
      0,
      1.674163,
      1,
      NULL,
      0.611479,
      1.665845,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.497587,
      0.404321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.666472,
      3.906258,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0.266058,
      0.832655,
      1,
      0,
      0.270588,
      0,
      0.776957,
      1.815872,
      NULL,
      0,
      1.959435,
      0,
      0,
      1,
      1.802100,
      NULL,
      0.343762,
      1.529476,
      1,
      1,
      NULL,
      1,
      NULL,
      1.760685,
      1.437522,
      1.553401,
      1.654376,
      1,
      1,
      0,
      0,
      1.839926,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      1.940775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.523642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.710470,
      1.925137,
      1.369299,
      1.489663,
      0,
      1,
      5,
      4,
      1.864098,
      NULL,
      NULL,
      44.895671,
      49,
      4,
      NULL,
      0.660636,
      '11200',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.775324,
      NULL,
      NULL,
      '');
commit;
end;
/


