set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8912976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      '3431',
      NULL,
      1.316822,
      NULL,
      NULL,
      ' 8- 4-1982',
      NULL,
      NULL,
      1,
      3.827203,
      NULL,
      ' 2- 6-1975',
      34.857829,
      NULL,
      143,
      88,
      NULL,
      ' 1-18-1992',
      ' 2-25-1989',
      NULL,
      0.306539,
      NULL,
      3.989991,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.472859,
      194,
      7,
      3.753335,
      8.808826,
      NULL,
      NULL,
      2,
      23.694833,
      3,
      NULL,
      4,
      0,
      NULL,
      0,
      1.605925,
      NULL,
      1.597595,
      0,
      0.816467,
      1,
      0.320447,
      93.154626,
      0,
      3,
      0,
      2,
      5,
      1,
      4,
      0,
      0,
      2,
      2,
      4,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      2,
      2,
      1,
      1.438825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      8.441609,
      NULL,
      NULL,
      NULL,
      0.447707,
      3,
      3.152876,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.913385,
      2,
      3.187804,
      5,
      4,
      5,
      6,
      0,
      NULL,
      5.760368,
      1.593489,
      NULL,
      NULL,
      1.765481,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      2,
      0,
      5,
      2,
      2,
      1,
      4,
      5,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.549051,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      3,
      0,
      2,
      3,
      0,
      2,
      NULL,
      5,
      NULL,
      0,
      3,
      4,
      3,
      4,
      2,
      0,
      5,
      3,
      1,
      6,
      1,
      ' 5- 2-1979',
      630,
      ' 6- 2-1980',
      NULL,
      3,
      2,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.905542,
      0.869382,
      NULL,
      NULL,
      NULL,
      1.923655,
      1,
      NULL,
      3,
      1.770779,
      5.520665,
      0.999509,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0.609533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.059096,
      1.519966,
      0.770943,
      NULL,
      0,
      0.434492,
      1.583101,
      31,
      0.782378,
      0,
      31.348261,
      10.733832,
      116,
      0,
      1.891362,
      0.929816,
      0,
      2,
      2,
      1,
      2,
      3,
      1,
      1,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      1.840019,
      NULL,
      0,
      0,
      0.411438,
      0.330718,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.431326,
      1.991444,
      1,
      6,
      2.582870,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3.060026,
      56,
      NULL,
      0,
      NULL,
      17,
      NULL,
      39.397815,
      0,
      1,
      0,
      '24133',
      '31323',
      NULL,
      0,
      '',
      '',
      NULL,
      4.671764,
      '01412',
      '2021',
      '',
      3.153465,
      30.097053,
      209.552309,
      NULL,
      1,
      5.435496,
      NULL,
      152.912796,
      2,
      0.618161,
      1.428415,
      1.504720,
      1,
      NULL,
      NULL,
      1,
      1.626373,
      1.860662,
      0,
      NULL,
      NULL,
      1.250074,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.490469,
      1.470193,
      2,
      0.781246,
      NULL,
      NULL,
      1.341417,
      NULL,
      NULL,
      1.693891,
      NULL,
      NULL,
      1.046236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.810084,
      10,
      1.581059,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.822948,
      NULL,
      0,
      NULL,
      3,
      2.613984,
      1.739114,
      3,
      3.382732,
      0.228763,
      0,
      0,
      NULL,
      NULL,
      0,
      3,
      1.805667,
      2,
      3.622085,
      2,
      NULL,
      1,
      1,
      2,
      1.253683,
      2.391193,
      2.685961,
      3,
      0,
      NULL,
      NULL,
      0.105304,
      3,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.914738,
      NULL,
      NULL,
      NULL,
      0.493111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.496461,
      1,
      0.718718,
      0.051128,
      0.028408,
      0.648189,
      NULL,
      NULL,
      5,
      9.649624,
      0,
      NULL,
      3.756071,
      3.036122,
      0.583439,
      NULL,
      NULL,
      3,
      4.075774,
      2.070712,
      1.122847,
      NULL,
      NULL,
      1.684608,
      NULL,
      NULL,
      0.555835,
      NULL,
      NULL,
      0.568274,
      NULL,
      NULL,
      0.561491,
      0.339464,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      0.883316,
      2.221354,
      NULL,
      2.204405,
      2,
      8,
      NULL,
      7,
      5,
      0,
      1.446271,
      NULL,
      NULL,
      0,
      3.593854,
      NULL,
      2.026989,
      NULL,
      1.950179,
      NULL,
      5,
      0.884156,
      1,
      NULL,
      2.807411,
      NULL,
      2.013425,
      1,
      0,
      2,
      NULL,
      NULL,
      3.774905,
      3.200830,
      7.553182,
      6.742583,
      7,
      4.726474,
      NULL,
      5.013054,
      NULL,
      3,
      1,
      1,
      1,
      0.256286,
      0,
      1,
      0.009197,
      NULL,
      NULL,
      3.882783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.034502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1.909434,
      0.355905,
      1.076081,
      1.878581,
      0,
      0.159009,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.031185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.761203,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.220803,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.219424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      0,
      182.069527,
      239.337703,
      1.152340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.464044,
      0.168697,
      3,
      2.797688,
      32.774856,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      0,
      375,
      4,
      0.362144,
      1,
      0.245074,
      0.980302,
      NULL,
      0.187795,
      0.116558,
      2,
      0,
      NULL,
      1.508814,
      0,
      0.380601,
      1.379256,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.692580,
      NULL,
      0.821386,
      NULL,
      0,
      NULL,
      0.078316,
      NULL,
      1,
      NULL,
      90,
      NULL,
      1.933120,
      23,
      NULL,
      0.450695,
      0,
      NULL,
      NULL,
      1.269834,
      NULL,
      0.351245,
      NULL,
      1.688139,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.903952,
      NULL,
      1.139373,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.463095,
      NULL,
      1,
      3.701155,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.924778,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.352948,
      1.260101,
      1.949592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0.252472,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.449153,
      NULL,
      NULL,
      1,
      NULL,
      1.051209,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.202314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.921041,
      NULL,
      0.087688,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.966325,
      NULL,
      1.744490,
      NULL,
      0,
      NULL,
      475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      8.015523,
      41.078374,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.624057,
      NULL,
      2,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.886919,
      1.668058,
      NULL,
      1.286392,
      0,
      NULL,
      1.328936,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.179333,
      NULL,
      NULL,
      1,
      NULL,
      0.032002,
      1.933234,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.452667,
      1,
      NULL,
      NULL,
      0.365281,
      NULL,
      NULL,
      0.374490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.324104,
      NULL,
      1.498362,
      NULL,
      0,
      0,
      3,
      2,
      0.271860,
      0.240639,
      42,
      16.538971,
      3,
      1.565263,
      7,
      NULL,
      '32234',
      '43243',
      1.295847,
      '',
      NULL,
      '',
      5,
      '24412',
      '1120',
      '');
commit;
end;
/


