set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '13',
      '40',
      6.137462,
      11.080411,
      '1330313',
      1.703775,
      0,
      NULL,
      1,
      '0343',
      2.505914,
      NULL,
      NULL,
      NULL,
      ' 1- 9-1997',
      20.302774,
      32.514790,
      NULL,
      0,
      1,
      ' 1-13-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 6-12-1993',
      NULL,
      '10-27-1977',
      1.730201,
      0.826548,
      3,
      1,
      1.222788,
      3,
      1,
      1,
      0,
      NULL,
      6,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      4,
      1,
      0,
      NULL,
      1,
      4,
      NULL,
      4,
      NULL,
      5,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.796184,
      NULL,
      NULL,
      0,
      3,
      3,
      0.196583,
      0,
      1,
      NULL,
      NULL,
      0,
      3,
      0.792196,
      0.125206,
      0.432133,
      0,
      0,
      3,
      1.641433,
      0.967786,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1.650304,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      4,
      0,
      1,
      1,
      4,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      4.352929,
      0,
      1,
      NULL,
      0,
      0.303186,
      NULL,
      0.725104,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      4,
      1,
      5,
      NULL,
      NULL,
      4,
      1,
      1,
      5,
      0,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      211,
      NULL,
      33.259546,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0.546868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      8.448467,
      1.157195,
      2.612273,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      3.447119,
      NULL,
      1.590477,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.936684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.877552,
      NULL,
      NULL,
      1.126543,
      0,
      NULL,
      1.549317,
      2,
      51.809190,
      1.534945,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      3,
      0,
      2,
      0,
      0,
      0.380236,
      3,
      NULL,
      2,
      0,
      0,
      5.238669,
      1.675640,
      0.466662,
      1,
      0.776577,
      0.208212,
      0.346165,
      NULL,
      NULL,
      0,
      0.444996,
      1,
      0,
      0,
      11,
      3.506480,
      3,
      NULL,
      1.623272,
      0.192403,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.470587,
      46,
      NULL,
      17,
      47,
      3,
      2,
      NULL,
      '00411',
      '32343',
      '',
      NULL,
      NULL,
      '',
      '',
      0.170595,
      '',
      '',
      '',
      3.574197,
      NULL,
      58,
      5.000007,
      3,
      3.222529,
      0,
      3,
      4,
      0.619089,
      0.854760,
      NULL,
      1.244814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574502,
      0.210750,
      0,
      1,
      NULL,
      NULL,
      1.757542,
      NULL,
      NULL,
      2,
      NULL,
      3.782058,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.096452,
      NULL,
      NULL,
      3.417098,
      NULL,
      3.896513,
      1,
      NULL,
      NULL,
      2,
      2,
      5.327017,
      1,
      1.030499,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.679166,
      0,
      NULL,
      0.293011,
      NULL,
      NULL,
      0.692559,
      NULL,
      NULL,
      NULL,
      1.134296,
      1.785398,
      3,
      1,
      3,
      2,
      3.400499,
      1.791616,
      1,
      3.102433,
      0,
      0,
      1.239434,
      0.415643,
      0.428833,
      1.300307,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082250,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.021760,
      3,
      0.051430,
      0,
      NULL,
      NULL,
      6.799122,
      1,
      NULL,
      NULL,
      2,
      2,
      1.692137,
      NULL,
      NULL,
      4.474846,
      5.456090,
      4.243386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.577531,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.555760,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.885670,
      NULL,
      NULL,
      2.981938,
      3,
      3,
      0.315106,
      0.188856,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.348592,
      1.173410,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      3,
      1.828359,
      NULL,
      3,
      3,
      2.596473,
      3,
      NULL,
      1,
      2,
      2.716774,
      2,
      3.222972,
      3,
      6,
      3.200481,
      3.065565,
      NULL,
      0.916375,
      3,
      3,
      1,
      0,
      1,
      0.343640,
      1.962521,
      1,
      NULL,
      NULL,
      1.574875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.393068,
      NULL,
      NULL,
      0.554766,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.578796,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.477052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360804,
      NULL,
      NULL,
      NULL,
      0.635261,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1.008442,
      2.707551,
      63.033473,
      1.248129,
      NULL,
      NULL,
      0.190443,
      NULL,
      NULL,
      0.913792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298209,
      NULL,
      NULL,
      0.890117,
      NULL,
      NULL,
      NULL,
      0.637008,
      0.561669,
      NULL,
      3,
      1.582904,
      NULL,
      0.339856,
      2.253523,
      1,
      1.240249,
      0,
      1,
      0.924041,
      NULL,
      0.560625,
      NULL,
      1,
      NULL,
      0.713418,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.193181,
      NULL,
      3,
      NULL,
      13.404290,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.637695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.707175,
      NULL,
      1,
      NULL,
      1.029211,
      NULL,
      1.820078,
      NULL,
      0.300242,
      NULL,
      0,
      NULL,
      0.460932,
      NULL,
      0,
      NULL,
      1.722451,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.336882,
      NULL,
      1.830676,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156618,
      1.661638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.410150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.905653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871783,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.879323,
      1.215227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.120085,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.798744,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      0,
      NULL,
      0.556108,
      3,
      12.120695,
      3,
      0,
      1.375139,
      0.797269,
      0.557283,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.467038,
      NULL,
      2,
      0.238815,
      NULL,
      3,
      NULL,
      NULL,
      2,
      1.146574,
      NULL,
      NULL,
      3.703852,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.606159,
      0,
      1.303471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.101232,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.513412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.919196,
      NULL,
      NULL,
      NULL,
      0.877172,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      16.522196,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2.093682,
      0,
      NULL,
      NULL,
      56,
      2,
      1,
      0.861767,
      '42032',
      NULL,
      '',
      1.031148,
      '',
      '',
      '',
      1.647396,
      '',
      '',
      '');
commit;
end;
/


