set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8515975';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '2013342',
      NULL,
      0,
      1,
      3,
      '3241',
      1.482717,
      1,
      4,
      36.155334,
      ' 8-20-1977',
      67,
      NULL,
      4,
      2.535306,
      0,
      ' 4-18-2002',
      68,
      3.163774,
      46,
      94.320224,
      5,
      NULL,
      NULL,
      ' 0- 4-1997',
      3.656309,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0.301426,
      1.451816,
      81,
      NULL,
      13,
      NULL,
      NULL,
      8.013694,
      1,
      17,
      5,
      1,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      0.509563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      3,
      2,
      2,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      0,
      2,
      3.148032,
      NULL,
      1.730079,
      11.475591,
      0.717046,
      1,
      NULL,
      0.881977,
      NULL,
      2.670970,
      1.673479,
      1,
      NULL,
      0.689573,
      NULL,
      1.493124,
      11.748177,
      0,
      NULL,
      5,
      8,
      2,
      NULL,
      3.882660,
      NULL,
      3.585048,
      3,
      3,
      5.156185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      34.297697,
      467,
      16,
      NULL,
      NULL,
      0.127123,
      29.775265,
      NULL,
      1.178005,
      1.102148,
      15,
      2.056611,
      NULL,
      7.197703,
      3.999216,
      2,
      3.317534,
      2,
      0,
      NULL,
      0.894648,
      NULL,
      NULL,
      1.511116,
      NULL,
      NULL,
      0,
      NULL,
      3.702838,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.267629,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.870489,
      NULL,
      NULL,
      NULL,
      1,
      0.895206,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      11.230871,
      2,
      NULL,
      NULL,
      1.920086,
      NULL,
      0.722086,
      NULL,
      2.250033,
      18.668828,
      NULL,
      NULL,
      NULL,
      1,
      1.642470,
      1.070457,
      1,
      2,
      0,
      2.621435,
      0.303743,
      0,
      0.282239,
      1.156199,
      1,
      1,
      0.939919,
      1,
      1,
      NULL,
      NULL,
      1.918044,
      0.425466,
      16.752916,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      14.729368,
      0,
      NULL,
      NULL,
      3.262252,
      NULL,
      NULL,
      0.526448,
      1.927735,
      2,
      0,
      NULL,
      NULL,
      6.186848,
      0,
      1,
      3.093655,
      3.464670,
      19,
      0,
      NULL,
      14.097871,
      1.876249,
      4.216144,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.293147,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.373741,
      3,
      NULL,
      0.739519,
      2,
      NULL,
      0.807359,
      3.725535,
      5.652748,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9,
      NULL,
      NULL,
      3,
      0,
      1,
      1.743417,
      NULL,
      5,
      4.075555,
      1.812303,
      NULL,
      2,
      NULL,
      NULL,
      1.908644,
      3,
      2.286019,
      0.268517,
      2,
      3,
      3,
      1,
      NULL,
      NULL,
      7,
      2.272801,
      2,
      2,
      NULL,
      1,
      4,
      0,
      0,
      NULL,
      1,
      1,
      0.754468,
      NULL,
      NULL,
      0.066438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      12.280250,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      7.361802,
      NULL,
      NULL,
      17.704942,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.950033,
      2.454342,
      0.074050,
      0,
      1.018022,
      2,
      NULL,
      NULL,
      1.389949,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      7.666187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.438467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      14,
      NULL,
      NULL,
      12,
      13,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      18,
      1.070813,
      NULL,
      NULL,
      0,
      6.960171,
      NULL,
      NULL,
      0.194054,
      7,
      NULL,
      NULL,
      0.355883,
      0,
      NULL,
      NULL,
      0,
      2,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1319,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.713201,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.986317,
      NULL,
      1.878491,
      7762.877302,
      933,
      0,
      0.800126,
      1,
      1,
      0.901961,
      0.141417,
      NULL,
      1,
      1,
      0.415444,
      NULL,
      0,
      1.113247,
      1.361845,
      0.236017,
      NULL,
      1.859406,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      0.224379,
      3,
      1.852070,
      1,
      0,
      10.364401,
      3.706499,
      3.512750,
      3.727093,
      NULL,
      1.061259,
      1.233036,
      7,
      NULL,
      15.915079,
      10.219659,
      3,
      1.842258,
      NULL,
      NULL,
      NULL,
      1.220686,
      1.573362,
      NULL,
      11.775107,
      7,
      2.106833,
      0.148675,
      3,
      3,
      2.678939,
      4,
      NULL,
      2,
      13,
      NULL,
      12,
      NULL,
      NULL,
      10.042353,
      5.372335,
      NULL,
      3,
      1.763294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368859,
      NULL,
      2,
      1.896684,
      NULL,
      1,
      NULL,
      2.029048,
      3.811977,
      2,
      1,
      3.507033,
      0,
      1.602277,
      0.191729,
      1,
      3,
      7.917763,
      19.494387,
      NULL,
      0.103994,
      0,
      NULL,
      2,
      0.384512,
      0,
      0.817826,
      42.497628,
      0.038101,
      NULL,
      0.610563,
      1,
      2.197727,
      2.024202,
      0,
      0,
      1,
      3,
      7,
      0.627185,
      NULL,
      1,
      48.186822,
      NULL,
      5,
      1.987075,
      5.271535,
      '10312',
      '02033',
      '',
      0.518127,
      '',
      '',
      '',
      1.217597,
      '',
      '',
      '');
commit;
end;
/


