set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0108712';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.556596,
      NULL,
      3.912209,
      5.927532,
      NULL,
      1,
      NULL,
      4.733443,
      '332',
      '22312402',
      36,
      63.529622,
      '0224140',
      3.284157,
      0,
      3,
      2,
      '4204',
      NULL,
      0.720062,
      NULL,
      NULL,
      ' 7- 8-2000',
      263.985714,
      163,
      NULL,
      3,
      2,
      ' 1- 4-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      ' 9-25-1992',
      NULL,
      1.267432,
      0,
      1.620416,
      0,
      NULL,
      7,
      NULL,
      NULL,
      16,
      0,
      0.857725,
      3.876805,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.707476,
      3,
      1,
      0.388322,
      0,
      1,
      0.851765,
      1,
      1,
      1.530733,
      0,
      0,
      3,
      5,
      2,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.197167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0.170765,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0.835729,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      3,
      0,
      3,
      4,
      5,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.809092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.700008,
      NULL,
      NULL,
      NULL,
      2,
      0.908670,
      2.677709,
      2.508025,
      1,
      0.007541,
      1.696558,
      NULL,
      NULL,
      NULL,
      0.556104,
      3.048114,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746799,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.218881,
      3.922190,
      3,
      0,
      13.716857,
      2.094171,
      40.565434,
      2,
      0.628702,
      1,
      3,
      2,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      3,
      1,
      0.160986,
      3.432390,
      0,
      0.889304,
      1,
      NULL,
      4.319095,
      NULL,
      1,
      1.818186,
      0,
      1,
      2.405361,
      0.425886,
      1,
      3,
      NULL,
      NULL,
      1.176472,
      7.879803,
      4.412300,
      3,
      1.258211,
      8.323482,
      2,
      3,
      1.545038,
      5.377593,
      1,
      1,
      2.744647,
      53,
      NULL,
      1.993453,
      NULL,
      NULL,
      79,
      36,
      3,
      5.988250,
      7,
      '41221',
      NULL,
      '44113',
      1.825277,
      '',
      '',
      NULL,
      0.986952,
      NULL,
      '',
      '',
      0.590465,
      8,
      NULL,
      56.230989,
      2.823388,
      3.994164,
      3,
      29.365870,
      5,
      1.380587,
      1,
      3.479388,
      1.577974,
      0,
      0,
      0.414226,
      NULL,
      NULL,
      0.812206,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      1,
      3,
      0.442335,
      NULL,
      NULL,
      2,
      0,
      1.192326,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0.129647,
      0.619279,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.905564,
      3,
      2.429325,
      0.912813,
      1.195547,
      NULL,
      1.389266,
      2,
      2,
      0,
      NULL,
      1,
      1.447377,
      0.185942,
      0,
      0,
      2,
      1.918716,
      2,
      NULL,
      0,
      0,
      1,
      NULL,
      0.154488,
      1.886028,
      1.270018,
      1.518988,
      NULL,
      NULL,
      0,
      0.775008,
      1,
      2,
      0.730817,
      NULL,
      2,
      1.186198,
      3.468720,
      0,
      0.056630,
      NULL,
      NULL,
      NULL,
      2.161131,
      1.029025,
      1,
      3.468440,
      2,
      0.811953,
      0.892415,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143796,
      1,
      1,
      NULL,
      NULL,
      6,
      2.398842,
      NULL,
      0.704154,
      1.206845,
      2,
      0.364621,
      NULL,
      NULL,
      NULL,
      0.623110,
      5.827357,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.597771,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.671168,
      0,
      NULL,
      3.649321,
      0,
      0.026404,
      2,
      1.507375,
      0.470681,
      5.450363,
      1,
      0.185988,
      1.769191,
      NULL,
      NULL,
      1,
      0.316760,
      NULL,
      0.066232,
      0.067438,
      3.621579,
      0.777184,
      3.077398,
      NULL,
      NULL,
      1,
      0.127603,
      3,
      0,
      NULL,
      2.123256,
      0,
      0.741067,
      1,
      NULL,
      3,
      0.751807,
      2.913525,
      1.577550,
      2,
      0.464285,
      4.725316,
      NULL,
      3,
      NULL,
      1,
      NULL,
      4,
      0,
      NULL,
      0,
      0.514550,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.049087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.507574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.006474,
      NULL,
      NULL,
      NULL,
      NULL,
      0.444148,
      1.494686,
      3,
      0.048091,
      2.889417,
      NULL,
      4,
      0,
      0.906018,
      NULL,
      1.596384,
      NULL,
      NULL,
      NULL,
      3.297770,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.002275,
      3,
      1,
      NULL,
      1.143268,
      1,
      NULL,
      NULL,
      3,
      0.085138,
      NULL,
      NULL,
      0.427105,
      NULL,
      0.016378,
      NULL,
      0,
      1.295851,
      NULL,
      NULL,
      0,
      1.568242,
      NULL,
      NULL,
      NULL,
      1.795173,
      NULL,
      NULL,
      NULL,
      0.203134,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      0.584969,
      1.180348,
      NULL,
      3.457416,
      3.556744,
      2,
      NULL,
      0.268425,
      0.551907,
      NULL,
      NULL,
      NULL,
      0.096316,
      0,
      NULL,
      0,
      2.377837,
      0,
      NULL,
      NULL,
      0.936408,
      0,
      NULL,
      3,
      0.656671,
      5.793799,
      NULL,
      3,
      0.653948,
      NULL,
      NULL,
      NULL,
      2,
      39.277630,
      13,
      3,
      3,
      0.124671,
      1.874350,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.386862,
      NULL,
      NULL,
      0.115955,
      NULL,
      NULL,
      0.099225,
      NULL,
      0.818176,
      98,
      NULL,
      0,
      0.494071,
      0,
      1.452185,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1.610600,
      0,
      NULL,
      1.974740,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.592883,
      0,
      0.206750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.260167,
      0.526064,
      1.774182,
      103,
      NULL,
      2.978762,
      0,
      1.015499,
      1.356784,
      NULL,
      1,
      2.505854,
      0.221601,
      33,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      5.852628,
      3,
      NULL,
      0,
      3,
      9,
      2.482361,
      NULL,
      3,
      0,
      0,
      1.188686,
      1,
      2.159191,
      NULL,
      1.445157,
      0,
      1.466066,
      1,
      0,
      1,
      0,
      0.785959,
      NULL,
      1,
      1,
      1.315039,
      0.690998,
      1,
      1,
      0.092414,
      0,
      1.164261,
      NULL,
      0.141822,
      1,
      0,
      1,
      2,
      0.145997,
      1.048047,
      0,
      1,
      3.690886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682439,
      1,
      NULL,
      1.254765,
      1,
      0,
      2,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      7,
      '21424',
      '34243',
      '00001',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


