set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8807476';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '1014113',
      3.724051,
      0.067120,
      1,
      1,
      '2000',
      1,
      1.563018,
      NULL,
      NULL,
      NULL,
      22.850507,
      NULL,
      5,
      2,
      0.689844,
      ' 2-18-1981',
      40.625231,
      0,
      111.259441,
      74.467359,
      2,
      ' 5- 4-2001',
      ' 7-11-1981',
      ' 9- 3-1985',
      1.826647,
      0,
      NULL,
      1,
      NULL,
      3,
      0,
      1,
      0,
      85,
      NULL,
      4,
      4,
      71,
      1,
      NULL,
      10,
      NULL,
      2,
      8.705373,
      NULL,
      NULL,
      0,
      1,
      0.287277,
      0,
      1,
      0,
      1,
      1,
      121.394211,
      6,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      2,
      1,
      NULL,
      3,
      5,
      0,
      0,
      NULL,
      6,
      0,
      1,
      0,
      1,
      0.778191,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      2.418447,
      3,
      0,
      0.205030,
      NULL,
      1,
      NULL,
      2,
      3.248408,
      NULL,
      0.256859,
      0,
      NULL,
      0.285894,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      NULL,
      1.991710,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1,
      1,
      5,
      0,
      0,
      0,
      0,
      0,
      0,
      4,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      3,
      5,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      3,
      2,
      2,
      NULL,
      1,
      2,
      3,
      3,
      NULL,
      1,
      3,
      NULL,
      4,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      406.615476,
      ' 5-13-1990',
      645.435855,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1.161499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      6,
      1,
      0,
      8.749082,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.971955,
      1.470215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.400338,
      NULL,
      0.725095,
      0,
      1.697906,
      46,
      0.502590,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.495414,
      1,
      3,
      2,
      1,
      2,
      NULL,
      3,
      3,
      0,
      3,
      3,
      1,
      2,
      0,
      2,
      0,
      2.105640,
      0,
      0.049869,
      1.019934,
      0.353777,
      NULL,
      0.162877,
      1.357401,
      0,
      1,
      0,
      4,
      1.247080,
      2,
      3.252076,
      2.304506,
      8,
      11,
      3,
      0.448063,
      3,
      6.350236,
      2.028234,
      NULL,
      NULL,
      30,
      0,
      0.618084,
      NULL,
      NULL,
      24,
      35.915023,
      1,
      0,
      7,
      '11002',
      '23401',
      '01413',
      0.511566,
      '',
      NULL,
      '',
      NULL,
      '12120',
      NULL,
      '3314',
      3,
      33.760364,
      54.052650,
      NULL,
      NULL,
      NULL,
      3,
      42.627234,
      3,
      NULL,
      NULL,
      0.362125,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.315902,
      0.174559,
      NULL,
      2,
      1.484065,
      2.033449,
      3.258993,
      3,
      NULL,
      NULL,
      NULL,
      2.346879,
      3,
      NULL,
      0.387269,
      2.288226,
      2.058885,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.807212,
      5,
      4.901382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.233577,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423933,
      3.065357,
      NULL,
      3,
      0.038343,
      1.956617,
      3,
      3,
      NULL,
      1.844622,
      1,
      3.835639,
      2,
      2.008899,
      NULL,
      0,
      1.509720,
      0,
      NULL,
      0,
      1.234802,
      3,
      3.447819,
      2.349009,
      NULL,
      NULL,
      0.146420,
      0.457693,
      NULL,
      NULL,
      1.874319,
      0,
      NULL,
      10.833377,
      9.274324,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.048855,
      0.789213,
      1.503848,
      2,
      1.248546,
      1,
      NULL,
      NULL,
      0.500694,
      7.825800,
      NULL,
      NULL,
      1,
      NULL,
      1.436536,
      NULL,
      NULL,
      0,
      2,
      0.285915,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.275317,
      2,
      3,
      2,
      0,
      8.780530,
      7,
      0.276449,
      7.724550,
      NULL,
      1.187781,
      6,
      4,
      3.727821,
      2,
      2.113978,
      NULL,
      1,
      3.973270,
      3.122792,
      2.555363,
      1.865345,
      2.886436,
      NULL,
      2.735803,
      0.379960,
      0.124055,
      3,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      0,
      1,
      1.444963,
      NULL,
      NULL,
      9.251461,
      1.823428,
      7,
      8.311280,
      NULL,
      3.659835,
      3,
      4,
      1,
      1.792707,
      0,
      1.576743,
      1,
      1.714090,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295154,
      NULL,
      NULL,
      1.407470,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.687712,
      NULL,
      1,
      0.949893,
      0,
      1.955434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.628847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.154592,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.796626,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812509,
      NULL,
      NULL,
      NULL,
      0.658766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      46,
      87,
      2,
      NULL,
      1.493866,
      0,
      NULL,
      NULL,
      1,
      5,
      1,
      3,
      7.086026,
      1.606812,
      1,
      NULL,
      NULL,
      1.454028,
      NULL,
      1.928715,
      134,
      10.341066,
      0.099078,
      NULL,
      1,
      1,
      0.847623,
      1,
      0.955931,
      1.911617,
      1,
      0,
      1.968158,
      1,
      1,
      1,
      1.816142,
      1.419046,
      1,
      3.149490,
      NULL,
      1,
      NULL,
      0.263585,
      NULL,
      0,
      NULL,
      3.752992,
      NULL,
      2.178095,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.087018,
      NULL,
      0,
      NULL,
      1.484011,
      NULL,
      0,
      NULL,
      1.818525,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.220460,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.405224,
      3.105197,
      NULL,
      3.883948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.102787,
      NULL,
      NULL,
      NULL,
      1.809051,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.706333,
      0,
      NULL,
      0.176682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.150001,
      NULL,
      7.675801,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.682288,
      NULL,
      0.217541,
      3,
      2.181885,
      2,
      NULL,
      0.841864,
      0.641579,
      0,
      NULL,
      0,
      0.622234,
      NULL,
      0.132191,
      1.754846,
      NULL,
      NULL,
      1.615425,
      NULL,
      1.316871,
      1,
      NULL,
      1,
      1.099004,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0.355188,
      0.801847,
      NULL,
      0.324867,
      0.013121,
      NULL,
      1.431909,
      0,
      NULL,
      1,
      0.193151,
      0.779488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.597422,
      NULL,
      NULL,
      NULL,
      0.165804,
      NULL,
      NULL,
      NULL,
      5,
      2.678957,
      NULL,
      0,
      48.990198,
      NULL,
      NULL,
      1.050052,
      3.770988,
      '41203',
      '34401',
      '40102',
      1.308805,
      '',
      '',
      '',
      NULL,
      '13243',
      '1022',
      NULL);
commit;
end;
/


