set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902854';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '4124204',
      2,
      NULL,
      1,
      NULL,
      '4010',
      1,
      3.610788,
      5.186406,
      6,
      '10- 9-2001',
      33.770806,
      NULL,
      2,
      3,
      0.605575,
      '10-21-1979',
      37.351491,
      0.787536,
      46.392357,
      1179,
      0,
      NULL,
      NULL,
      ' 3-20-1975',
      3.759979,
      0.563445,
      1.852083,
      1.165840,
      0,
      NULL,
      NULL,
      1.630234,
      1.214465,
      NULL,
      5,
      8,
      3.530979,
      NULL,
      58.168787,
      5,
      6,
      4,
      0,
      0,
      NULL,
      1,
      2,
      1.288966,
      0,
      0.857691,
      0.389772,
      0.047263,
      1.339968,
      0,
      1.680152,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      0.988800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.782762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0.008113,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      3,
      5,
      1.213483,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.840945,
      0.686998,
      0,
      0.249956,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.395990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.518883,
      1.205221,
      0,
      1.937224,
      1.031797,
      NULL,
      1,
      1.682028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638476,
      2,
      2,
      3,
      3,
      0,
      0,
      3,
      2,
      1,
      2,
      5,
      8.076163,
      17.538696,
      3,
      1,
      1,
      4.299907,
      1,
      1.912015,
      3,
      1,
      NULL,
      NULL,
      1.787915,
      1.537864,
      NULL,
      1.320815,
      1.562563,
      0,
      NULL,
      NULL,
      NULL,
      2.766070,
      9.376497,
      0.287203,
      4.164499,
      NULL,
      NULL,
      1,
      3,
      1.850213,
      37,
      0,
      0,
      89,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.890445,
      '13441',
      '41331',
      '',
      0.080778,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2.317006,
      23,
      640.692299,
      31.780025,
      1.642882,
      18,
      NULL,
      10,
      2,
      2,
      1.920871,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      18.254752,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      15.705598,
      NULL,
      NULL,
      1.319793,
      NULL,
      NULL,
      0.803564,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      2,
      NULL,
      2.948434,
      1,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.502042,
      NULL,
      NULL,
      1.251620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.188260,
      NULL,
      NULL,
      0.440154,
      NULL,
      NULL,
      0.803119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428974,
      NULL,
      NULL,
      NULL,
      1.024000,
      0.184932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.377427,
      0.092172,
      3.008533,
      2,
      NULL,
      3,
      1,
      1,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.449440,
      NULL,
      NULL,
      0.243396,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.943184,
      NULL,
      NULL,
      1,
      5,
      1.140579,
      7.020894,
      0.804653,
      1,
      3.391013,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      17,
      NULL,
      NULL,
      4.263506,
      NULL,
      0.153174,
      1.729978,
      NULL,
      NULL,
      1.031890,
      NULL,
      NULL,
      1.082497,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      2,
      0.709442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617125,
      NULL,
      NULL,
      1.728387,
      NULL,
      NULL,
      1.677876,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      14.542825,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      2.057599,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.210640,
      NULL,
      NULL,
      3.004742,
      NULL,
      NULL,
      2.175452,
      NULL,
      1,
      1,
      0,
      0.047178,
      1,
      0.909324,
      3.348579,
      NULL,
      NULL,
      NULL,
      1.496283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.764947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.904130,
      1,
      NULL,
      NULL,
      1.834265,
      0,
      NULL,
      NULL,
      1,
      1.670181,
      NULL,
      NULL,
      1,
      0.649854,
      NULL,
      NULL,
      1.648532,
      0,
      NULL,
      NULL,
      2.223400,
      NULL,
      NULL,
      NULL,
      0.849468,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126753,
      989,
      1346,
      0.477517,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.763074,
      NULL,
      NULL,
      1.273901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.169845,
      0,
      13702,
      1861,
      0,
      1.239004,
      1.596970,
      0,
      0,
      0.204913,
      0,
      1.401764,
      0,
      1,
      0,
      1,
      NULL,
      2.471385,
      0,
      0,
      1.714621,
      NULL,
      NULL,
      2.439028,
      NULL,
      0.012093,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.805023,
      NULL,
      441.861144,
      NULL,
      1.361919,
      29,
      67,
      1,
      1.949570,
      3.018609,
      NULL,
      2.580706,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.652840,
      NULL,
      0,
      NULL,
      1.201738,
      NULL,
      2.600934,
      NULL,
      0.809120,
      NULL,
      3.677281,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.446840,
      1.172604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      8,
      1,
      3,
      NULL,
      3,
      7.260373,
      0.836154,
      NULL,
      NULL,
      0,
      1.609001,
      0.394330,
      0.612757,
      0.904767,
      1,
      0.821119,
      3.113023,
      1,
      1.935589,
      0,
      0,
      0.891033,
      1,
      0.400635,
      0.274562,
      3.238717,
      2,
      0,
      1.933194,
      0,
      0,
      0.877362,
      1,
      1,
      0.471646,
      1,
      1.214027,
      1.116151,
      0.276895,
      NULL,
      0.019951,
      0.518218,
      2,
      NULL,
      3,
      1,
      3.988943,
      9,
      15,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.328627,
      1,
      0,
      0.190591,
      0,
      1.894344,
      0,
      1,
      1,
      0.509329,
      0.583189,
      2.594257,
      0,
      0,
      0.376158,
      1,
      60.144998,
      1.180768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.929264,
      NULL,
      1,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      94.527039,
      0,
      1.948013,
      4,
      '30013',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


