set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8721162';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      6.610394,
      NULL,
      2.963291,
      8.539082,
      6.669199,
      0,
      0,
      1,
      '442',
      NULL,
      43,
      23.383925,
      '1431334',
      1,
      NULL,
      NULL,
      3,
      '4303',
      5.159374,
      0.088940,
      NULL,
      NULL,
      NULL,
      9.287275,
      13,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 5- 3-1999',
      ' 4- 9-1992',
      2.845166,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      2.555160,
      4,
      14.433800,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      0,
      1,
      1.208126,
      1.705939,
      0.627452,
      0.198951,
      NULL,
      1,
      0,
      1.094062,
      2,
      2,
      3,
      3.460936,
      4,
      0,
      2,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      5.522103,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.470176,
      2.340942,
      2.249247,
      1.745895,
      3.103128,
      NULL,
      0.969248,
      NULL,
      1,
      1,
      NULL,
      0,
      0.428631,
      NULL,
      3.498320,
      3.411355,
      3,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.670319,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      3,
      1,
      3,
      1,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1.687831,
      NULL,
      1.007089,
      NULL,
      NULL,
      0,
      NULL,
      2,
      4,
      0,
      5,
      NULL,
      NULL,
      0,
      1,
      5,
      1,
      0,
      NULL,
      2,
      5,
      NULL,
      4,
      0,
      NULL,
      5,
      0,
      1,
      2,
      NULL,
      ' 4-13-2001',
      178,
      ' 7-14-1992',
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      9.903735,
      3,
      1.518699,
      NULL,
      0.037330,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.758813,
      1.071963,
      2.872629,
      3,
      1,
      1.137923,
      NULL,
      1,
      2,
      2.279214,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1.715398,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325079,
      NULL,
      0,
      0,
      1,
      0.690222,
      1.400323,
      1,
      28,
      1.169842,
      1.719554,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      3,
      0,
      3,
      2,
      1,
      NULL,
      2,
      NULL,
      0,
      0.842962,
      1.448947,
      2.096841,
      0.885407,
      1.596756,
      0.603892,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0.455287,
      NULL,
      2.499129,
      5.073802,
      1.564431,
      NULL,
      1.559922,
      NULL,
      NULL,
      NULL,
      2.397400,
      1,
      3,
      NULL,
      2,
      0,
      36,
      NULL,
      NULL,
      2.599797,
      2,
      3,
      0.574657,
      '21033',
      '40030',
      '',
      NULL,
      '30414',
      '',
      '',
      0.953317,
      '',
      '',
      '',
      2.722570,
      28,
      NULL,
      13.390365,
      3,
      NULL,
      3,
      3.521047,
      4,
      3.922626,
      0.839937,
      2.636033,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.647246,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.034751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.625534,
      0,
      1.269852,
      NULL,
      NULL,
      NULL,
      9.002373,
      NULL,
      7,
      3,
      1.968217,
      NULL,
      NULL,
      NULL,
      1.082341,
      NULL,
      NULL,
      NULL,
      0.599815,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.755054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.659053,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.633677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.238050,
      1.485472,
      0,
      NULL,
      1.404908,
      NULL,
      1,
      NULL,
      NULL,
      6,
      8,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.093513,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.043904,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.390598,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.322894,
      0.196932,
      0,
      1.048011,
      3,
      2,
      NULL,
      6.272083,
      0,
      4,
      5.182706,
      0,
      1.449377,
      NULL,
      NULL,
      1,
      2.433689,
      NULL,
      1.980219,
      NULL,
      1,
      0.074131,
      1,
      2,
      NULL,
      0,
      6,
      3,
      3,
      0.501321,
      3.167497,
      1.164251,
      NULL,
      0.497004,
      3,
      1.046732,
      3,
      3.405349,
      0,
      NULL,
      6.465554,
      4,
      2.984248,
      0.374594,
      4.167587,
      3.832741,
      NULL,
      NULL,
      NULL,
      1.439201,
      1,
      0.433040,
      0.642959,
      2,
      NULL,
      NULL,
      1.502523,
      NULL,
      NULL,
      17.035129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.584231,
      NULL,
      NULL,
      0.734659,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.499796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.843411,
      NULL,
      NULL,
      0,
      1.181217,
      1,
      0.320823,
      1.929810,
      2.750508,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.694361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.622383,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.687852,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.633041,
      NULL,
      NULL,
      NULL,
      0.090738,
      NULL,
      NULL,
      NULL,
      2.601560,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.585088,
      NULL,
      NULL,
      NULL,
      7.597695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.840408,
      NULL,
      NULL,
      0.443534,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.427369,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      97.316058,
      4,
      0,
      0.518986,
      2,
      NULL,
      1.516377,
      1,
      NULL,
      NULL,
      1.415436,
      1,
      1.345307,
      NULL,
      1,
      1,
      0.696128,
      0,
      2.270988,
      1.593484,
      1.375317,
      NULL,
      0,
      NULL,
      0.274150,
      NULL,
      0.512930,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.048828,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.773924,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.426119,
      NULL,
      0,
      NULL,
      0.094877,
      NULL,
      1.867669,
      NULL,
      1.240757,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.989944,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449525,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044403,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      196,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.754685,
      NULL,
      0.560591,
      NULL,
      0.136405,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522374,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883555,
      1,
      1.155276,
      NULL,
      NULL,
      NULL,
      276.596945,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.360032,
      NULL,
      NULL,
      1.393835,
      31,
      NULL,
      1.887053,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      2.137642,
      0,
      0.474580,
      1,
      5,
      1.733684,
      2.572895,
      1,
      1.329526,
      NULL,
      NULL,
      0.456614,
      2.457587,
      NULL,
      0.702898,
      2,
      NULL,
      0.061460,
      1.634955,
      NULL,
      0,
      NULL,
      NULL,
      1.269825,
      1.122702,
      NULL,
      1.664429,
      1.160100,
      NULL,
      0.186201,
      1.578507,
      NULL,
      0.957650,
      NULL,
      NULL,
      0.872579,
      0.451078,
      NULL,
      0.033259,
      3.501739,
      NULL,
      0.478171,
      1,
      1.198255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.588066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.201029,
      NULL,
      0,
      NULL,
      1.874338,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.651242,
      3.798575,
      '10221',
      '24314',
      '',
      3.144492,
      '13042',
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


