set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5112208';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      '4100',
      1.103012,
      0,
      NULL,
      NULL,
      ' 7-28-1988',
      NULL,
      NULL,
      NULL,
      1.391918,
      NULL,
      NULL,
      55.699704,
      3.939320,
      162,
      125.232594,
      2,
      ' 1-12-1980',
      NULL,
      ' 2-10-1984',
      NULL,
      0,
      2,
      2,
      1,
      2.693679,
      1,
      1.659822,
      0,
      6.573494,
      5,
      1,
      5.240468,
      30,
      NULL,
      4,
      20,
      2,
      NULL,
      1.711766,
      1.282348,
      0,
      NULL,
      2.114582,
      3,
      1,
      1,
      0,
      0.154867,
      0.898262,
      0,
      NULL,
      1,
      2,
      2.121459,
      4,
      2,
      2,
      0,
      1,
      3,
      5,
      0,
      NULL,
      0,
      NULL,
      0,
      5.869586,
      NULL,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.922351,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      2,
      4,
      1,
      NULL,
      0,
      0.473084,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0.566088,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      3,
      0,
      0,
      0.325004,
      0,
      ' 0-13-1985',
      60,
      ' 1- 3-1986',
      NULL,
      0.849411,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      77.653047,
      0,
      0.698643,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.798187,
      1,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.482861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.371780,
      0,
      NULL,
      0.678681,
      0,
      1,
      NULL,
      217.915082,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.258940,
      NULL,
      0,
      2,
      2,
      NULL,
      2,
      NULL,
      2,
      2,
      NULL,
      1,
      2,
      3.572294,
      3.399357,
      2.613063,
      0,
      0.974830,
      NULL,
      2.178240,
      1,
      1.711000,
      0,
      0,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4.581392,
      7.617362,
      2.487277,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      2.576302,
      NULL,
      3,
      1.915220,
      NULL,
      52,
      60,
      52.732099,
      0,
      0.362161,
      NULL,
      '11020',
      '',
      '',
      1.747017,
      '42212',
      '',
      '',
      NULL,
      '10233',
      NULL,
      NULL,
      0,
      13.669021,
      NULL,
      20.403987,
      3.146357,
      48.485551,
      NULL,
      2.637614,
      3,
      2.050736,
      0,
      3,
      NULL,
      1,
      NULL,
      1.791362,
      0.977937,
      1.615501,
      3.296675,
      2,
      2,
      1,
      NULL,
      NULL,
      2,
      2,
      0.598477,
      2.083744,
      1,
      NULL,
      1.145738,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.265654,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.776758,
      0,
      1.222350,
      NULL,
      NULL,
      NULL,
      2,
      0.399394,
      1,
      NULL,
      0.317054,
      1.084562,
      0,
      0.653500,
      NULL,
      NULL,
      1.396660,
      NULL,
      NULL,
      2.750711,
      1.732184,
      1.332189,
      0.382055,
      NULL,
      1,
      0,
      1.666820,
      0,
      1,
      0.607680,
      1,
      0,
      0.366680,
      1.323074,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.548668,
      NULL,
      3.089864,
      4.550349,
      0,
      1,
      0.886595,
      NULL,
      NULL,
      NULL,
      0.270232,
      2.456505,
      1,
      1,
      1.093891,
      NULL,
      NULL,
      3.116306,
      1.105114,
      1.160084,
      1.422307,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.990392,
      0,
      1.330308,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      4,
      NULL,
      0.401789,
      0,
      NULL,
      NULL,
      1.563109,
      NULL,
      NULL,
      0.707905,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.311409,
      NULL,
      NULL,
      0.964693,
      NULL,
      NULL,
      0.031312,
      NULL,
      NULL,
      0.027724,
      8.234850,
      1.744508,
      5.657318,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.492803,
      1.176573,
      1.288738,
      1.006353,
      0,
      2,
      6,
      1.367563,
      0,
      NULL,
      NULL,
      3.055795,
      1.525975,
      0,
      NULL,
      1.686283,
      0,
      NULL,
      1.108388,
      NULL,
      5,
      3,
      3.765035,
      3,
      NULL,
      0.679571,
      1.399277,
      2,
      3,
      NULL,
      0.110156,
      0.763378,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357506,
      NULL,
      NULL,
      0.924460,
      NULL,
      NULL,
      0.269254,
      NULL,
      NULL,
      0.997109,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      0,
      0.225326,
      1.448003,
      2.076013,
      2,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      0.098504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3.217182,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.516058,
      0,
      NULL,
      NULL,
      1.645161,
      1.911746,
      NULL,
      NULL,
      1.612037,
      3,
      NULL,
      NULL,
      NULL,
      0.106246,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      11.199424,
      0,
      0,
      0.914526,
      0,
      0,
      NULL,
      NULL,
      3,
      8,
      2.087461,
      3,
      NULL,
      0.464842,
      1.285557,
      NULL,
      NULL,
      0.055930,
      NULL,
      1,
      NULL,
      0.070370,
      1,
      1.528885,
      NULL,
      0.699246,
      0.456822,
      1,
      NULL,
      1,
      1.469111,
      0,
      NULL,
      0,
      0,
      1.446935,
      0,
      0.127587,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      2,
      NULL,
      NULL,
      0.436361,
      1,
      5,
      3.319863,
      3,
      3.479305,
      NULL,
      0,
      NULL,
      0.833244,
      0.541654,
      1.351169,
      1.216115,
      0,
      1.316649,
      1.273119,
      0,
      NULL,
      NULL,
      0.605496,
      2.629952,
      1,
      0,
      0,
      NULL,
      1.138713,
      0.540448,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0.751896,
      3,
      1,
      NULL,
      1,
      3.099959,
      2.944033,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      2.552294,
      2,
      2.403725,
      0,
      1,
      3,
      NULL,
      0.252768,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      3.207499,
      NULL,
      NULL,
      1,
      1.089524,
      NULL,
      NULL,
      24.847431,
      1.851193,
      7,
      1.514315,
      1,
      0,
      1,
      1.793662,
      NULL,
      NULL,
      6,
      2,
      0,
      NULL,
      NULL,
      1,
      11,
      NULL,
      0.250796,
      0.358382,
      NULL,
      NULL,
      NULL,
      1,
      '11241',
      '',
      '',
      2.739226,
      '10202',
      '',
      '');
commit;
end;
/


