set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8929470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '1003433',
      2,
      0,
      3,
      1,
      '1300',
      3,
      NULL,
      NULL,
      NULL,
      '11- 4-1981',
      58,
      NULL,
      0,
      0.854405,
      1.870344,
      ' 9-16-1996',
      NULL,
      2.748952,
      174,
      186.222093,
      2,
      ' 2- 6-1986',
      ' 0- 8-1996',
      NULL,
      2,
      3.151997,
      3,
      NULL,
      1,
      NULL,
      3,
      1.311430,
      NULL,
      NULL,
      NULL,
      5.292429,
      NULL,
      18,
      NULL,
      2,
      30,
      2,
      0,
      3,
      0.484545,
      NULL,
      0,
      1.695089,
      0.117798,
      0.422566,
      1.487247,
      1,
      0,
      NULL,
      NULL,
      3,
      4,
      3,
      3.509861,
      4,
      0,
      0,
      1,
      0,
      1,
      3,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      2,
      1,
      NULL,
      0.649843,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.556681,
      0.594882,
      0,
      2.669807,
      3,
      1.096747,
      1,
      0.232329,
      NULL,
      NULL,
      2.545633,
      NULL,
      1.804277,
      0.039524,
      3,
      NULL,
      1,
      NULL,
      0,
      4.570002,
      0,
      0,
      1,
      0.151590,
      NULL,
      NULL,
      0.887828,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      5,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0.610879,
      1,
      0,
      1,
      5,
      5,
      NULL,
      4,
      1,
      0,
      5,
      0,
      0,
      1,
      NULL,
      4,
      1,
      0,
      3,
      0,
      0,
      0,
      3,
      2,
      1,
      1,
      2.097479,
      1.979642,
      ' 9-25-1994',
      NULL,
      NULL,
      5,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      1.369270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150167,
      NULL,
      3.373116,
      NULL,
      NULL,
      0.555263,
      1,
      NULL,
      1,
      0.885217,
      1.198353,
      1,
      NULL,
      1,
      0,
      3.873837,
      0.153435,
      NULL,
      NULL,
      NULL,
      1,
      4.810541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.089561,
      1.691576,
      0.235156,
      1.517339,
      NULL,
      0,
      0,
      27,
      0.472379,
      0.283412,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      NULL,
      3,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      3,
      2,
      3,
      0.153369,
      1.026822,
      1.657621,
      0,
      3,
      0.180892,
      NULL,
      1.951158,
      0,
      1.581151,
      NULL,
      NULL,
      1.305737,
      1,
      0.842750,
      1.846857,
      0,
      1,
      3,
      0,
      8,
      3,
      NULL,
      5,
      3.347335,
      5.456396,
      2.766323,
      1.543517,
      1.337682,
      31.839307,
      1,
      3,
      NULL,
      21,
      NULL,
      88.746317,
      1,
      NULL,
      NULL,
      '33433',
      '',
      '',
      1.851010,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      0,
      41.839898,
      389,
      14.921188,
      1,
      26,
      8.093323,
      0.128848,
      3,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.499486,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.227401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.880827,
      1,
      0,
      NULL,
      NULL,
      1.205498,
      0,
      NULL,
      0.655153,
      NULL,
      NULL,
      1.381661,
      NULL,
      NULL,
      1.160639,
      NULL,
      NULL,
      NULL,
      8,
      0.049022,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.595242,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0.051117,
      1.488999,
      NULL,
      0.048249,
      3,
      1.923601,
      2.146735,
      0.693105,
      2.932274,
      NULL,
      3.970275,
      1,
      1,
      1.460248,
      NULL,
      NULL,
      1.159098,
      NULL,
      NULL,
      5.756069,
      4,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.052245,
      3.334478,
      0,
      NULL,
      NULL,
      1.364614,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      2,
      1,
      0.855327,
      1.159825,
      NULL,
      NULL,
      1.354851,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.684936,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.694206,
      NULL,
      NULL,
      1.090466,
      NULL,
      NULL,
      2.817531,
      3,
      1.292282,
      1,
      5.073818,
      0.011185,
      0.980473,
      0.438217,
      0.858042,
      1.596643,
      NULL,
      NULL,
      1,
      1.747992,
      0.093397,
      3.969486,
      2,
      0.799923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3.425626,
      NULL,
      1.914180,
      NULL,
      1,
      0,
      1.781591,
      1,
      2.101417,
      1,
      1.135277,
      2.253508,
      7,
      NULL,
      1,
      1.015983,
      3,
      0,
      0,
      3,
      0.532084,
      1.592121,
      0,
      NULL,
      1,
      2.592146,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.324295,
      NULL,
      1,
      1.542984,
      0,
      2.386016,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.131314,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174448,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0.172620,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1.061353,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.059836,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      5,
      NULL,
      NULL,
      0.831937,
      NULL,
      NULL,
      NULL,
      NULL,
      220.540271,
      44.669645,
      3.256484,
      18.489566,
      3,
      0.545286,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.004947,
      NULL,
      NULL,
      0.193708,
      NULL,
      1.111945,
      420,
      NULL,
      NULL,
      1,
      0.507587,
      0,
      NULL,
      1.223479,
      0,
      0.464380,
      0.510273,
      1,
      NULL,
      NULL,
      0.858709,
      1,
      NULL,
      NULL,
      0.656903,
      0.682781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.335183,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.912841,
      1.898022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.100005,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.456880,
      NULL,
      0.923650,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432447,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.366425,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.220261,
      NULL,
      1.043586,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.508411,
      1.614759,
      2,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0.466248,
      1.204830,
      NULL,
      0.656156,
      1.818395,
      1,
      1.136442,
      1.478992,
      NULL,
      0,
      1,
      1.190867,
      0.769493,
      1,
      1,
      1,
      0,
      1.170303,
      NULL,
      1.208984,
      0,
      1,
      0.494747,
      0.505048,
      NULL,
      1.424402,
      3,
      NULL,
      NULL,
      NULL,
      0.170357,
      2.689273,
      NULL,
      1.463565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      2,
      3,
      1,
      1.523431,
      0,
      50.547838,
      68.625058,
      5,
      0.829008,
      1,
      '43233',
      '',
      NULL,
      0.892745,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


