set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6404872';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '2011411',
      2,
      1,
      3,
      1,
      '0001',
      2,
      1.966765,
      NULL,
      NULL,
      ' 3-15-2001',
      NULL,
      NULL,
      4,
      3.958032,
      0.765435,
      NULL,
      99.338770,
      NULL,
      128,
      19,
      0,
      ' 3-24-1976',
      ' 5-19-1981',
      '10-23-1992',
      2.775188,
      0.557516,
      0,
      0.187353,
      NULL,
      1.885665,
      5,
      3.883739,
      NULL,
      NULL,
      NULL,
      5,
      5,
      NULL,
      2,
      0,
      17,
      5,
      2,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      2,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0.731111,
      0.679554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.606502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      4,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0.962673,
      NULL,
      NULL,
      3,
      1,
      0,
      3,
      2,
      0,
      NULL,
      2,
      1,
      0,
      NULL,
      2,
      0,
      0,
      3,
      5,
      5,
      0,
      0,
      4,
      2,
      5,
      NULL,
      3,
      1,
      1.260263,
      NULL,
      ' 3-14-1997',
      644,
      ' 3- 3-1995',
      1548.185536,
      3.523698,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      0.134024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      1.595093,
      NULL,
      1,
      3,
      1,
      2,
      1,
      3.379567,
      NULL,
      NULL,
      0,
      4.275991,
      NULL,
      2,
      2.481134,
      7,
      0,
      0.954313,
      0.489497,
      NULL,
      NULL,
      0.244231,
      1.625933,
      0,
      1,
      4,
      3,
      1.305245,
      ' 4- 0-1992',
      263.685148,
      ' 6-22-1997',
      33.757805,
      NULL,
      0,
      1,
      2.941884,
      3.650564,
      0,
      0,
      NULL,
      0.120546,
      0,
      NULL,
      NULL,
      3.593932,
      0.319138,
      NULL,
      NULL,
      NULL,
      2,
      0.283661,
      3.887963,
      1,
      0,
      1,
      0,
      0,
      2,
      1,
      0,
      2,
      3,
      2,
      1,
      3.538901,
      NULL,
      0,
      1,
      NULL,
      0,
      0.330467,
      3.541066,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      0.840736,
      3,
      5,
      2.229802,
      2.006488,
      10,
      NULL,
      2.561137,
      2,
      3,
      3.729646,
      3,
      3.393881,
      12,
      3,
      0,
      NULL,
      NULL,
      19,
      45.252379,
      4,
      0.584601,
      1.552127,
      '20300',
      '',
      '',
      1.118435,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.375936,
      5.990433,
      803.748520,
      NULL,
      2,
      41,
      10,
      NULL,
      5,
      2.560962,
      1.155257,
      NULL,
      3.510946,
      0.285207,
      0.067354,
      NULL,
      0.674301,
      NULL,
      NULL,
      0.219434,
      1.533402,
      0.770595,
      NULL,
      NULL,
      2.641924,
      1.088568,
      3.388792,
      0.317685,
      NULL,
      NULL,
      0.341464,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.761671,
      NULL,
      NULL,
      1.254031,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.436866,
      4,
      1.579846,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.372961,
      3.092819,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.545758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.809488,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.379555,
      5.023624,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.949219,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      3.002983,
      3,
      2,
      NULL,
      2.410194,
      NULL,
      7,
      6,
      0,
      1,
      3,
      0.443535,
      NULL,
      NULL,
      0.697957,
      1.854166,
      0,
      0,
      NULL,
      NULL,
      0.016348,
      NULL,
      NULL,
      0.974101,
      NULL,
      NULL,
      1.281511,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.843627,
      3.837469,
      1,
      NULL,
      NULL,
      NULL,
      3.623237,
      5,
      3,
      2,
      0.324833,
      5,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      3,
      NULL,
      1.658127,
      2.867525,
      NULL,
      NULL,
      2.533101,
      7,
      2,
      3.624181,
      0.328003,
      NULL,
      1,
      1.435107,
      NULL,
      0.967519,
      2.410571,
      0,
      0,
      1.618584,
      NULL,
      4,
      NULL,
      0.148411,
      NULL,
      NULL,
      1.735388,
      3,
      NULL,
      0,
      1,
      0,
      1.786791,
      NULL,
      0.379585,
      NULL,
      NULL,
      0.010916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.986207,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121894,
      NULL,
      NULL,
      2,
      NULL,
      0.608703,
      1.007008,
      2,
      1,
      1,
      NULL,
      0.318423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.093396,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.160872,
      NULL,
      NULL,
      NULL,
      1.890368,
      2.806999,
      NULL,
      NULL,
      0,
      0.496282,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.498281,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.341077,
      1.432420,
      NULL,
      NULL,
      1,
      0.986731,
      NULL,
      NULL,
      NULL,
      1.239055,
      NULL,
      NULL,
      3.374901,
      NULL,
      NULL,
      NULL,
      NULL,
      2.200421,
      NULL,
      NULL,
      7.956884,
      1,
      NULL,
      NULL,
      NULL,
      2.640415,
      440,
      157,
      0.556284,
      297,
      156.996410,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.762558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      93,
      146.072873,
      NULL,
      1.319708,
      1,
      1,
      NULL,
      0.173294,
      1,
      1,
      1,
      1,
      1,
      1,
      0.419598,
      0.577644,
      1.945547,
      0.168764,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      2.712817,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0.591510,
      NULL,
      0.721571,
      NULL,
      NULL,
      0.882908,
      0.604233,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0.775474,
      NULL,
      0,
      2,
      NULL,
      1.736461,
      0,
      NULL,
      1,
      0.529674,
      NULL,
      0.503677,
      0.451766,
      NULL,
      0.287506,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.902445,
      NULL,
      1.796585,
      NULL,
      NULL,
      2,
      4,
      NULL,
      0.781245,
      1,
      44,
      10,
      4,
      NULL,
      3,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.853365,
      '',
      '',
      '');
commit;
end;
/


