set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3374023';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.769293,
      NULL,
      0,
      NULL,
      NULL,
      0.698231,
      2,
      1.136923,
      '334',
      '10220103',
      84,
      32.262077,
      '4324132',
      3.489789,
      0.579134,
      0,
      0,
      '4030',
      0.548576,
      0,
      NULL,
      NULL,
      ' 6-16-2003',
      1.897373,
      39.220208,
      NULL,
      2.251259,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 2-1984',
      NULL,
      0.510399,
      1,
      NULL,
      NULL,
      3.051868,
      2,
      2,
      NULL,
      NULL,
      NULL,
      7.405019,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.018116,
      1.209819,
      NULL,
      NULL,
      1.770933,
      0,
      0.471172,
      0,
      2,
      NULL,
      NULL,
      1,
      0,
      1,
      4,
      0,
      3,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      0.373888,
      2,
      0,
      NULL,
      1,
      0.079979,
      1,
      1,
      NULL,
      1.314307,
      1.980488,
      2.082813,
      0,
      0.061656,
      NULL,
      3.082809,
      2.675842,
      2.797400,
      1.971900,
      2.643928,
      1,
      1.667577,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0.086436,
      1.598982,
      NULL,
      NULL,
      2.441533,
      1,
      1,
      NULL,
      1,
      NULL,
      3,
      4,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1.184533,
      0,
      0,
      0,
      0,
      0,
      0,
      2,
      0,
      0,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      5,
      0,
      4,
      5,
      3,
      5,
      0,
      2,
      4,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1.597250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6.051659,
      1.954797,
      0.916648,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.674444,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.382652,
      1,
      NULL,
      6.138123,
      5.509436,
      4.835225,
      1.587294,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      2,
      5.700688,
      '11- 9-1992',
      NULL,
      ' 1-17-1996',
      385,
      3,
      1,
      3,
      NULL,
      0.911762,
      1,
      1,
      1,
      0.020708,
      0,
      1,
      NULL,
      2.047242,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.456792,
      0.192015,
      NULL,
      0,
      0,
      2,
      1,
      1,
      0,
      3,
      2,
      3,
      3,
      1.225790,
      2.881141,
      1,
      1.347848,
      0,
      1,
      0.338473,
      0,
      1,
      1.143257,
      0.180536,
      0,
      NULL,
      1.470710,
      NULL,
      1,
      NULL,
      0.258109,
      1.598959,
      2.037442,
      7.904912,
      0.140642,
      7,
      0,
      5.140007,
      1.424691,
      5,
      NULL,
      0.411282,
      3.016208,
      NULL,
      1,
      1.929675,
      41,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.074139,
      '11333',
      '42021',
      '23314',
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      13.147741,
      76.907342,
      22.968888,
      0.191918,
      NULL,
      1,
      1,
      3,
      0.730223,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.363196,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.065834,
      1.369073,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.071795,
      NULL,
      NULL,
      1.459660,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.854553,
      1,
      0.775400,
      0.821906,
      NULL,
      0.965698,
      1.098217,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.308473,
      0.522316,
      1,
      0,
      1.047334,
      1,
      0,
      2.420928,
      0.183755,
      3,
      3,
      1.647374,
      1.384936,
      NULL,
      1,
      0.456185,
      2,
      3.439954,
      1.300969,
      NULL,
      NULL,
      NULL,
      2,
      1.213257,
      1.020775,
      NULL,
      4.977993,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.286913,
      3.065883,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.395731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.697922,
      1,
      NULL,
      NULL,
      1.085812,
      NULL,
      NULL,
      1.910789,
      NULL,
      NULL,
      0.566295,
      NULL,
      NULL,
      0.900565,
      NULL,
      NULL,
      0.165692,
      NULL,
      NULL,
      1.637624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.999310,
      NULL,
      0.097552,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.958139,
      NULL,
      2.628576,
      1.137076,
      NULL,
      0.190182,
      0.749185,
      2.536820,
      4,
      2,
      2.840887,
      0,
      0,
      2,
      NULL,
      NULL,
      2.022785,
      NULL,
      3.080832,
      0.752800,
      NULL,
      NULL,
      NULL,
      3.709129,
      NULL,
      3.978510,
      4,
      1.534978,
      NULL,
      NULL,
      0.628345,
      NULL,
      1,
      0.412751,
      0.835019,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863019,
      3,
      3,
      0,
      NULL,
      NULL,
      1.978040,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.399622,
      NULL,
      NULL,
      NULL,
      3.110677,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.520474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.884682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      0.685963,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.445364,
      NULL,
      NULL,
      0.078421,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068957,
      NULL,
      1,
      1.710366,
      0.773008,
      1.555876,
      0,
      0.740378,
      1,
      0,
      0,
      1,
      NULL,
      1.942779,
      1.313296,
      0.514780,
      0.739636,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      7.605612,
      2,
      2,
      3,
      2,
      11,
      2.182272,
      3.684213,
      NULL,
      0,
      1.023189,
      NULL,
      1.913257,
      1,
      NULL,
      NULL,
      1.895063,
      NULL,
      0.012280,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.361363,
      1,
      NULL,
      1.504405,
      0,
      NULL,
      1.520810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565387,
      0,
      NULL,
      1,
      1.196154,
      NULL,
      2,
      0.879596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302455,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      0.798693,
      NULL,
      NULL,
      51.549499,
      31,
      5,
      0.424712,
      4,
      '13424',
      NULL,
      '30040',
      0.472686,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


