set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9657548';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      '42',
      NULL,
      5,
      '4021240',
      NULL,
      0,
      3,
      NULL,
      '0444',
      0,
      0.684830,
      NULL,
      NULL,
      ' 0- 4-1993',
      17.445606,
      5.543441,
      NULL,
      NULL,
      0.967238,
      ' 2-20-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 4-27-1982',
      NULL,
      ' 6- 5-1982',
      2.855221,
      1.715328,
      3,
      2,
      1,
      1.727858,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.976026,
      9.131350,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      2.705489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      7,
      0,
      4,
      1,
      0,
      NULL,
      4,
      5,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      6.346170,
      0,
      0,
      NULL,
      1,
      3.719273,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.470541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      1.798110,
      1,
      0,
      1,
      1.332484,
      0.537033,
      3.774483,
      1.825109,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      1,
      2,
      0,
      NULL,
      4,
      4,
      0,
      NULL,
      0,
      5,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      5,
      0,
      0,
      0,
      0,
      1,
      NULL,
      3,
      1,
      4,
      1,
      2,
      2,
      3,
      NULL,
      2,
      NULL,
      NULL,
      5,
      3.461805,
      1,
      '11-15-1976',
      204.417724,
      ' 6-12-1992',
      2,
      NULL,
      NULL,
      1,
      NULL,
      5,
      NULL,
      2,
      3,
      0,
      NULL,
      5,
      0,
      3,
      4,
      1,
      4,
      4,
      5,
      NULL,
      8,
      1.515260,
      '11-22-1997',
      2,
      ' 6- 8-1995',
      5,
      3.804993,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.589931,
      0,
      3,
      1,
      NULL,
      5,
      1,
      5.086547,
      1,
      1.515055,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.534357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.827773,
      1.543172,
      0,
      0,
      0,
      1.834626,
      0,
      0,
      NULL,
      3.709709,
      0.200331,
      NULL,
      NULL,
      NULL,
      3,
      0.294572,
      0,
      3,
      3,
      3,
      3,
      2,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      5.921890,
      1.732194,
      NULL,
      NULL,
      0.806054,
      1,
      1,
      0.815096,
      1,
      0,
      1,
      1.410306,
      0,
      NULL,
      3.443312,
      NULL,
      0,
      1.491785,
      1,
      4.936695,
      3,
      5.370212,
      7.859295,
      4,
      3.842285,
      NULL,
      1,
      NULL,
      3.383684,
      3,
      3,
      3.086705,
      3,
      NULL,
      39,
      50,
      NULL,
      NULL,
      2.683520,
      '13033',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      1.367600,
      '',
      '',
      '',
      0,
      20,
      29,
      NULL,
      0,
      33,
      0.957877,
      7,
      1,
      1,
      1,
      NULL,
      0.626533,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      3.433134,
      NULL,
      0.955770,
      2.707226,
      1,
      0,
      2.715673,
      2.430761,
      2.628594,
      2,
      NULL,
      0.043979,
      3,
      NULL,
      3,
      3,
      1.282623,
      0.964990,
      NULL,
      1.454929,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.187228,
      1,
      4.416331,
      NULL,
      1,
      NULL,
      3.642405,
      0,
      1.146112,
      NULL,
      NULL,
      NULL,
      0.129611,
      0,
      0.202680,
      NULL,
      NULL,
      NULL,
      0.077617,
      NULL,
      NULL,
      2.216515,
      NULL,
      0,
      0.851235,
      1,
      NULL,
      0.468730,
      2.284946,
      0.355007,
      1.959115,
      1.161284,
      1.201623,
      NULL,
      2.727072,
      1.346977,
      NULL,
      3,
      2,
      2,
      0,
      0.491931,
      1,
      0.069422,
      3.921226,
      1,
      3,
      0.649940,
      1.406848,
      0,
      3.723277,
      0.388974,
      1,
      1.992254,
      0,
      NULL,
      NULL,
      NULL,
      3.524786,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.599756,
      NULL,
      NULL,
      0.104114,
      3,
      1.997982,
      3,
      3.270889,
      3,
      NULL,
      NULL,
      3,
      0.006067,
      NULL,
      NULL,
      0.733431,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.874437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.269955,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.992558,
      0,
      2.687896,
      NULL,
      NULL,
      NULL,
      1,
      0.944191,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      3,
      1.552713,
      0.704777,
      2,
      3,
      0.772345,
      NULL,
      6.959170,
      NULL,
      4.167756,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0.800022,
      1,
      2,
      1,
      2.265438,
      1,
      NULL,
      0.892053,
      NULL,
      NULL,
      28.986244,
      27,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      1.729911,
      NULL,
      3,
      0.872397,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.412254,
      NULL,
      NULL,
      2.989503,
      NULL,
      2.125307,
      1.196215,
      NULL,
      1.149603,
      1,
      NULL,
      0,
      2.058902,
      NULL,
      5.806467,
      3,
      NULL,
      3.948883,
      0,
      NULL,
      0.295697,
      NULL,
      1.605509,
      3.521496,
      2.655951,
      NULL,
      NULL,
      1.808509,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.403912,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1.200790,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.962716,
      0.611543,
      NULL,
      NULL,
      0.484823,
      1.870399,
      NULL,
      NULL,
      2,
      1.447382,
      NULL,
      NULL,
      1.272424,
      NULL,
      NULL,
      NULL,
      0,
      0.930660,
      NULL,
      NULL,
      1.295652,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.925778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      0.200154,
      2.114794,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.014909,
      NULL,
      0.047541,
      1,
      5,
      4.176405,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.152081,
      NULL,
      22,
      1.550028,
      0.449302,
      0.097649,
      NULL,
      1.353316,
      0.362662,
      1,
      3.146857,
      NULL,
      0,
      NULL,
      1.786622,
      1,
      NULL,
      0.439309,
      0.155096,
      1.744208,
      NULL,
      NULL,
      1.276201,
      0.070896,
      NULL,
      0.347403,
      NULL,
      1,
      NULL,
      0.421327,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.808406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218028,
      1.650042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.970510,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.061434,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.935844,
      NULL,
      NULL,
      NULL,
      0.942695,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.511083,
      NULL,
      NULL,
      1.449713,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.223466,
      NULL,
      NULL,
      NULL,
      0.308145,
      1,
      2.202463,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.100941,
      NULL,
      2.981909,
      1,
      6,
      0,
      0,
      0.075544,
      1.233593,
      NULL,
      NULL,
      1,
      1,
      1,
      0.105555,
      2.156873,
      0.917663,
      0,
      1.814944,
      0.402499,
      1.393557,
      0.860642,
      NULL,
      0,
      2,
      2.476968,
      0.984044,
      0,
      2.929421,
      NULL,
      0.175849,
      NULL,
      0.920371,
      0.690522,
      2,
      1.401504,
      NULL,
      1.394153,
      0,
      1,
      1.481544,
      1.572713,
      3,
      NULL,
      NULL,
      3,
      0.155135,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      0,
      1.341394,
      0.623051,
      0.909761,
      1.149953,
      0.642427,
      1,
      1.821419,
      NULL,
      0.368084,
      1,
      0,
      2,
      1.797309,
      NULL,
      0,
      0.438158,
      7.127991,
      0.032094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.589447,
      1.255189,
      1,
      1.615710,
      0,
      NULL,
      1,
      0.959048,
      NULL,
      NULL,
      116.480964,
      61.058990,
      3,
      5,
      NULL,
      '22232',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.302399,
      '',
      '',
      '');
commit;
end;
/


