set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206296';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      0.829108,
      1.636002,
      1,
      1,
      '0400',
      3,
      1.679732,
      NULL,
      NULL,
      NULL,
      34,
      NULL,
      2,
      NULL,
      NULL,
      ' 8-29-1983',
      31,
      3.559012,
      153,
      123,
      NULL,
      ' 5- 9-1992',
      ' 2- 5-1981',
      NULL,
      3.593645,
      2,
      NULL,
      3.537584,
      NULL,
      1.881079,
      0,
      0.155291,
      0,
      8,
      4,
      18.417427,
      2.183942,
      6.731860,
      NULL,
      4,
      34,
      5,
      NULL,
      0,
      0,
      1,
      NULL,
      0.437688,
      NULL,
      0.768850,
      0,
      1,
      0,
      1,
      1,
      1,
      2,
      3,
      1,
      2,
      1,
      NULL,
      0,
      3,
      0,
      5,
      0,
      NULL,
      1,
      1,
      0,
      3.726845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.316561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      3,
      2,
      3,
      5,
      0,
      0,
      3,
      1,
      3,
      1,
      2,
      NULL,
      1,
      NULL,
      0,
      0.492464,
      NULL,
      0.549553,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      4,
      5,
      2,
      1,
      3,
      0,
      4,
      NULL,
      1,
      3,
      4,
      3,
      2,
      2,
      0,
      1.845896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1.046637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      336.185724,
      0,
      1.680312,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160231,
      1,
      0.879139,
      4.532725,
      4,
      2,
      2.535414,
      1,
      NULL,
      NULL,
      0.335869,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.790948,
      0,
      1,
      NULL,
      1,
      0,
      1.211165,
      NULL,
      19.402152,
      0.051839,
      0.701145,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      2,
      2,
      2,
      3,
      2,
      2,
      NULL,
      NULL,
      1,
      1.890092,
      6.770310,
      NULL,
      NULL,
      3,
      1,
      0.090131,
      1,
      1,
      1.622988,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0.601357,
      7,
      6.340625,
      2.671107,
      NULL,
      11,
      3,
      NULL,
      3,
      5.273703,
      1,
      3,
      0.372088,
      22.513351,
      3,
      1.210667,
      NULL,
      29,
      13,
      48.766329,
      2,
      0.990225,
      1,
      '',
      '',
      '',
      1,
      '40342',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      35,
      79,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.791997,
      NULL,
      NULL,
      0.751724,
      0.868652,
      0,
      NULL,
      NULL,
      NULL,
      1.860996,
      3,
      NULL,
      0.967323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.930883,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.439158,
      1.202481,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896467,
      NULL,
      NULL,
      0.073432,
      NULL,
      NULL,
      1.853338,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.853244,
      NULL,
      NULL,
      1.012686,
      NULL,
      NULL,
      0.302575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.915474,
      0.696108,
      1.780936,
      NULL,
      NULL,
      0.370356,
      2,
      0.588762,
      5,
      2.306451,
      2.941366,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.360599,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.325604,
      1,
      NULL,
      NULL,
      1.757985,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      2,
      5.826115,
      3.772697,
      2.211759,
      3.939988,
      2,
      1.953280,
      1.734564,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.267187,
      0.474518,
      4.086031,
      7,
      1,
      0.167867,
      2,
      NULL,
      1,
      4,
      4,
      1.047467,
      NULL,
      0.041999,
      0.611088,
      0.428243,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.306284,
      NULL,
      NULL,
      3.886920,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      1,
      1.092666,
      NULL,
      NULL,
      2,
      2.159681,
      NULL,
      NULL,
      4.758775,
      285.325283,
      NULL,
      NULL,
      1,
      0.510671,
      NULL,
      NULL,
      3,
      1.663250,
      NULL,
      NULL,
      1.742892,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719755,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.505969,
      NULL,
      NULL,
      0.175236,
      0,
      NULL,
      NULL,
      1.800259,
      3.266168,
      NULL,
      NULL,
      0,
      1.031615,
      NULL,
      NULL,
      0.078029,
      1.550500,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.405957,
      NULL,
      NULL,
      NULL,
      5.861838,
      2,
      NULL,
      NULL,
      0.026972,
      NULL,
      NULL,
      NULL,
      0,
      20,
      NULL,
      2,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073617,
      1.481095,
      NULL,
      NULL,
      NULL,
      0.022670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      735.785297,
      2.048906,
      0.405028,
      0.664182,
      NULL,
      0,
      0,
      0,
      0.068623,
      NULL,
      NULL,
      1,
      0.642497,
      0,
      0.970050,
      NULL,
      1,
      0,
      1,
      1.629206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421003,
      1.046707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.687652,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.722284,
      0.460869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.411302,
      NULL,
      0,
      NULL,
      1.129234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536467,
      NULL,
      1,
      0,
      0.059612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.659080,
      3,
      2.574753,
      1,
      7.120194,
      2,
      0.347166,
      0.661877,
      NULL,
      2,
      1.887168,
      1,
      3.633891,
      0.318627,
      0.944232,
      2.262794,
      1,
      0,
      NULL,
      0.537370,
      NULL,
      3.077788,
      0,
      0.186133,
      1.457206,
      3,
      2.219594,
      1,
      3.800943,
      2.354252,
      1.373339,
      3,
      1,
      NULL,
      0,
      0.428380,
      1,
      0.055647,
      NULL,
      1.512597,
      0,
      NULL,
      0,
      1.636925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      0.895190,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.783037,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      5,
      0.042513,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      5,
      7,
      1.489074,
      1.185000,
      NULL,
      79,
      123.150122,
      0,
      0,
      0,
      '',
      '',
      '',
      2.614325,
      '22130',
      '',
      NULL,
      1.137754,
      '',
      '',
      '');
commit;
end;
/


