set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5615804';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '1113224',
      1.667992,
      1,
      2,
      0,
      '1204',
      1.942892,
      1.475128,
      NULL,
      NULL,
      ' 5-16-1990',
      NULL,
      NULL,
      4,
      1,
      0.495149,
      ' 6-17-1976',
      22.848739,
      0,
      145.442216,
      NULL,
      3,
      ' 4- 7-1977',
      ' 2-10-1986',
      ' 9- 4-1986',
      0,
      NULL,
      0,
      3.367268,
      NULL,
      3,
      2,
      0,
      1,
      10,
      6,
      NULL,
      3,
      NULL,
      9.462956,
      1,
      16,
      0,
      1,
      7.696534,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.980192,
      4,
      0,
      4,
      4,
      3,
      2,
      NULL,
      1,
      0,
      0,
      1,
      0,
      3.379768,
      0,
      1,
      1,
      1,
      0.065611,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      1,
      0.842132,
      0.092494,
      0,
      2,
      0.429241,
      1,
      1.339750,
      0,
      0,
      1.159573,
      1.565532,
      1,
      0.570651,
      0,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1.397904,
      NULL,
      NULL,
      1.503460,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      5,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0.998991,
      NULL,
      1.140986,
      2,
      3,
      1,
      0,
      0,
      1,
      1,
      1,
      4,
      0,
      2,
      1,
      0,
      1,
      0,
      2,
      4,
      5,
      5,
      5,
      4,
      2,
      0,
      1,
      NULL,
      6,
      NULL,
      ' 1- 4-1986',
      961.615173,
      ' 5-13-1981',
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      21.606202,
      3,
      2,
      2,
      0.332842,
      1,
      2.190482,
      0,
      16,
      NULL,
      1.843827,
      2.202860,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      4,
      0,
      NULL,
      NULL,
      3,
      1.018033,
      2,
      NULL,
      2,
      NULL,
      0.659467,
      ' 8-28-2000',
      13,
      ' 8-19-1978',
      6.958898,
      1.414426,
      NULL,
      1,
      3.511038,
      1.516881,
      1.911958,
      1,
      NULL,
      0.539466,
      1,
      3.387983,
      21,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.123301,
      0,
      2,
      1,
      3,
      3,
      1,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      3,
      5.954629,
      NULL,
      2.087726,
      0,
      NULL,
      1.132362,
      0.180273,
      0.162961,
      1,
      0.428485,
      0.148528,
      1,
      NULL,
      0,
      1.591098,
      4.121330,
      NULL,
      4.037050,
      10,
      NULL,
      5.216695,
      4.540774,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      2.196183,
      33,
      3,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      1,
      2,
      '20311',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1.543478,
      19,
      329.424744,
      9,
      1.009049,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.564200,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.784791,
      NULL,
      0,
      0.548811,
      1,
      1,
      NULL,
      3,
      2.872829,
      1,
      1,
      0.988082,
      2.675453,
      NULL,
      1.837868,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.786532,
      NULL,
      NULL,
      0.567064,
      NULL,
      NULL,
      1.937565,
      NULL,
      NULL,
      11,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.142832,
      NULL,
      NULL,
      NULL,
      3.361105,
      1,
      1.263624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.440567,
      1.344253,
      1.311405,
      3,
      3.351841,
      1.473300,
      1.011007,
      0.363220,
      NULL,
      NULL,
      1.800109,
      1,
      1,
      0,
      NULL,
      NULL,
      0.921254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.314968,
      1.675396,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.474359,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.492305,
      0.782988,
      NULL,
      1,
      1.272585,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.983142,
      NULL,
      NULL,
      0.316470,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.062595,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      2.495691,
      NULL,
      NULL,
      NULL,
      1.183804,
      1.884809,
      6.008762,
      0,
      2.025516,
      7.415131,
      5.925884,
      0,
      0.778926,
      3.046845,
      0.864483,
      0,
      2,
      1,
      1,
      3.256250,
      0,
      1.576946,
      7.187190,
      0,
      6,
      1,
      1.333789,
      3,
      3,
      0,
      0,
      2.919319,
      1,
      0,
      1,
      3.218619,
      2,
      3.739074,
      NULL,
      5,
      NULL,
      2.607960,
      5,
      0,
      0,
      2,
      NULL,
      0,
      0,
      0,
      1,
      0.125675,
      NULL,
      NULL,
      0.690920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.849155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.457714,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.137229,
      0,
      1.775925,
      NULL,
      NULL,
      NULL,
      2.657279,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      NULL,
      3.059969,
      1,
      NULL,
      NULL,
      2.675528,
      NULL,
      NULL,
      NULL,
      0,
      1.609543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.421808,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.199723,
      0.288898,
      NULL,
      NULL,
      1.396847,
      0.839312,
      NULL,
      NULL,
      NULL,
      1.712949,
      NULL,
      NULL,
      2,
      2.547135,
      NULL,
      NULL,
      1.876213,
      0.771368,
      NULL,
      NULL,
      2.301636,
      NULL,
      NULL,
      NULL,
      2,
      3.480697,
      NULL,
      NULL,
      2.899306,
      3.681507,
      NULL,
      NULL,
      10.381719,
      4.675878,
      NULL,
      NULL,
      0.541315,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.475337,
      0.751705,
      1,
      NULL,
      NULL,
      1.378312,
      NULL,
      NULL,
      1,
      2,
      1,
      508.957129,
      4,
      0,
      1.902711,
      0.343028,
      0.922673,
      1,
      NULL,
      1,
      1.457502,
      0.382693,
      1,
      0.289723,
      1,
      NULL,
      0,
      0.261352,
      1,
      1.139139,
      0.503717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      6,
      7,
      7,
      NULL,
      2,
      9,
      NULL,
      0,
      NULL,
      1.427192,
      0,
      1,
      1,
      0,
      0,
      2,
      2.548963,
      2,
      0,
      0.809515,
      1,
      NULL,
      2,
      3.787675,
      0,
      3.588656,
      0.822974,
      1,
      0.078598,
      0,
      0,
      0,
      0.849988,
      0,
      0.336205,
      0,
      0,
      0.079116,
      2,
      1.164127,
      3,
      2,
      NULL,
      3,
      1.846049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.040469,
      0.714145,
      0,
      0,
      NULL,
      1.599832,
      2,
      3.965639,
      NULL,
      1,
      1.984540,
      0,
      NULL,
      0.844404,
      NULL,
      2,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      3,
      1.460307,
      0.073131,
      NULL,
      1.661802,
      13.331253,
      1,
      1.024478,
      NULL,
      0.317064,
      1.835775,
      0.592597,
      4,
      5,
      3,
      2.568694,
      2.577002,
      1,
      57,
      81.147566,
      2,
      0.252867,
      3,
      '01222',
      '',
      '',
      0.933683,
      '44140',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


