set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531493';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '3042040',
      NULL,
      0.901436,
      2,
      0,
      '0321',
      3,
      0,
      NULL,
      NULL,
      ' 2-20-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 2- 1-1992',
      15.165471,
      0.714510,
      242.172450,
      59.916361,
      3,
      ' 0-24-1995',
      '10- 8-1976',
      ' 4- 6-1993',
      2,
      2.188321,
      NULL,
      3,
      1.565555,
      NULL,
      NULL,
      1.689735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.570817,
      13.567548,
      5,
      NULL,
      1,
      3,
      1.005871,
      1.759897,
      3,
      0,
      1.220405,
      0,
      1,
      1,
      3.110872,
      1,
      0.248892,
      1.007749,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      5,
      1,
      NULL,
      1,
      0,
      0,
      5,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      2,
      2,
      2,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.476942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      4,
      0,
      4,
      2,
      0,
      1,
      1,
      3,
      NULL,
      1,
      3.199029,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.825989,
      1.955523,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.892067,
      NULL,
      3.775300,
      NULL,
      1,
      NULL,
      NULL,
      1.526845,
      3.167950,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      7,
      2,
      2,
      0,
      1,
      6.701552,
      ' 3-20-1987',
      44,
      ' 0-23-1974',
      65,
      NULL,
      0,
      1.319990,
      1.025128,
      1,
      0.380807,
      1.993498,
      0.624617,
      1,
      0.827675,
      1.626415,
      0.955391,
      0.560206,
      0.942591,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.545238,
      3,
      2,
      0,
      NULL,
      0,
      3,
      NULL,
      2,
      3,
      2,
      1.911762,
      2,
      NULL,
      3,
      0.166289,
      0,
      0,
      0.934131,
      0.650921,
      1,
      0.178573,
      1,
      0,
      0,
      1.521042,
      0,
      0,
      0.884146,
      0.135202,
      NULL,
      8,
      0,
      7,
      4,
      0,
      3.670739,
      0.131973,
      2,
      2,
      2.791255,
      3.086819,
      67,
      2,
      2,
      NULL,
      78,
      NULL,
      NULL,
      2,
      4.134808,
      NULL,
      '31331',
      '41130',
      NULL,
      1.654451,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      8.384213,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328918,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.144251,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834751,
      0.122535,
      0.564991,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.836436,
      3.911941,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186190,
      NULL,
      0,
      1.078680,
      NULL,
      NULL,
      NULL,
      0.160015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.940349,
      NULL,
      NULL,
      0.080391,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.983866,
      NULL,
      NULL,
      0.028134,
      NULL,
      NULL,
      0.659259,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.659790,
      NULL,
      NULL,
      0.722248,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.289702,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.748647,
      NULL,
      NULL,
      0.793190,
      NULL,
      NULL,
      0.091255,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4.441665,
      NULL,
      0.940562,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.543890,
      0,
      0.343914,
      NULL,
      NULL,
      0.036542,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.478071,
      0.465812,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      NULL,
      1.062769,
      NULL,
      0.559279,
      7,
      4,
      NULL,
      NULL,
      16,
      31.205646,
      NULL,
      NULL,
      1.631186,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269109,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.240993,
      NULL,
      NULL,
      2.487090,
      3.474273,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.100084,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.477876,
      0.163022,
      NULL,
      NULL,
      0.784484,
      1.873565,
      NULL,
      NULL,
      3.746694,
      0.617443,
      NULL,
      NULL,
      3.671910,
      NULL,
      NULL,
      NULL,
      2.970495,
      1,
      NULL,
      NULL,
      NULL,
      2.486956,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      4,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.243906,
      0.276508,
      NULL,
      1,
      0.599081,
      1.837271,
      0.072296,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.924920,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0.625924,
      1,
      2.173799,
      0,
      1,
      NULL,
      1,
      0.594052,
      1,
      1,
      1,
      0.632944,
      3.400286,
      NULL,
      0,
      NULL,
      0.784933,
      NULL,
      0.960765,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      14,
      1.686083,
      0.088658,
      NULL,
      NULL,
      0.705251,
      NULL,
      1.557802,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.008063,
      NULL,
      NULL,
      NULL,
      1.572911,
      NULL,
      0.658426,
      NULL,
      0,
      NULL,
      1.342760,
      NULL,
      0,
      NULL,
      0.916445,
      NULL,
      NULL,
      NULL,
      0.696216,
      1.844389,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.207606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.134954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.467885,
      0,
      1.816287,
      36,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1.043956,
      NULL,
      3.134509,
      1,
      2,
      0.069103,
      0,
      0.486941,
      NULL,
      0,
      0,
      NULL,
      1,
      0.376985,
      NULL,
      0,
      0,
      NULL,
      0.773476,
      0,
      NULL,
      0.794849,
      0.833148,
      NULL,
      0.730800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.787292,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.924986,
      0.049485,
      NULL,
      2,
      NULL,
      0.232856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      161.749404,
      1,
      0,
      6,
      '40441',
      '21140',
      NULL,
      NULL,
      '',
      NULL,
      '',
      0.393312,
      '',
      NULL,
      '');
commit;
end;
/


