set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000090';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '3423240',
      3.355185,
      0,
      NULL,
      3,
      '1123',
      2.318431,
      3.256006,
      5.252318,
      NULL,
      ' 3-28-1978',
      NULL,
      NULL,
      4,
      2.858613,
      0,
      ' 3-29-1988',
      NULL,
      2.061838,
      1743.560896,
      831,
      1,
      NULL,
      NULL,
      ' 7-18-1990',
      2.667586,
      0,
      1,
      0.635075,
      0,
      NULL,
      4,
      NULL,
      1.905936,
      26,
      NULL,
      NULL,
      5.580445,
      2,
      15,
      0,
      23,
      NULL,
      1,
      3.102216,
      1,
      0,
      NULL,
      1.795237,
      1.881621,
      1.928660,
      NULL,
      1.121362,
      0,
      NULL,
      1.068832,
      0,
      1,
      7,
      2,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.952885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      1,
      4,
      1,
      1,
      1,
      1,
      NULL,
      1,
      2,
      0,
      2,
      0,
      4,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      NULL,
      1,
      1.059908,
      1.259886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.677830,
      0.266851,
      5.043856,
      0,
      NULL,
      1.316428,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.510145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.792092,
      NULL,
      1.258297,
      0,
      1.103942,
      0.232842,
      1.008591,
      0.652375,
      NULL,
      NULL,
      1.439306,
      66.834289,
      23,
      NULL,
      0,
      1.678357,
      NULL,
      NULL,
      0,
      2,
      0,
      3,
      3,
      3,
      1,
      2,
      1,
      0.201546,
      0.767448,
      0,
      4.173708,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.404703,
      0,
      0.697337,
      2,
      1,
      3.494608,
      0.221211,
      9,
      7.524958,
      2.536877,
      0.775532,
      9,
      2,
      3,
      1.030745,
      1.318004,
      1,
      0,
      NULL,
      50.105298,
      NULL,
      1.294011,
      78,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      '31121',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      '102',
      '43310',
      NULL,
      1.806270,
      59.898767,
      313,
      2.687878,
      1.074907,
      NULL,
      NULL,
      37,
      5,
      3,
      1,
      0,
      0.326080,
      NULL,
      NULL,
      0.736749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.890386,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.790382,
      NULL,
      NULL,
      1.993291,
      NULL,
      NULL,
      0.117595,
      NULL,
      NULL,
      0.921443,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.162367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107076,
      3.164389,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.793784,
      2,
      1.627898,
      0.272570,
      0,
      NULL,
      0,
      1,
      0.679035,
      1,
      NULL,
      1,
      1,
      1.677717,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.633088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345181,
      7,
      0.921531,
      1,
      0.369328,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      16.528570,
      7.684857,
      3.518935,
      11,
      1,
      1,
      NULL,
      NULL,
      0,
      1.923543,
      NULL,
      17.118822,
      NULL,
      NULL,
      1.835166,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.563170,
      NULL,
      NULL,
      0.169045,
      NULL,
      NULL,
      0.659158,
      NULL,
      NULL,
      18.799039,
      NULL,
      NULL,
      0.332961,
      13,
      3,
      NULL,
      NULL,
      NULL,
      3.157723,
      3,
      3,
      0,
      NULL,
      NULL,
      2,
      7.911005,
      6.620371,
      2.905745,
      1,
      0.814660,
      NULL,
      NULL,
      NULL,
      8,
      5.328435,
      NULL,
      0,
      4.849946,
      3,
      1,
      7.763878,
      3,
      1.173715,
      3,
      1,
      0.936458,
      10,
      NULL,
      6,
      1.754320,
      1.719737,
      2,
      NULL,
      NULL,
      1.840469,
      0,
      4,
      1,
      1,
      1.642655,
      0.270058,
      0,
      1.193309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.639677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.457234,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.327922,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.801323,
      NULL,
      NULL,
      0.999556,
      NULL,
      1,
      1.714988,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.621941,
      NULL,
      NULL,
      45.285060,
      385,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0.837010,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.665101,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.015240,
      NULL,
      NULL,
      NULL,
      2.085543,
      0.597104,
      NULL,
      NULL,
      1.467452,
      1,
      NULL,
      NULL,
      0.218259,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.032725,
      3.676972,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      11.104022,
      3.551103,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      261.410322,
      54,
      0,
      4,
      1,
      0,
      NULL,
      NULL,
      0.456580,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.017290,
      3134.648355,
      1501.387060,
      0,
      0.564667,
      0,
      NULL,
      1.969265,
      1,
      0.644841,
      NULL,
      0.309301,
      1,
      0.412843,
      1.035365,
      1.351611,
      NULL,
      0,
      0.031711,
      0.967876,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      1.334852,
      NULL,
      0.299057,
      NULL,
      2,
      7,
      3.327693,
      2.761770,
      1,
      NULL,
      1.350300,
      0,
      0,
      NULL,
      1.715588,
      0,
      0.691910,
      NULL,
      0.579915,
      1,
      1.281594,
      0,
      1.808783,
      1,
      NULL,
      0,
      1.397707,
      1.017875,
      1,
      1,
      0,
      NULL,
      1.661668,
      1,
      0.761168,
      1,
      18,
      5.143792,
      2,
      1.452682,
      3,
      3.188274,
      NULL,
      2,
      0.664759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.621789,
      NULL,
      0.886414,
      1.763584,
      NULL,
      0,
      NULL,
      4,
      3,
      1.165755,
      1,
      26.154157,
      82.004905,
      4,
      1,
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      4.193099,
      NULL,
      '04222',
      '');
commit;
end;
/


