set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6909717';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.683044,
      NULL,
      1.787677,
      2,
      3.503245,
      0.441273,
      3,
      0,
      '410',
      '20404333',
      5.256307,
      43,
      NULL,
      2,
      0,
      4,
      2,
      '3412',
      NULL,
      0.778862,
      NULL,
      NULL,
      '11-27-1981',
      8,
      36.492853,
      NULL,
      NULL,
      1,
      ' 4-14-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 2-20-1983',
      NULL,
      NULL,
      0,
      3,
      3.150872,
      1.059296,
      2.220928,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8.751482,
      0.598623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.351620,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      3.675822,
      0,
      0.627858,
      1,
      NULL,
      0,
      2,
      2,
      NULL,
      0,
      NULL,
      0,
      4,
      NULL,
      0,
      2,
      NULL,
      0,
      0,
      0,
      2,
      1,
      0,
      0,
      NULL,
      0.561089,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0.070113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      5,
      1,
      0,
      0,
      1,
      5,
      5,
      0,
      0,
      4,
      0,
      0,
      5,
      1,
      1,
      NULL,
      NULL,
      3,
      0,
      4,
      1,
      5,
      0,
      0,
      3,
      7,
      2,
      '10- 5-2003',
      36,
      ' 8- 7-1990',
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3.142188,
      3.185228,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      3,
      2.590260,
      0.786154,
      2,
      NULL,
      NULL,
      NULL,
      3.644585,
      2.926039,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.866453,
      0.160794,
      1,
      1.377514,
      0,
      3.563689,
      0.338138,
      1.286529,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      2,
      0,
      1,
      2,
      3,
      1,
      0,
      2,
      1,
      0,
      3,
      5,
      2,
      2.140464,
      0.589638,
      0.198606,
      0,
      0.317381,
      1,
      0,
      0.639791,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.987834,
      4,
      NULL,
      9,
      4,
      3.101351,
      8.049371,
      NULL,
      0.676237,
      5,
      0,
      NULL,
      0.810724,
      NULL,
      3.216684,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      1,
      NULL,
      5,
      '43312',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      0.624471,
      '',
      '',
      '',
      3.206381,
      35.192813,
      40.993571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      3.396333,
      NULL,
      NULL,
      NULL,
      1.926541,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0.510502,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.330627,
      0.844866,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.402876,
      NULL,
      NULL,
      3.379390,
      3,
      1.490683,
      1,
      NULL,
      NULL,
      7.186805,
      1,
      NULL,
      0,
      0.834313,
      1,
      1.600754,
      1,
      1.995637,
      NULL,
      NULL,
      NULL,
      2.927302,
      1.806878,
      0.189857,
      0,
      NULL,
      NULL,
      1.127422,
      NULL,
      NULL,
      3.607305,
      NULL,
      0,
      1.506691,
      0.719098,
      NULL,
      NULL,
      2,
      NULL,
      0.471772,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.782125,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.674887,
      NULL,
      NULL,
      0.635822,
      1,
      1.320966,
      0,
      0.564617,
      1.334925,
      2.335550,
      NULL,
      1.646350,
      NULL,
      NULL,
      NULL,
      0.901147,
      NULL,
      NULL,
      2,
      NULL,
      0.615498,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.775104,
      3.485819,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.906781,
      NULL,
      NULL,
      0.654685,
      NULL,
      NULL,
      0.319434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3.837812,
      1,
      2.347336,
      1.791669,
      3.288806,
      4,
      3,
      5.494490,
      5.760437,
      5,
      1.303048,
      4.224667,
      1,
      2.979964,
      2,
      1.926844,
      3.801777,
      1.434652,
      NULL,
      NULL,
      3.514151,
      NULL,
      NULL,
      5.665288,
      NULL,
      1,
      0.525670,
      0.272263,
      3.542180,
      2,
      2.376922,
      2.361561,
      1.400862,
      2,
      3.081504,
      3,
      2,
      4.465996,
      NULL,
      5,
      5.266019,
      0.529087,
      1,
      NULL,
      3,
      1,
      3,
      1.131060,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.863450,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.029027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.948082,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.003612,
      NULL,
      NULL,
      3.790697,
      NULL,
      NULL,
      1,
      0,
      0,
      0.486095,
      3.724804,
      NULL,
      6.074001,
      NULL,
      3.364672,
      NULL,
      0.433183,
      NULL,
      NULL,
      NULL,
      3.414865,
      NULL,
      NULL,
      NULL,
      3.949004,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.608048,
      NULL,
      NULL,
      NULL,
      3.659014,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.325485,
      NULL,
      NULL,
      NULL,
      0.656112,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.314956,
      NULL,
      0.762484,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.438077,
      NULL,
      0.596065,
      NULL,
      0.376456,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.249318,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      5,
      1,
      3.306418,
      NULL,
      3.882087,
      NULL,
      NULL,
      NULL,
      0.954632,
      NULL,
      NULL,
      3,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.127935,
      8,
      1.158041,
      NULL,
      NULL,
      1.521753,
      0,
      0,
      1.359995,
      2.762236,
      0.831695,
      NULL,
      1,
      1,
      1,
      0.804114,
      1,
      0,
      1,
      1.785255,
      NULL,
      0.346430,
      NULL,
      1,
      NULL,
      0.307157,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      44.247843,
      NULL,
      0.309769,
      37,
      39.765565,
      1,
      1,
      NULL,
      NULL,
      0.586439,
      NULL,
      0,
      NULL,
      0.912186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295491,
      NULL,
      0,
      NULL,
      1.670768,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.690748,
      NULL,
      1,
      2.994751,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.696369,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.978379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.485718,
      NULL,
      0.498898,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.864717,
      NULL,
      0,
      NULL,
      0,
      0,
      0.109645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      6,
      NULL,
      2,
      4.586667,
      0,
      0.688713,
      0,
      0.118815,
      NULL,
      1,
      1.581158,
      1.432065,
      0.856662,
      1,
      2.388319,
      1.923501,
      1.588786,
      NULL,
      1.076993,
      0.552451,
      0.036718,
      0,
      1,
      1.779832,
      0,
      NULL,
      1.286251,
      0,
      0,
      NULL,
      0,
      NULL,
      2.288131,
      0.999496,
      0.871632,
      0,
      0.450210,
      0.514272,
      0.901125,
      1,
      0,
      1,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805338,
      NULL,
      1,
      1,
      1,
      0.455062,
      0,
      3,
      NULL,
      1.179135,
      NULL,
      NULL,
      39,
      59,
      2,
      2,
      4,
      '33431',
      '00200',
      '',
      1.477837,
      '',
      '',
      '',
      0.920772,
      '',
      '',
      '');
commit;
end;
/


