set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507588';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '4431344',
      2.738702,
      0,
      3,
      2,
      NULL,
      2.417681,
      0.630697,
      NULL,
      NULL,
      ' 1-22-1996',
      21,
      NULL,
      3,
      1.013514,
      NULL,
      ' 1- 3-2000',
      37.686676,
      NULL,
      43.038922,
      NULL,
      1,
      ' 2-25-1978',
      ' 7-22-1988',
      NULL,
      1,
      3,
      1,
      3,
      1.361276,
      2,
      2,
      1.682750,
      1.331193,
      NULL,
      2,
      15.123148,
      5.214732,
      1,
      NULL,
      3,
      NULL,
      3,
      NULL,
      5.634525,
      3.857075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.485669,
      0,
      0,
      4,
      0,
      NULL,
      0,
      3,
      0,
      1,
      1,
      NULL,
      0,
      0.162603,
      1,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.465833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      5,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0.616202,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      5,
      NULL,
      3,
      2,
      0,
      0,
      1,
      2,
      0,
      NULL,
      5,
      5,
      0,
      0,
      2,
      5,
      NULL,
      1,
      NULL,
      0.058468,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.865436,
      NULL,
      NULL,
      1,
      1.178614,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.041174,
      3.989660,
      1.684998,
      0.625772,
      1.467022,
      3,
      44.502353,
      3,
      1.421177,
      NULL,
      NULL,
      NULL,
      1,
      1.677839,
      3,
      3,
      3,
      0,
      0,
      0,
      1,
      1,
      3,
      1,
      0,
      3,
      1,
      3,
      0,
      1.275583,
      1,
      1,
      0.840664,
      NULL,
      1,
      1,
      1.887473,
      1.246951,
      NULL,
      1,
      0,
      NULL,
      3.545144,
      1.518908,
      11,
      4.336261,
      2,
      5.357637,
      1,
      7,
      4,
      0.419972,
      1.354641,
      3.147170,
      3,
      2.214364,
      44.705120,
      0,
      1.553174,
      NULL,
      55,
      30,
      NULL,
      4,
      3,
      0,
      '0030',
      '3310',
      NULL,
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.207963,
      15.494069,
      95,
      2.697501,
      3.766077,
      NULL,
      2.095192,
      NULL,
      NULL,
      0.672226,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081235,
      3,
      2,
      1,
      1,
      NULL,
      3.105227,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.717545,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.830923,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991267,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.348225,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.283027,
      3,
      NULL,
      NULL,
      1.391412,
      1,
      3.573922,
      3,
      0.294564,
      NULL,
      3.085435,
      3,
      1.598890,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.090707,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.276806,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.364699,
      1.487915,
      1.813007,
      NULL,
      NULL,
      2.946068,
      7,
      6,
      0.644781,
      1.317037,
      1,
      1.372937,
      0,
      3,
      NULL,
      2.879212,
      3.622463,
      NULL,
      3.580863,
      2.486334,
      0.172013,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.432654,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0.892443,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.675306,
      1,
      NULL,
      1,
      0.411950,
      0.671204,
      0.537595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      3,
      1,
      2,
      2.931898,
      1,
      1,
      31,
      1,
      1.125522,
      NULL,
      NULL,
      1.759265,
      0,
      1.350046,
      1.493822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883476,
      NULL,
      0.225751,
      NULL,
      1,
      1,
      NULL,
      0.415477,
      1,
      1,
      1.392732,
      1,
      1,
      0,
      0.316938,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1.561357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.370174,
      1.614323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.582922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846507,
      0.406706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.410688,
      1.591351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825955,
      1.649013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.378455,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.788533,
      2.172936,
      NULL,
      1,
      0,
      0.650185,
      NULL,
      NULL,
      0,
      0.313392,
      1.240810,
      1.738249,
      1,
      0,
      1.522399,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      3,
      NULL,
      2,
      2,
      4.281270,
      3,
      2,
      1,
      NULL,
      1.288965,
      NULL,
      1,
      0.710522,
      NULL,
      0,
      NULL,
      NULL,
      0.277597,
      1,
      NULL,
      NULL,
      2.309840,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.260899,
      NULL,
      1,
      0,
      NULL,
      0.743346,
      NULL,
      0.797581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711557,
      NULL,
      0,
      NULL,
      1.479819,
      NULL,
      3,
      2,
      1,
      3.642446,
      1.078782,
      0,
      75.385664,
      NULL,
      4,
      4.807885,
      0,
      '0201',
      '1114',
      '',
      0.149985,
      '24104',
      '',
      NULL,
      0.610078,
      '',
      '',
      '');
commit;
end;
/


