set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '2123021',
      NULL,
      NULL,
      2,
      3,
      '4111',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.822285,
      0,
      ' 7-13-1989',
      21,
      3,
      NULL,
      NULL,
      0,
      NULL,
      ' 4-19-1993',
      '11-28-1986',
      3,
      0,
      NULL,
      1.989644,
      1.763227,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.512431,
      NULL,
      NULL,
      NULL,
      4,
      12,
      NULL,
      2,
      6.320196,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      4.873401,
      NULL,
      2,
      0,
      0,
      0.952723,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      4,
      3.794530,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      2.530125,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.841211,
      NULL,
      NULL,
      0,
      2,
      1,
      3,
      1,
      1,
      0.342029,
      0.949806,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      0,
      0,
      3.759704,
      1,
      1,
      0,
      0,
      1.459317,
      NULL,
      0.956279,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      2,
      1,
      NULL,
      1,
      1.775897,
      ' 6- 2-2000',
      6,
      ' 2-22-1997',
      6,
      3.060301,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.858532,
      2,
      1.450006,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      0.727810,
      4.797870,
      1.280375,
      NULL,
      NULL,
      1.168828,
      2.443730,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.166189,
      NULL,
      0.032637,
      1,
      1.561032,
      3,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      1,
      1,
      3,
      3,
      3,
      0,
      NULL,
      1,
      1,
      0.115619,
      3,
      3,
      3,
      1,
      1,
      0,
      0.537569,
      1,
      0,
      1,
      1.701137,
      0.019352,
      1,
      1.245221,
      1,
      1.617073,
      0.635554,
      1.243414,
      6,
      NULL,
      2,
      11,
      4,
      NULL,
      4.875965,
      3,
      6,
      3,
      2,
      1.891412,
      52,
      NULL,
      3,
      NULL,
      10,
      30,
      104,
      5,
      0,
      2.287722,
      '44204',
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      0.619480,
      '',
      NULL,
      '',
      NULL,
      44.388915,
      87,
      18,
      0.048500,
      NULL,
      NULL,
      NULL,
      NULL,
      0.889444,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108450,
      NULL,
      NULL,
      1.439982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.515756,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.143279,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.873831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.745432,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.465154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.077505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      2.969530,
      0.864644,
      NULL,
      NULL,
      0.392092,
      2,
      NULL,
      NULL,
      0,
      0.414986,
      1,
      NULL,
      1,
      2.557520,
      3.883026,
      NULL,
      1.175981,
      NULL,
      NULL,
      1.688405,
      NULL,
      NULL,
      0.690432,
      NULL,
      NULL,
      0.370050,
      NULL,
      NULL,
      0.848371,
      NULL,
      NULL,
      1.105808,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.003488,
      0.863743,
      5.504781,
      0,
      0,
      1,
      0.422610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.359090,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.837656,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297529,
      2.587935,
      0.438481,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.355821,
      1,
      NULL,
      1.679400,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      6.072969,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.310643,
      NULL,
      1,
      1.899254,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      1.706669,
      1,
      0.428995,
      1.416698,
      1.866967,
      0.879751,
      0.439399,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.148186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      5,
      3,
      2.659134,
      NULL,
      5,
      3.233517,
      NULL,
      0.485631,
      NULL,
      1.129329,
      NULL,
      1,
      NULL,
      NULL,
      1.201013,
      1,
      NULL,
      1.701587,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.208707,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.707759,
      1.002740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.862758,
      NULL,
      2.452396,
      NULL,
      0.967023,
      NULL,
      0,
      NULL,
      1.006797,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.979072,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      0,
      3,
      1.668794,
      NULL,
      0,
      NULL,
      0.413360,
      NULL,
      0,
      1,
      5,
      0,
      NULL,
      NULL,
      0.869420,
      52.709326,
      1,
      1,
      0.837481,
      '14010',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0.033103,
      '',
      NULL,
      NULL);
commit;
end;
/


