set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '3124121',
      1,
      NULL,
      0,
      1,
      '2204',
      NULL,
      0.673628,
      NULL,
      NULL,
      NULL,
      44,
      NULL,
      NULL,
      2,
      3.931563,
      ' 3-20-1985',
      20.438837,
      2,
      297.629498,
      NULL,
      1,
      ' 7-12-1975',
      ' 2-22-2003',
      ' 9-15-1983',
      1,
      NULL,
      1,
      1,
      1,
      0.570840,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      25.190658,
      NULL,
      NULL,
      0.225974,
      3,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2.153104,
      1,
      0,
      1,
      0,
      NULL,
      1,
      5,
      NULL,
      5,
      0,
      NULL,
      NULL,
      6,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1.059424,
      NULL,
      NULL,
      3,
      0,
      1.711007,
      1,
      NULL,
      0.496064,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      NULL,
      1.644674,
      1,
      0,
      1,
      1,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      3,
      0,
      0,
      1,
      2.173556,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0.780412,
      1,
      0,
      0,
      1,
      NULL,
      1,
      3,
      1,
      1,
      1,
      1,
      0,
      5,
      0,
      0,
      1,
      3,
      3,
      1,
      3,
      0,
      5,
      3,
      0,
      5,
      NULL,
      NULL,
      ' 8-20-1987',
      686,
      ' 8-12-1991',
      4,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0.917832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1083.849229,
      2.330913,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.058277,
      2.484459,
      3.701323,
      NULL,
      NULL,
      3,
      NULL,
      0.934575,
      6,
      1,
      6,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.404722,
      NULL,
      0,
      0,
      1,
      1.263113,
      1.274268,
      1,
      22,
      1.339358,
      0.120690,
      NULL,
      NULL,
      NULL,
      3,
      0.785160,
      NULL,
      0,
      2,
      2,
      3,
      NULL,
      2,
      2,
      3,
      NULL,
      1,
      0.913860,
      2.162840,
      3.857648,
      2.958180,
      0.014512,
      NULL,
      1,
      0.526016,
      3,
      NULL,
      1.688265,
      1.030512,
      1.365729,
      1.156652,
      0,
      0,
      0.534597,
      4.895326,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      73,
      69,
      89.146425,
      4,
      1.384681,
      NULL,
      '21114',
      '',
      '',
      1.286232,
      '',
      '',
      '',
      1.960026,
      '',
      '',
      NULL,
      3,
      30,
      19.538276,
      32,
      0.769848,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.237720,
      NULL,
      NULL,
      1.889996,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.449313,
      3,
      0.581660,
      NULL,
      NULL,
      0.120198,
      1,
      NULL,
      1.946784,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.940161,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073455,
      NULL,
      NULL,
      1.347728,
      NULL,
      NULL,
      1.643472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.230374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409849,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.486098,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.659366,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.445945,
      NULL,
      NULL,
      1.601415,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.590089,
      NULL,
      NULL,
      5.229063,
      1.658042,
      1,
      1.104202,
      NULL,
      NULL,
      0.523659,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.445708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      3.357717,
      1,
      2.646464,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      6.567264,
      6.574338,
      NULL,
      NULL,
      1.844180,
      NULL,
      NULL,
      NULL,
      1,
      1.628120,
      0,
      1,
      0.811253,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749162,
      2.187015,
      1,
      1.063861,
      1,
      0,
      0.976706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.329726,
      1.639534,
      NULL,
      2,
      14,
      NULL,
      1,
      NULL,
      NULL,
      0.454267,
      11,
      NULL,
      1,
      NULL,
      NULL,
      0.710345,
      NULL,
      NULL,
      0.986113,
      NULL,
      0.185525,
      NULL,
      0,
      1,
      1,
      NULL,
      0.572656,
      1.795606,
      0.730631,
      0.381470,
      0,
      0,
      1,
      1,
      0,
      0,
      1.520196,
      NULL,
      1,
      0,
      1.528502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      8.892234,
      2.499985,
      0,
      3.893228,
      2,
      2,
      1,
      2,
      1,
      0.816601,
      1,
      NULL,
      NULL,
      0.409701,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0.964066,
      NULL,
      3,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.877898,
      NULL,
      0,
      2,
      NULL,
      0.059988,
      NULL,
      NULL,
      1.096634,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.762169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456549,
      0.631531,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.583518,
      NULL,
      0,
      NULL,
      1.451526,
      NULL,
      NULL,
      NULL,
      2.725939,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      17,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.338821,
      NULL,
      1,
      5,
      0,
      1.706613,
      NULL,
      NULL,
      44,
      59.952299,
      4,
      0.430479,
      3,
      '32114',
      NULL,
      NULL,
      1.018947,
      '03341',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


