set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '4314440',
      NULL,
      0.439426,
      NULL,
      0,
      '2140',
      2,
      NULL,
      NULL,
      NULL,
      ' 4-15-1992',
      27,
      NULL,
      1,
      1,
      3,
      ' 0- 2-1999',
      60,
      4.737399,
      218,
      106,
      0,
      ' 8-26-1981',
      ' 1-29-1996',
      ' 5- 5-1997',
      2,
      NULL,
      0.290072,
      1.119892,
      NULL,
      0.379139,
      3,
      2,
      NULL,
      NULL,
      NULL,
      4.837656,
      7,
      23.513432,
      16,
      4,
      10,
      NULL,
      2,
      7.555680,
      2.521771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      2,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      3.867787,
      0,
      2,
      0,
      0,
      1.128524,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.192671,
      2,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      3.722991,
      1,
      2,
      0,
      0.950245,
      1.596638,
      3.409928,
      2,
      2.624956,
      1,
      2,
      1,
      8.332472,
      NULL,
      2,
      1,
      1.174255,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      5,
      NULL,
      NULL,
      1,
      NULL,
      4,
      0,
      1,
      0,
      7,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      4,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      1,
      NULL,
      1.706309,
      NULL,
      ' 9-29-1978',
      NULL,
      ' 5-12-1984',
      1,
      1,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1,
      0.561521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1293.887838,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.018824,
      3.355589,
      1.852855,
      0.313974,
      NULL,
      NULL,
      0,
      1.604405,
      1,
      1,
      1.614848,
      NULL,
      1,
      NULL,
      NULL,
      0.797762,
      NULL,
      1.421807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0.537465,
      2.011702,
      1,
      1,
      0,
      0,
      0,
      1.792528,
      0.052635,
      0.564802,
      1.573891,
      NULL,
      1.147467,
      0,
      1,
      1,
      0.785819,
      0,
      10,
      8,
      7.220362,
      9.877454,
      9.513552,
      2,
      1,
      0,
      3.035635,
      2.704474,
      1,
      2.946205,
      4,
      0,
      3,
      NULL,
      28,
      69,
      9.434662,
      2,
      0,
      3.495171,
      '01244',
      '',
      '',
      0.793732,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      32,
      70,
      12,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2,
      1,
      NULL,
      NULL,
      0.547328,
      NULL,
      NULL,
      0.434323,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.623138,
      2.582120,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.519636,
      1.073007,
      1,
      NULL,
      NULL,
      1.893305,
      NULL,
      NULL,
      1.026647,
      NULL,
      NULL,
      5.684709,
      1,
      5,
      0,
      0.812292,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.669750,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715103,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.012016,
      NULL,
      NULL,
      0.398557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.684877,
      2,
      0.425217,
      NULL,
      NULL,
      NULL,
      1.869661,
      4.299049,
      5.481424,
      2,
      NULL,
      NULL,
      1,
      0.930944,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.465680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.240495,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.440838,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.581702,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.662754,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      3.690153,
      0.393398,
      3.117006,
      2.910241,
      2.368499,
      NULL,
      1.082448,
      0,
      1.136235,
      NULL,
      0,
      0,
      2,
      3,
      NULL,
      NULL,
      2.983531,
      3.865263,
      4,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.692124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.407594,
      1.646327,
      1,
      1.589779,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647194,
      NULL,
      NULL,
      NULL,
      0.421187,
      1.177365,
      NULL,
      1,
      41.501142,
      NULL,
      0.491163,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.264855,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.871916,
      NULL,
      0.095183,
      90.452892,
      1.216369,
      0.190632,
      1,
      0.282171,
      1.306689,
      0.876303,
      1.945464,
      1,
      0,
      1.165968,
      0.788199,
      1,
      0,
      1.264939,
      1,
      1,
      1.628204,
      1.949772,
      1.207059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      4,
      3.802025,
      4,
      1.969036,
      3,
      4,
      3.747273,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914209,
      3,
      NULL,
      2,
      1.620768,
      NULL,
      1.800427,
      1.175561,
      NULL,
      1,
      0,
      NULL,
      1.730917,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.808457,
      0,
      NULL,
      1,
      1,
      1.127268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.090467,
      1,
      NULL,
      1,
      NULL,
      0.394280,
      NULL,
      0.419859,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0.743332,
      NULL,
      1,
      NULL,
      1.236242,
      NULL,
      1.956168,
      NULL,
      3.843985,
      NULL,
      NULL,
      NULL,
      11.376415,
      2.741825,
      NULL,
      0,
      NULL,
      1.336752,
      NULL,
      NULL,
      NULL,
      1,
      4,
      5,
      0.426660,
      NULL,
      NULL,
      100.354626,
      136,
      4,
      0,
      3.939777,
      '40024',
      '',
      NULL,
      2.601232,
      '10233',
      '',
      '',
      0.338449,
      '',
      '',
      '');
commit;
end;
/


