set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7704198';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      '4132',
      3.933699,
      2.363999,
      3,
      20.378125,
      ' 3- 1-1978',
      0,
      NULL,
      3,
      NULL,
      NULL,
      ' 7-21-1995',
      61.730059,
      1.828057,
      173.587965,
      40,
      2,
      NULL,
      NULL,
      ' 1- 2-1981',
      1.736906,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0.300968,
      0.117304,
      378.270908,
      1,
      6,
      0,
      2,
      8.052408,
      3,
      9.349310,
      2,
      NULL,
      6.020950,
      1,
      NULL,
      0,
      0,
      0.224518,
      1.107538,
      1.026073,
      0.386079,
      1,
      1,
      103.258119,
      8,
      6,
      4,
      1,
      0,
      1,
      NULL,
      0,
      3,
      0,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      5.313240,
      2,
      0,
      2,
      2,
      0.668713,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      3,
      2,
      0.929840,
      0,
      1.290505,
      NULL,
      1.271360,
      NULL,
      0.714971,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      0.589621,
      0,
      1,
      1,
      1,
      7,
      NULL,
      0,
      3.385378,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      5,
      4,
      0,
      0,
      1,
      5,
      0,
      5,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      0,
      0,
      0,
      3,
      0,
      0,
      3,
      1,
      NULL,
      4,
      NULL,
      4,
      NULL,
      3,
      NULL,
      NULL,
      4,
      1,
      ' 1- 1-2002',
      1910,
      ' 2- 1-1986',
      1697,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      4,
      NULL,
      0,
      8.245433,
      1.188192,
      NULL,
      NULL,
      NULL,
      NULL,
      7.693911,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881549,
      1,
      1,
      0.197832,
      0.645556,
      0.564208,
      NULL,
      NULL,
      60.560803,
      1.999515,
      1.990370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7,
      NULL,
      21.578613,
      2,
      0,
      0,
      '44430',
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      2.168528,
      3.166692,
      3,
      18,
      0.371289,
      NULL,
      NULL,
      34.010138,
      NULL,
      3,
      2.951954,
      0.723144,
      1.337548,
      NULL,
      NULL,
      1.551281,
      NULL,
      NULL,
      3,
      0,
      0,
      0.458254,
      NULL,
      NULL,
      1.440847,
      NULL,
      NULL,
      0,
      2.347834,
      2.056563,
      0.998293,
      NULL,
      NULL,
      0.202455,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.131434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.168300,
      5.806452,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.281159,
      1,
      3.619166,
      1.353975,
      NULL,
      NULL,
      0.989612,
      NULL,
      NULL,
      1.140225,
      0,
      1,
      NULL,
      0,
      0.833595,
      NULL,
      0,
      0.915595,
      1,
      1,
      NULL,
      0,
      0,
      1.592501,
      0.061613,
      1.801611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363448,
      NULL,
      NULL,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.778783,
      3.187606,
      2.985368,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.672899,
      2,
      1,
      1.579926,
      NULL,
      NULL,
      1.844336,
      7,
      6.496234,
      1,
      NULL,
      NULL,
      0.780009,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.691649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.371013,
      NULL,
      NULL,
      1,
      0.202212,
      3.933221,
      1,
      1.099353,
      2,
      6.335249,
      7,
      6,
      NULL,
      5.350982,
      0.702518,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.420927,
      1.207588,
      NULL,
      1.745825,
      NULL,
      10.962064,
      5.892083,
      4.450894,
      2,
      3.770401,
      3,
      3.141999,
      0.010747,
      3,
      2.636515,
      NULL,
      3,
      1,
      1.338150,
      3,
      NULL,
      NULL,
      NULL,
      9.757803,
      7,
      2,
      NULL,
      0,
      2,
      NULL,
      0,
      0.422490,
      NULL,
      1,
      2.152549,
      NULL,
      NULL,
      0.958600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.336904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.518940,
      NULL,
      NULL,
      1.769200,
      NULL,
      NULL,
      1,
      1.171558,
      0.065340,
      1.641334,
      0.243389,
      2.120555,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.141257,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.715309,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      154,
      39,
      0,
      NULL,
      NULL,
      0.631290,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.862886,
      NULL,
      1,
      4467,
      1216,
      1.579523,
      1.761292,
      0,
      0,
      0,
      0,
      1.869215,
      1,
      1.654453,
      1,
      0,
      0,
      NULL,
      0.765371,
      0.340502,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834308,
      NULL,
      0,
      NULL,
      19,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.991949,
      NULL,
      3,
      NULL,
      NULL,
      1.277842,
      3.772769,
      NULL,
      11,
      NULL,
      NULL,
      3,
      2.267633,
      NULL,
      0.162181,
      1.161861,
      NULL,
      7,
      1,
      NULL,
      12.593498,
      0.691046,
      NULL,
      1.347910,
      0.449180,
      1.570194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850503,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0.357346,
      25.408842,
      29.908980,
      NULL,
      1,
      1.464783,
      '21422',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


