set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930257';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '3012201',
      0,
      1.220989,
      1,
      3,
      NULL,
      NULL,
      2.263522,
      NULL,
      22.957342,
      NULL,
      46.165063,
      NULL,
      1,
      0.635843,
      0,
      ' 5-26-1991',
      33.585918,
      0,
      20.590570,
      4.935285,
      NULL,
      ' 0-10-1974',
      ' 6-17-1985',
      NULL,
      0.965526,
      NULL,
      2,
      1.909236,
      0.122519,
      NULL,
      0,
      0.653629,
      0,
      NULL,
      NULL,
      14.099174,
      5.223354,
      63,
      158,
      5,
      16.912924,
      NULL,
      NULL,
      NULL,
      1.154692,
      0,
      0,
      NULL,
      0.836971,
      0,
      0,
      0.884485,
      0,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      1,
      0,
      2,
      1,
      0,
      NULL,
      0,
      0,
      8.923461,
      3,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.603306,
      NULL,
      NULL,
      0,
      1,
      3.055507,
      1.955005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      NULL,
      5,
      3,
      0,
      NULL,
      0,
      NULL,
      0,
      4,
      NULL,
      NULL,
      1,
      0,
      0,
      0.900228,
      NULL,
      0,
      5,
      3,
      1,
      5,
      4,
      0,
      1,
      0,
      4,
      1,
      0,
      3,
      0,
      5,
      0,
      0,
      2,
      4,
      5,
      NULL,
      3,
      4,
      5,
      2,
      0,
      7.886671,
      0.356752,
      ' 6- 4-1974',
      220,
      '10-18-1976',
      53,
      3.180519,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      5,
      1,
      0,
      0,
      1.996815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.822955,
      0,
      2.546672,
      0.427381,
      NULL,
      1.414739,
      NULL,
      1.943135,
      1.553297,
      0.421856,
      2.754781,
      0.652324,
      5,
      1.953950,
      1.614535,
      10.818853,
      0,
      NULL,
      NULL,
      NULL,
      0.367447,
      3.060325,
      0.650923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.977010,
      1.919218,
      1,
      NULL,
      1.138291,
      0.037321,
      2.829316,
      2807.919959,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      3,
      NULL,
      2,
      2,
      0,
      2,
      NULL,
      2,
      2,
      NULL,
      NULL,
      18.196133,
      13,
      0,
      1,
      0.426829,
      166.542510,
      NULL,
      48.758241,
      1,
      1.096564,
      NULL,
      0,
      1.117534,
      1,
      1,
      NULL,
      18,
      1,
      1,
      8.047930,
      4.858826,
      0.310002,
      NULL,
      NULL,
      5.282016,
      NULL,
      1.264663,
      3.858386,
      NULL,
      0,
      NULL,
      2,
      1,
      NULL,
      23,
      18,
      55,
      2,
      1.158542,
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.620677,
      NULL,
      '',
      NULL,
      3,
      22,
      671,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1.317843,
      NULL,
      NULL,
      NULL,
      NULL,
      1.737918,
      1,
      NULL,
      NULL,
      2,
      0.168419,
      0.526392,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.171360,
      NULL,
      NULL,
      0.165316,
      NULL,
      NULL,
      0.755492,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      9.822872,
      3.295360,
      11.915594,
      NULL,
      NULL,
      12.548107,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.408226,
      0.072070,
      0,
      0.999805,
      0.233629,
      1.332082,
      0,
      1,
      1,
      0,
      NULL,
      0.538515,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.867931,
      NULL,
      NULL,
      NULL,
      1.005315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      8.380990,
      6.190875,
      3.233298,
      2,
      NULL,
      NULL,
      0.830828,
      NULL,
      2.825479,
      1.606009,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.691490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.270304,
      NULL,
      NULL,
      1.952549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      3,
      1.893363,
      0,
      2.275609,
      1,
      9,
      NULL,
      1,
      3,
      0.637503,
      2.497353,
      0.993849,
      3.116773,
      2,
      1.406547,
      NULL,
      NULL,
      1.162725,
      3.841058,
      3,
      0.812863,
      0,
      0.269548,
      3,
      1,
      1.197486,
      3.188097,
      3,
      0,
      0,
      0,
      3,
      7.003764,
      1,
      NULL,
      NULL,
      8.038151,
      NULL,
      1.001154,
      1,
      0,
      1.230098,
      NULL,
      0,
      1.375198,
      NULL,
      2.530713,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.834996,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.054334,
      0.159586,
      1,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.170486,
      NULL,
      NULL,
      NULL,
      1.290732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.236677,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.444920,
      NULL,
      NULL,
      NULL,
      1.665799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.884749,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.988134,
      537.958827,
      443.734638,
      0.470542,
      NULL,
      NULL,
      0.118881,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.847091,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      22,
      0,
      304,
      NULL,
      1,
      1.255199,
      1,
      0.947057,
      0,
      0,
      0,
      0.623801,
      0,
      NULL,
      0.230244,
      NULL,
      0.689424,
      1.821277,
      0.208721,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      1,
      3.879641,
      NULL,
      NULL,
      14.381180,
      NULL,
      3.471995,
      NULL,
      NULL,
      7,
      NULL,
      9,
      9.072624,
      NULL,
      0.402402,
      2,
      NULL,
      17,
      0.859130,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      15.875668,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0.402709,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1.309548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      4,
      5,
      3.226080,
      3.071959,
      2.483788,
      NULL,
      NULL,
      3,
      0.884222,
      NULL,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      1.478593,
      '',
      '',
      '');
commit;
end;
/


