set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7223859';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '3110314',
      3,
      0.020300,
      2,
      NULL,
      '2400',
      1.910064,
      0,
      1,
      1,
      NULL,
      24,
      NULL,
      5,
      2,
      0,
      ' 2- 7-1984',
      32,
      2.587012,
      206.799818,
      NULL,
      3,
      NULL,
      NULL,
      ' 9- 6-1981',
      2,
      0,
      0.921379,
      0.919523,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      6.341876,
      11.773683,
      15,
      8,
      1,
      23.881172,
      2,
      2,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1.821836,
      0,
      0.096026,
      NULL,
      0,
      114,
      5,
      5,
      NULL,
      1.317177,
      4,
      0,
      3,
      3,
      2,
      3,
      5,
      3,
      0,
      2,
      1,
      NULL,
      0,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      NULL,
      0,
      NULL,
      4,
      3,
      3,
      2,
      2,
      NULL,
      5,
      NULL,
      5.373070,
      1,
      NULL,
      0,
      1,
      2.237949,
      NULL,
      0.542464,
      1,
      NULL,
      0,
      3,
      0,
      5,
      0,
      NULL,
      2,
      NULL,
      4,
      NULL,
      2,
      NULL,
      3,
      2,
      0,
      4,
      5,
      5,
      0,
      5,
      2,
      4,
      NULL,
      4.692368,
      0.880790,
      ' 5-17-1988',
      1348.112865,
      NULL,
      1398.774631,
      2,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      1,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      0.217123,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.125372,
      3,
      0.495177,
      NULL,
      0,
      1.704882,
      1.711961,
      NULL,
      NULL,
      NULL,
      1,
      4.013805,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.188353,
      NULL,
      0,
      1,
      NULL,
      3,
      153,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.515443,
      2,
      0,
      3,
      2,
      0,
      2,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      2.808041,
      5.645968,
      0.910001,
      0.546651,
      2,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.742600,
      1,
      12.068831,
      1,
      0.561307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      17,
      NULL,
      NULL,
      NULL,
      3,
      0.134634,
      1.327919,
      '00131',
      '',
      '',
      1.638211,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      3,
      7,
      32.040903,
      27,
      2,
      35,
      NULL,
      65.371861,
      5,
      0.535463,
      0.711504,
      0,
      NULL,
      NULL,
      NULL,
      2.527516,
      NULL,
      NULL,
      4.146958,
      NULL,
      NULL,
      10.849378,
      NULL,
      NULL,
      2,
      2,
      2,
      NULL,
      1.719654,
      0,
      NULL,
      1,
      0,
      0.964591,
      NULL,
      NULL,
      2,
      3,
      8.183872,
      1,
      NULL,
      4.002194,
      2.811224,
      3,
      10,
      8.076227,
      10,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.435625,
      1,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.909175,
      1.163230,
      0.896135,
      NULL,
      3.311523,
      2,
      NULL,
      0,
      1.762844,
      2,
      0.795511,
      NULL,
      1,
      1.826822,
      1,
      1.799188,
      3.153466,
      3,
      NULL,
      2.293212,
      NULL,
      NULL,
      3.175382,
      2,
      12.289618,
      6.253355,
      0,
      0,
      NULL,
      1.291868,
      NULL,
      NULL,
      NULL,
      1.533866,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.880690,
      3.651010,
      3,
      3.479162,
      1,
      3.094147,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      9.824271,
      NULL,
      1,
      3.592034,
      0,
      0.606202,
      1,
      NULL,
      6,
      2,
      2,
      1,
      NULL,
      NULL,
      3,
      3,
      1,
      NULL,
      0.514408,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      2.402634,
      NULL,
      NULL,
      NULL,
      1.986480,
      2,
      3.613630,
      1,
      NULL,
      4,
      2,
      NULL,
      7.486415,
      1,
      2.337648,
      NULL,
      9,
      1,
      3.656511,
      2.026480,
      0.616570,
      2,
      NULL,
      0.915594,
      3,
      NULL,
      3.190801,
      7.771070,
      1,
      3.360727,
      3,
      2.445389,
      3.643940,
      NULL,
      0.654370,
      0,
      2.357965,
      3,
      0.145516,
      0,
      0,
      3.719451,
      5.873964,
      4.512735,
      NULL,
      3,
      10.977680,
      NULL,
      2,
      3,
      0.886740,
      NULL,
      1.861278,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.297782,
      NULL,
      NULL,
      0.872949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.270077,
      NULL,
      NULL,
      NULL,
      0.622413,
      1,
      1,
      1.230622,
      3,
      0.981001,
      NULL,
      NULL,
      0,
      0.528183,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.569080,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.537286,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.918868,
      NULL,
      NULL,
      NULL,
      0.267101,
      NULL,
      NULL,
      2.912900,
      1.017326,
      NULL,
      NULL,
      0.547400,
      1.585927,
      NULL,
      NULL,
      1,
      1.563548,
      NULL,
      NULL,
      1.704810,
      0.675832,
      NULL,
      NULL,
      2.422089,
      7,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.146220,
      479,
      1,
      NULL,
      NULL,
      0.191965,
      NULL,
      NULL,
      1,
      NULL,
      9.288252,
      0,
      NULL,
      NULL,
      0.424002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12317.495755,
      37.681719,
      0.800927,
      1,
      0.574413,
      0.099024,
      NULL,
      0.245770,
      1,
      2.259522,
      0.113979,
      3.327371,
      NULL,
      2,
      NULL,
      3.913660,
      1,
      1.585859,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1664,
      NULL,
      5.812957,
      28,
      17,
      2.772907,
      0,
      1.265456,
      NULL,
      0.511043,
      NULL,
      1.911287,
      NULL,
      0.533153,
      NULL,
      0.608549,
      NULL,
      1,
      NULL,
      2.207238,
      NULL,
      NULL,
      NULL,
      1.934461,
      NULL,
      NULL,
      NULL,
      0.785346,
      NULL,
      1.184781,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      2.185277,
      1.910400,
      2,
      NULL,
      1.766460,
      NULL,
      0.294881,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.055191,
      NULL,
      1.989814,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.914176,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.921283,
      NULL,
      NULL,
      NULL,
      1.115867,
      0,
      2.559443,
      NULL,
      0.777347,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.412714,
      NULL,
      0,
      NULL,
      0.271730,
      NULL,
      NULL,
      1.319729,
      2.995893,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.551921,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1773,
      NULL,
      150.787911,
      1,
      NULL,
      NULL,
      0.438837,
      NULL,
      3.008863,
      NULL,
      1494.161113,
      NULL,
      88,
      NULL,
      0.015138,
      NULL,
      0,
      1,
      2.822042,
      6,
      8,
      2,
      0,
      1,
      1.469802,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      5,
      NULL,
      5,
      1,
      0.023764,
      1.165077,
      1,
      1.225075,
      NULL,
      0.699984,
      0.940386,
      NULL,
      1.872662,
      0,
      NULL,
      1,
      1.902823,
      NULL,
      1,
      NULL,
      NULL,
      1.458156,
      1,
      NULL,
      1,
      0.856529,
      NULL,
      NULL,
      0.192577,
      NULL,
      1.226618,
      0,
      NULL,
      1.526547,
      2.430604,
      NULL,
      1.203071,
      1,
      NULL,
      NULL,
      1.599256,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.179608,
      NULL,
      NULL,
      NULL,
      0,
      3,
      6,
      NULL,
      1,
      NULL,
      15,
      36,
      0,
      1,
      7.018738,
      '44322',
      '00013',
      '22000',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


