set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7223859';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '1122111',
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      2,
      1,
      NULL,
      ' 7-29-1997',
      5,
      NULL,
      1,
      2.807906,
      0.022532,
      ' 5-19-1995',
      10.509429,
      0,
      NULL,
      95.661310,
      3,
      ' 4-19-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.674693,
      NULL,
      168,
      NULL,
      2.836800,
      4.983158,
      NULL,
      193,
      2,
      NULL,
      NULL,
      1,
      4,
      1.866222,
      1,
      1,
      0,
      1,
      1.773117,
      1.102467,
      0.927596,
      1.922855,
      0,
      NULL,
      4,
      NULL,
      6,
      0.546755,
      1,
      1,
      1,
      0,
      2,
      2,
      NULL,
      1,
      2,
      2,
      NULL,
      3,
      9,
      0,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      1.084910,
      NULL,
      NULL,
      3,
      NULL,
      2,
      3.418064,
      1.781001,
      1.808369,
      0.020815,
      1,
      0.195639,
      0,
      0.985205,
      1,
      0.157870,
      NULL,
      0.337542,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      6.405623,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564009,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4,
      3,
      0,
      8.804311,
      0,
      0,
      0,
      NULL,
      0.773360,
      NULL,
      1.786795,
      1,
      3,
      1,
      4,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      4,
      5,
      5,
      4,
      1,
      0,
      0,
      3,
      1,
      1,
      3,
      3,
      2,
      NULL,
      2.821437,
      ' 6-20-1979',
      643.824429,
      ' 8-14-1985',
      1249.253544,
      1.970400,
      0,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.318145,
      3,
      3.834638,
      0.401818,
      0,
      0.639286,
      1,
      1,
      1,
      1,
      3,
      1.696952,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.345068,
      1,
      1,
      0.025852,
      NULL,
      1.464745,
      NULL,
      NULL,
      NULL,
      0.783569,
      NULL,
      NULL,
      NULL,
      3,
      1.840163,
      0,
      3,
      1,
      0,
      NULL,
      2,
      NULL,
      3,
      0,
      0,
      0,
      1,
      4,
      13,
      25.095516,
      196.327292,
      39,
      185.337943,
      199,
      NULL,
      NULL,
      0.207716,
      1.013056,
      NULL,
      1.567381,
      1,
      1,
      NULL,
      0.372388,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325830,
      NULL,
      1,
      23,
      0.268900,
      0,
      NULL,
      1,
      '31403',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.843795,
      '',
      '',
      '',
      NULL,
      5.384981,
      114,
      9,
      NULL,
      32.922848,
      54,
      176.764639,
      0,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.148100,
      NULL,
      NULL,
      NULL,
      0.117332,
      0.343386,
      1.078693,
      NULL,
      3,
      1.080634,
      0,
      3,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.388547,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      3,
      NULL,
      2,
      0.785582,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      17,
      NULL,
      NULL,
      16.837981,
      NULL,
      NULL,
      0.098635,
      1,
      NULL,
      NULL,
      0,
      0.694907,
      1,
      0,
      1.057345,
      0.485493,
      0,
      1,
      1.976133,
      1.673331,
      1.009298,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.501978,
      NULL,
      3.810893,
      2,
      9.835537,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716189,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.555083,
      1,
      1,
      0.612716,
      0,
      NULL,
      NULL,
      0.831791,
      NULL,
      NULL,
      6,
      0.180458,
      7,
      NULL,
      3,
      0.716637,
      1.439175,
      NULL,
      NULL,
      11.113260,
      NULL,
      5.044589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.922020,
      NULL,
      NULL,
      1.055218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.991411,
      NULL,
      NULL,
      NULL,
      4.247959,
      3.015832,
      6.209516,
      4.608941,
      NULL,
      NULL,
      3,
      0.936314,
      3,
      3,
      1.531422,
      2.952587,
      2.647091,
      1.327357,
      1,
      NULL,
      NULL,
      NULL,
      9.986646,
      4.785829,
      9.707799,
      0.944129,
      3.998910,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      3,
      1,
      3,
      2.923500,
      5,
      0.398431,
      1,
      2,
      7.464994,
      4.810869,
      2.377397,
      NULL,
      NULL,
      0.225582,
      NULL,
      0.858588,
      0.953799,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.909541,
      NULL,
      NULL,
      0.831305,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.276856,
      1,
      1,
      0.365613,
      1.471182,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.512722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.070734,
      NULL,
      NULL,
      NULL,
      0.765360,
      NULL,
      NULL,
      NULL,
      4.860602,
      NULL,
      NULL,
      NULL,
      1.748407,
      NULL,
      NULL,
      NULL,
      3.134663,
      187.122713,
      94.072556,
      0.896439,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.181936,
      NULL,
      1063,
      NULL,
      NULL,
      NULL,
      0.476337,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      30.962828,
      NULL,
      1,
      0.407093,
      NULL,
      1,
      2.468611,
      1,
      0,
      1.939184,
      1,
      1,
      0.115069,
      1,
      3.368717,
      0,
      1,
      NULL,
      3.513714,
      NULL,
      NULL,
      NULL,
      0.761083,
      NULL,
      2.297054,
      NULL,
      3.820844,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.301651,
      1,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.589515,
      NULL,
      NULL,
      NULL,
      2.638335,
      NULL,
      1.817593,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.550183,
      NULL,
      1.648787,
      NULL,
      0.884872,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.535098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.144627,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.627624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.121826,
      NULL,
      1.097422,
      NULL,
      1.659077,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.309871,
      NULL,
      0,
      NULL,
      0.833516,
      1,
      0.227249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.781581,
      1,
      1.117456,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      897.251928,
      NULL,
      0.317305,
      NULL,
      1.563159,
      NULL,
      3.470461,
      1.042557,
      0.683325,
      NULL,
      48,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      1.559659,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      1,
      0.342611,
      NULL,
      0.119934,
      0.534158,
      NULL,
      1,
      0.683609,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.643392,
      NULL,
      0,
      1,
      NULL,
      0.698492,
      0.461342,
      NULL,
      0.755085,
      1.168093,
      NULL,
      0,
      1.253027,
      NULL,
      NULL,
      0.297080,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      3,
      1,
      1,
      3,
      28,
      NULL,
      5,
      NULL,
      0,
      '33120',
      '20132',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


