set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9693193';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      5,
      12,
      NULL,
      3,
      NULL,
      0,
      NULL,
      '2332',
      4.319443,
      NULL,
      NULL,
      NULL,
      ' 6-21-1980',
      130.444717,
      33,
      NULL,
      1.146765,
      4.566067,
      ' 7-16-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8-23-1996',
      NULL,
      ' 8-10-1978',
      3.200091,
      3.945993,
      NULL,
      3.707308,
      0,
      NULL,
      3,
      1.684139,
      0,
      2.073603,
      5,
      1.750927,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      1,
      1,
      0,
      1.736509,
      1,
      NULL,
      1,
      0.950826,
      10.855696,
      0,
      3,
      3,
      3,
      1.539272,
      0,
      1,
      1,
      3,
      0,
      2,
      2,
      0,
      2,
      0,
      0,
      1,
      4,
      NULL,
      2,
      NULL,
      1,
      1.874683,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.658919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      1,
      2,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0.326416,
      1,
      NULL,
      3,
      3,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      4,
      1,
      0,
      3,
      1,
      4,
      0,
      5,
      0,
      5,
      3,
      2,
      4,
      1.415901,
      ' 6- 7-1983',
      57.625975,
      ' 1-16-1974',
      10.763603,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      4,
      NULL,
      NULL,
      4,
      0,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3.418366,
      NULL,
      3,
      0,
      3,
      1.858156,
      1.814955,
      0,
      0,
      0,
      3.206481,
      0.152859,
      0,
      1,
      1.319927,
      1.967617,
      NULL,
      4.068991,
      0.507902,
      7,
      1.001622,
      NULL,
      NULL,
      NULL,
      1.427894,
      5.158164,
      0.292163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.638350,
      0,
      1,
      1,
      NULL,
      0,
      42.814927,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.788312,
      0,
      2,
      2,
      0,
      2,
      0,
      3,
      3,
      1,
      NULL,
      2,
      2.727371,
      2.742496,
      1,
      3,
      0,
      NULL,
      NULL,
      0,
      1,
      1.571561,
      0.542663,
      0.931491,
      1.355553,
      0.694597,
      0.647320,
      1,
      1.307584,
      2.173048,
      1.340336,
      NULL,
      1,
      3.491405,
      4.268184,
      6,
      1,
      NULL,
      0,
      1.818154,
      NULL,
      0,
      1.998144,
      69.229290,
      NULL,
      NULL,
      40,
      NULL,
      71,
      NULL,
      NULL,
      5.270020,
      0,
      '23242',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1.086387,
      '',
      NULL,
      '',
      3,
      16,
      29,
      43,
      NULL,
      38.741154,
      0,
      1,
      5,
      0.180780,
      1.220394,
      2,
      NULL,
      NULL,
      NULL,
      3.455581,
      NULL,
      NULL,
      2,
      0,
      3.446298,
      0.454938,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2.480904,
      0.908533,
      NULL,
      NULL,
      1.879749,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      1.132535,
      NULL,
      NULL,
      NULL,
      0.921018,
      NULL,
      NULL,
      NULL,
      0.529464,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.525187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.532402,
      NULL,
      0,
      2,
      3.615845,
      3.087774,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      5.289053,
      2.740807,
      NULL,
      3,
      3,
      NULL,
      1.817613,
      NULL,
      NULL,
      4.911788,
      5,
      3.309271,
      0.755601,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.516413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.105923,
      3,
      1,
      3,
      2,
      3,
      2,
      0,
      0.297562,
      2.672985,
      NULL,
      1,
      2,
      2.713020,
      1,
      0,
      0.417536,
      1.302346,
      1.198693,
      1.900204,
      0,
      4.239371,
      5.594706,
      4,
      NULL,
      1.325861,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.246384,
      1.788758,
      0.925339,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5.485727,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.145748,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      1,
      0.422141,
      0.286815,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      93.238762,
      NULL,
      NULL,
      NULL,
      0.989003,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.233679,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.969350,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.951780,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.687548,
      NULL,
      NULL,
      0.219115,
      NULL,
      NULL,
      1,
      NULL,
      0,
      202,
      1,
      1.933419,
      1,
      0.819622,
      NULL,
      0.021132,
      1,
      1,
      1,
      0.285844,
      1,
      NULL,
      1,
      1,
      1.492941,
      NULL,
      1.982760,
      2.052759,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241641,
      NULL,
      1.361443,
      NULL,
      2.986969,
      NULL,
      0.517434,
      NULL,
      0.879913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.420526,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.344028,
      0.167982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.195731,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760491,
      1.547509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.772244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.945734,
      0.472178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.756554,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.437933,
      NULL,
      0,
      1.731637,
      0.124138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2.343682,
      NULL,
      0.601507,
      NULL,
      0,
      5.154768,
      3,
      3.535338,
      NULL,
      NULL,
      NULL,
      NULL,
      1.648192,
      1,
      NULL,
      0,
      2,
      NULL,
      1,
      1.792042,
      NULL,
      0.228467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.385404,
      NULL,
      NULL,
      NULL,
      0.916676,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      2.975024,
      NULL,
      0.592150,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      0.170356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '02012',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.608484,
      '',
      '',
      '');
commit;
end;
/


