set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '1341140',
      2.416338,
      1,
      4,
      NULL,
      '1304',
      2.626847,
      0,
      NULL,
      NULL,
      ' 7- 9-1980',
      NULL,
      NULL,
      0,
      2.338780,
      NULL,
      ' 6-14-1989',
      NULL,
      2,
      246.621691,
      NULL,
      NULL,
      NULL,
      ' 6-25-1998',
      ' 3- 4-1981',
      2.203943,
      3,
      1,
      1.379146,
      1.213289,
      2,
      5,
      NULL,
      NULL,
      NULL,
      1,
      4,
      2,
      7.810331,
      1.436554,
      NULL,
      1.419674,
      0,
      1,
      2.108651,
      1.039837,
      1,
      NULL,
      0,
      1.522285,
      0,
      NULL,
      NULL,
      1.166367,
      0,
      0.989576,
      0,
      0,
      3,
      NULL,
      2,
      NULL,
      0,
      5,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.002836,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      5,
      3,
      0,
      1,
      2,
      0,
      1,
      NULL,
      1,
      0.395893,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      2,
      3,
      0,
      1,
      1,
      0,
      NULL,
      2,
      0,
      0,
      0.220090,
      ' 9-23-1990',
      8,
      ' 2-27-1990',
      41.161777,
      3,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.837319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.419378,
      1,
      8.160181,
      3,
      1.039548,
      0.204371,
      1.730409,
      1.153765,
      NULL,
      NULL,
      0,
      3.890934,
      1.304568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.862747,
      0,
      0.027654,
      NULL,
      NULL,
      0.185008,
      3,
      NULL,
      1.720430,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.119702,
      2,
      3,
      0,
      2,
      1,
      0,
      0,
      0,
      2,
      2,
      3,
      0,
      1,
      NULL,
      0.290113,
      0.954887,
      1,
      4.786831,
      0.436856,
      NULL,
      NULL,
      1,
      1.530755,
      NULL,
      0.996128,
      1,
      2,
      1.224966,
      2,
      0.339727,
      9,
      4,
      7.322551,
      7.031507,
      NULL,
      4,
      4.588201,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      56.269817,
      1,
      0.599743,
      NULL,
      49,
      NULL,
      50,
      4,
      1,
      NULL,
      '33243',
      '',
      NULL,
      0,
      '',
      '',
      '',
      5,
      '1224',
      NULL,
      '',
      3.699067,
      NULL,
      NULL,
      50,
      3.144078,
      NULL,
      0.470825,
      NULL,
      5,
      1.643407,
      1.614592,
      0.198330,
      1.134846,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.357810,
      NULL,
      NULL,
      0.676750,
      NULL,
      NULL,
      1.326415,
      NULL,
      NULL,
      3.567395,
      NULL,
      1.168636,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.397595,
      NULL,
      NULL,
      3.217439,
      1.989213,
      0.708130,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.311645,
      NULL,
      0.595003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445207,
      NULL,
      NULL,
      0.851399,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307987,
      1.518456,
      3.248509,
      1.720830,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.426245,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864907,
      1.552986,
      1.431446,
      1,
      NULL,
      NULL,
      0.925738,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.801413,
      NULL,
      NULL,
      0.880073,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.068654,
      NULL,
      NULL,
      0.980979,
      NULL,
      NULL,
      5,
      0.957349,
      1.226041,
      1,
      NULL,
      NULL,
      2.466778,
      0,
      2,
      0.635807,
      3,
      1,
      3,
      NULL,
      3,
      5.977890,
      1,
      3,
      3.380565,
      0.256659,
      2.287735,
      1.162799,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3,
      3,
      2,
      NULL,
      4,
      2,
      0.489917,
      0,
      3.957237,
      1,
      NULL,
      NULL,
      1.565277,
      1.714415,
      1,
      0.826953,
      0,
      0.204323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.008444,
      3,
      1,
      NULL,
      2.038087,
      0.113267,
      NULL,
      NULL,
      0.776319,
      NULL,
      NULL,
      NULL,
      1.539049,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.669252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.923198,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.088514,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.927326,
      NULL,
      NULL,
      NULL,
      0.428718,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.068460,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.150665,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.458919,
      0.748666,
      2,
      NULL,
      2.884450,
      0.192317,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.353390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.020068,
      0.622893,
      0.197611,
      NULL,
      0,
      0,
      1.899769,
      0.483206,
      NULL,
      NULL,
      1,
      0.532009,
      NULL,
      0.821503,
      NULL,
      0,
      1.298438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      7,
      2.389372,
      4.137094,
      NULL,
      0,
      9,
      1.970161,
      1,
      0.572029,
      1,
      0,
      NULL,
      0.136078,
      2,
      NULL,
      1,
      1.770391,
      NULL,
      1.620848,
      1,
      NULL,
      1,
      3.358872,
      NULL,
      0,
      0.319510,
      NULL,
      1,
      0.840552,
      NULL,
      0.143391,
      NULL,
      NULL,
      0,
      0.471121,
      NULL,
      1,
      0.846729,
      NULL,
      0,
      1.589452,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.126542,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1.488761,
      NULL,
      3.666515,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.556477,
      NULL,
      0,
      NULL,
      NULL,
      1.264724,
      672,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      53.500898,
      1,
      4.314663,
      2,
      '32203',
      '02212',
      '',
      1,
      '',
      '',
      '',
      1.354373,
      '2324',
      '4022',
      '');
commit;
end;
/


